/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class SupplierRegistry<T> {
    private final String key;
    private final Map<Class<? extends T>, String> byKey;
    private final Map<String, Supplier<? extends T>> keys;

    public SupplierRegistry() {
        this("redstone_multimeter");
    }

    public SupplierRegistry(String key) {
        this.key = key;
        this.byKey = new HashMap<Class<? extends T>, String>();
        this.keys = new HashMap<String, Supplier<? extends T>>();
    }

    public String getRegistryKey() {
        return this.key;
    }

    public T get(String key) {
        Supplier<? extends T> supplier = this.keys.get(key);
        return supplier == null ? null : (T)supplier.get();
    }

    public String getKey(T obj) {
        return this.byKey.get(obj.getClass());
    }

    public <P extends T> void register(String name, Class<P> type, Supplier<P> supplier) {
        String key = this.key + "|" + name;
        if (this.byKey.containsKey(type)) {
            throw new IllegalStateException("Registry " + this.key + " already registered an entry with type " + type);
        }
        if (this.keys.containsKey(key)) {
            throw new IllegalStateException("Registry " + this.key + " already registered an entry with key " + key);
        }
        this.byKey.put(type, key);
        this.keys.put(key, supplier);
    }
}

