/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.server;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.unmapped.C_0539808;
import net.minecraft.unmapped.C_1241852;
import net.minecraft.unmapped.C_3292284;
import net.minecraft.unmapped.C_3622326;
import net.minecraft.unmapped.C_3865296;
import net.minecraft.unmapped.C_5553933;
import redstone.multimeter.block.Meterable;
import redstone.multimeter.block.PowerSource;
import redstone.multimeter.client.gui.text.ClickEvent;
import redstone.multimeter.client.gui.text.Formatting;
import redstone.multimeter.client.gui.text.HoverEvent;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.common.DimPos;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.MeterGroup;
import redstone.multimeter.common.meter.MeterProperties;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.common.meter.event.MeterEvent;
import redstone.multimeter.common.network.RSMMPacket;
import redstone.multimeter.common.network.packets.ClearMeterGroupPacket;
import redstone.multimeter.common.network.packets.MeterGroupDefaultPacket;
import redstone.multimeter.common.network.packets.MeterGroupRefreshPacket;
import redstone.multimeter.common.network.packets.MeterGroupSubscriptionPacket;
import redstone.multimeter.interfaces.mixin.IBlock;
import redstone.multimeter.server.MultimeterServer;
import redstone.multimeter.server.meter.ServerMeterGroup;
import redstone.multimeter.server.meter.ServerMeterPropertiesManager;
import redstone.multimeter.server.meter.event.MeterEventPredicate;
import redstone.multimeter.server.option.Options;
import redstone.multimeter.server.option.OptionsManager;
import redstone.multimeter.util.Direction;

public class Multimeter {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance(Locale.US);
    private final MultimeterServer server;
    private final Map<String, ServerMeterGroup> meterGroups;
    private final Map<UUID, ServerMeterGroup> subscriptions;
    private final Set<ServerMeterGroup> activeMeterGroups;
    private final Set<ServerMeterGroup> idleMeterGroups;
    private final ServerMeterPropertiesManager meterPropertiesManager;
    public Options options;

    public Multimeter(MultimeterServer server) {
        this.server = server;
        this.meterGroups = new LinkedHashMap<String, ServerMeterGroup>();
        this.subscriptions = new HashMap<UUID, ServerMeterGroup>();
        this.activeMeterGroups = new HashSet<ServerMeterGroup>();
        this.idleMeterGroups = new HashSet<ServerMeterGroup>();
        this.meterPropertiesManager = new ServerMeterPropertiesManager(this);
        this.reloadOptions();
    }

    public MultimeterServer getServer() {
        return this.server;
    }

    public Collection<ServerMeterGroup> getMeterGroups() {
        return Collections.unmodifiableCollection(this.meterGroups.values());
    }

    public ServerMeterGroup getMeterGroup(String name) {
        return this.meterGroups.get(name);
    }

    public boolean hasMeterGroup(String name) {
        return this.meterGroups.containsKey(name);
    }

    public ServerMeterGroup getSubscription(C_3292284 player) {
        return this.subscriptions.get(player.m_2013188());
    }

    public boolean hasSubscription(C_3292284 player) {
        return this.subscriptions.containsKey(player.m_2013188());
    }

    public boolean isOwnerOfSubscription(C_3292284 player) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        return meterGroup != null && meterGroup.isOwnedBy(player);
    }

    public void reloadOptions() {
        this.options = this.server.isDedicated() ? OptionsManager.load(this.server.getConfigDirectory()) : new Options();
    }

    public void tickStart(boolean paused) {
        if (!paused) {
            this.removeIdleMeterGroups();
            for (ServerMeterGroup meterGroup : this.meterGroups.values()) {
                meterGroup.tick();
            }
        }
    }

    public void tickEnd(boolean paused) {
        this.broadcastMeterUpdates();
        if (!paused) {
            this.broadcastMeterLogs();
        }
    }

    private void removeIdleMeterGroups() {
        Iterator<ServerMeterGroup> it = this.idleMeterGroups.iterator();
        while (it.hasNext()) {
            ServerMeterGroup meterGroup = it.next();
            if (!this.removeIdleMeterGroup(meterGroup)) continue;
            it.remove();
        }
    }

    private boolean removeIdleMeterGroup(ServerMeterGroup meterGroup) {
        if (meterGroup.hasMeters() && !meterGroup.isPastIdleTimeLimit()) {
            return false;
        }
        this.meterGroups.remove(meterGroup.getName(), meterGroup);
        if (meterGroup.hasMeters()) {
            this.notifyOwnerOfRemoval(meterGroup);
        }
        return true;
    }

    private void notifyOwnerOfRemoval(ServerMeterGroup meterGroup) {
        UUID ownerUuid = meterGroup.getOwner();
        C_3292284 owner = this.server.getPlayerList().get(ownerUuid);
        if (owner != null) {
            Text message = Texts.translatable("rsmm.meterGroup.removed.idle", meterGroup.getName(), this.options.meter_group.max_idle_time);
            this.server.sendMessage(owner, message, false);
        }
    }

    private void broadcastMeterUpdates() {
        for (ServerMeterGroup meterGroup : this.meterGroups.values()) {
            meterGroup.broadcastUpdates();
        }
    }

    private void broadcastMeterLogs() {
        for (ServerMeterGroup meterGroup : this.meterGroups.values()) {
            meterGroup.getLogManager().broadcastLogs();
        }
    }

    public void onPlayerJoin(C_3292284 player) {
        this.server.refreshTickPhaseTree(player);
    }

    public void onPlayerLeave(C_3292284 player) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null) {
            this.removeSubscriberFromMeterGroup(meterGroup, player);
        }
    }

    public void addMeter(C_3292284 player, MeterProperties properties) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null) {
            if (meterGroup.isPastMeterLimit()) {
                Text message = Texts.translatable("rsmm.meterGroup.meterLimitReached", this.options.meter_group.meter_limit);
                this.server.sendMessage(player, message, true);
            } else if (!this.addMeter(meterGroup, properties)) {
                this.refreshMeterGroup(meterGroup, player);
            }
        }
    }

    public boolean addMeter(ServerMeterGroup meterGroup, MeterProperties meterProperties) {
        MeterProperties.MutableMeterProperties properties = meterProperties.mutable();
        if (!this.meterPropertiesManager.validate(properties) || !meterGroup.addMeter(properties)) {
            return false;
        }
        DimPos pos = properties.getPos();
        C_3865296 world = this.server.getWorld(pos);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        C_1241852 block = world.m_9893076(x, y, z);
        int metadata = world.m_5024208(x, y, z);
        this.logPowered((C_5553933)world, x, y, z, block, metadata);
        this.logActive((C_5553933)world, x, y, z, block, metadata);
        return true;
    }

    public void removeMeter(C_3292284 player, long id) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null && !meterGroup.removeMeter(id)) {
            this.refreshMeterGroup(meterGroup, player);
        }
    }

    public void updateMeter(C_3292284 player, long id, MeterProperties newProperties) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null && !meterGroup.updateMeter(id, newProperties)) {
            this.refreshMeterGroup(meterGroup, player);
        }
    }

    public void setMeterIndex(C_3292284 player, long id, int index) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null && !meterGroup.setMeterIndex(id, index)) {
            this.refreshMeterGroup(meterGroup, player);
        }
    }

    public void clearMeterGroup(C_3292284 player) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null) {
            this.clearMeterGroup(meterGroup);
        }
    }

    public void clearMeterGroup(ServerMeterGroup meterGroup) {
        meterGroup.clear();
        ClearMeterGroupPacket packet = new ClearMeterGroupPacket();
        this.server.getPlayerList().send((RSMMPacket)packet, meterGroup);
    }

    public void setMeters(C_3292284 player, List<MeterProperties> meters) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null) {
            if (meterGroup.isOwnedBy(player)) {
                this.setMeters(meterGroup, meters);
            } else {
                Text message = Texts.translatable("rsmm.meterGroups.load.failure.notOwner", meterGroup.getName());
                this.server.sendMessage(player, message, false);
            }
        }
    }

    public void setMeters(ServerMeterGroup meterGroup, List<MeterProperties> meters) {
        this.clearMeterGroup(meterGroup);
        for (MeterProperties meter : meters) {
            this.addMeter(meterGroup, meter);
        }
    }

    public void createMeterGroup(C_3292284 player, String name) {
        if (!MeterGroup.isValidName(name) || this.meterGroups.containsKey(name)) {
            return;
        }
        ServerMeterGroup meterGroup = new ServerMeterGroup(this, name, player);
        this.meterGroups.put(name, meterGroup);
        this.subscribeToMeterGroup(meterGroup, player);
    }

    public void subscribeToMeterGroup(ServerMeterGroup meterGroup, C_3292284 player) {
        ServerMeterGroup prevSubscription = this.getSubscription(player);
        if (prevSubscription == meterGroup) {
            this.refreshMeterGroup(meterGroup, player);
        } else {
            if (prevSubscription != null) {
                this.removeSubscriberFromMeterGroup(prevSubscription, player);
            }
            this.addSubscriberToMeterGroup(meterGroup, player);
            this.onSubscriptionChanged(player, prevSubscription, meterGroup);
        }
    }

    public void subscribeToDefaultMeterGroup(C_3292284 player) {
        MeterGroupDefaultPacket packet = new MeterGroupDefaultPacket();
        this.server.getPlayerList().send((RSMMPacket)packet, player);
    }

    private void addSubscriberToMeterGroup(ServerMeterGroup meterGroup, C_3292284 player) {
        UUID playerUuid = player.m_2013188();
        this.subscriptions.put(playerUuid, meterGroup);
        meterGroup.addSubscriber(playerUuid);
        if (meterGroup.updateIdleState()) {
            this.activeMeterGroups.add(meterGroup);
            this.idleMeterGroups.remove(meterGroup);
        }
    }

    public void unsubscribeFromMeterGroup(C_3292284 player) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null) {
            this.unsubscribeFromMeterGroup(meterGroup, player);
        }
    }

    public void unsubscribeFromMeterGroup(ServerMeterGroup meterGroup, C_3292284 player) {
        if (meterGroup.hasSubscriber(player)) {
            this.removeSubscriberFromMeterGroup(meterGroup, player);
            this.onSubscriptionChanged(player, meterGroup, null);
        }
    }

    private void removeSubscriberFromMeterGroup(ServerMeterGroup meterGroup, C_3292284 player) {
        UUID playerUuid = player.m_2013188();
        this.subscriptions.remove(playerUuid, meterGroup);
        meterGroup.removeSubscriber(playerUuid);
        if (meterGroup.updateIdleState()) {
            this.activeMeterGroups.remove(meterGroup);
            this.idleMeterGroups.add(meterGroup);
        }
    }

    private void onSubscriptionChanged(C_3292284 player, ServerMeterGroup prevSubscription, ServerMeterGroup newSubscription) {
        MeterGroupSubscriptionPacket packet = newSubscription == null ? new MeterGroupSubscriptionPacket(prevSubscription.getName(), false) : new MeterGroupSubscriptionPacket(newSubscription.getName(), true);
        this.server.getPlayerList().send((RSMMPacket)packet, player);
    }

    public void clearMembersOfMeterGroup(ServerMeterGroup meterGroup) {
        for (UUID playerUuid : meterGroup.getMembers()) {
            this.removeMemberFromMeterGroup(meterGroup, playerUuid);
        }
    }

    public void addMemberToMeterGroup(ServerMeterGroup meterGroup, UUID playerUuid) {
        if (meterGroup.hasMember(playerUuid) || meterGroup.isOwnedBy(playerUuid)) {
            return;
        }
        C_3292284 player = this.server.getPlayerList().get(playerUuid);
        if (player == null) {
            return;
        }
        meterGroup.addMember(playerUuid);
        Text message = Texts.translatable("rsmm.meterGroup.member.invited", meterGroup.getName(), Texts.translatable("rsmm.meterGroup.member.invited.here").format(style -> style.withHoverEvent(HoverEvent.showText(Texts.translatable("rsmm.meterGroup.member.invited.subscribe", meterGroup.getName()))).withClickEvent(ClickEvent.runCommand(String.format("/metergroup subscribe %s", meterGroup.getName()))).withColor(Formatting.GREEN)));
        this.server.sendMessage(player, message, false);
    }

    public void removeMemberFromMeterGroup(ServerMeterGroup meterGroup, UUID playerUuid) {
        C_3292284 player;
        if (!meterGroup.hasMember(playerUuid)) {
            return;
        }
        meterGroup.removeMember(playerUuid);
        if (meterGroup.isPrivate() && (player = this.server.getPlayerList().get(playerUuid)) != null && meterGroup.hasSubscriber(playerUuid)) {
            this.unsubscribeFromMeterGroup(meterGroup, player);
            Text message = Texts.translatable("rsmm.meterGroup.member.removed", meterGroup.getName());
            this.server.sendMessage(player, message, false);
        }
    }

    public void refreshMeterGroup(C_3292284 player) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null) {
            this.refreshMeterGroup(meterGroup, player);
        }
    }

    private void refreshMeterGroup(ServerMeterGroup meterGroup, C_3292284 player) {
        MeterGroupRefreshPacket packet = new MeterGroupRefreshPacket(meterGroup);
        this.server.getPlayerList().send((RSMMPacket)packet, player);
    }

    public void teleportToMeter(C_3292284 player, long id) {
        DimPos pos;
        C_3865296 newWorld;
        Meter meter;
        if (!this.options.meter.allow_teleports) {
            Text message = Texts.translatable("rsmm.meter.teleport.notAllowed");
            this.server.sendMessage(player, message, false);
            return;
        }
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null && (meter = meterGroup.getMeter(id)) != null && (newWorld = this.server.getWorld(pos = meter.getPos())) != null) {
            int blockX = pos.getX();
            int blockY = pos.getY();
            int blockZ = pos.getZ();
            double newX = (double)blockX + 0.5;
            double newY = blockY;
            double newZ = (double)blockZ + 0.5;
            float newYaw = player.f_7165431;
            float newPitch = player.f_0243146;
            if (player.f_4703454.f_6669533.f_8006473 != newWorld.f_6669533.f_8006473) {
                player.m_7375837(newWorld.f_6669533.f_8006473);
            }
            player.f_2111610.m_7846276(newX, newY, newZ, newYaw, newPitch);
            Text text = Texts.translatable("rsmm.meter.teleport.success", meter.getName());
            this.server.sendMessage(player, text, false);
        }
    }

    public void onBlockChange(C_5553933 world, int x, int y, int z, C_1241852 oldBlock, int oldMetadata, C_1241852 newBlock, int newMetadata) {
        if (oldBlock.m_9214095(newBlock)) {
            if (((IBlock)newBlock).rsmm$isPowerSource() && ((PowerSource)newBlock).rsmm$logPowerChangeOnStateChange()) {
                this.logPowerChange(world, x, y, z, oldBlock, oldMetadata, newBlock, newMetadata);
            }
            this.logDataChange(world, x, y, z, oldMetadata, newMetadata);
        }
        boolean wasMeterable = ((IBlock)oldBlock).rsmm$isMeterable();
        boolean isMeterable = ((IBlock)newBlock).rsmm$isMeterable();
        if (wasMeterable || isMeterable) {
            this.logActive(world, x, y, z, newBlock, newMetadata);
        }
    }

    public void logPowered(C_5553933 world, int x, int y, int z, boolean powered) {
        this.tryLogEvent(world, x, y, z, EventType.POWERED, powered ? 1 : 0, (ServerMeterGroup meterGroup, Meter meter, MeterEvent event) -> meter.setPowered(powered));
    }

    public void logPowered(C_5553933 world, int x, int y, int z, C_1241852 block, int metadata) {
        this.tryLogEvent(world, x, y, z, EventType.POWERED, (Supplier<Integer>)((Supplier)() -> ((IBlock)block).rsmm$isPowered(world, x, y, z, metadata) ? 1 : 0), (ServerMeterGroup meterGroup, Meter meter, MeterEvent event) -> meter.setPowered(event.getMetadata() != 0));
    }

    public void logActive(C_5553933 world, int x, int y, int z, boolean active) {
        this.tryLogEvent(world, x, y, z, EventType.ACTIVE, active ? 1 : 0, (ServerMeterGroup meterGroup, Meter meter, MeterEvent event) -> meter.setActive(active));
    }

    public void logActive(C_5553933 world, int x, int y, int z, C_1241852 block, int metadata) {
        this.tryLogEvent(world, x, y, z, EventType.ACTIVE, (Supplier<Integer>)((Supplier)() -> ((IBlock)block).rsmm$isMeterable() && ((Meterable)block).rsmm$isActive(world, x, y, z, metadata) ? 1 : 0), (ServerMeterGroup meterGroup, Meter meter, MeterEvent event) -> meter.setActive(event.getMetadata() != 0));
    }

    public void logMoved(C_5553933 world, int x, int y, int z, Direction dir) {
        this.tryLogEvent(world, x, y, z, EventType.MOVED, dir.getIndex());
    }

    public void moveMeters(C_5553933 world, int x, int y, int z, Direction dir) {
        DimPos pos = new DimPos(world, x, y, z);
        for (ServerMeterGroup meterGroup : this.activeMeterGroups) {
            meterGroup.tryMoveMeter(pos, dir);
        }
    }

    public void logPowerChange(C_5553933 world, int x, int y, int z, int oldPower, int newPower) {
        if (oldPower != newPower) {
            this.tryLogEvent(world, x, y, z, EventType.POWER_CHANGE, oldPower << 8 | newPower);
        }
    }

    public void logPowerChange(C_5553933 world, int x, int y, int z, C_1241852 oldBlock, int oldMetadata, C_1241852 newBlock, int newMetadata) {
        this.tryLogEvent(world, x, y, z, EventType.POWER_CHANGE, (Supplier<Integer>)((Supplier)() -> {
            int oldPower = ((PowerSource)oldBlock).rsmm$getPowerLevel(world, x, y, z, oldMetadata);
            int newPower = ((PowerSource)newBlock).rsmm$getPowerLevel(world, x, y, z, newMetadata);
            return oldPower << 8 | newPower;
        }), (ServerMeterGroup meterGroup, Meter meter, MeterEvent event) -> {
            int newPower;
            int data = event.getMetadata();
            int oldPower = data >> 8 & 0xFF;
            return oldPower != (newPower = data & 0xFF);
        });
    }

    public void logRandomTick(C_5553933 world, int x, int y, int z) {
        this.tryLogEvent(world, x, y, z, EventType.RANDOM_TICK);
    }

    public void logScheduledTick(C_5553933 world, int x, int y, int z, int priority, boolean scheduling) {
        this.tryLogEvent(world, x, y, z, EventType.SCHEDULED_TICK, (scheduling ? 0x40000000 : 0) | priority + 3);
    }

    public void logBlockEvent(C_5553933 world, int x, int y, int z, int type, int depth, boolean queueing) {
        this.tryLogEvent(world, x, y, z, EventType.BLOCK_EVENT, (queueing ? 0x40000000 : 0) | depth << 4 | type);
    }

    public void logEntityTick(C_5553933 world, C_0539808 entity) {
        this.tryLogEvent(world, (int)entity.f_6638345, (int)entity.f_1187082, (int)entity.f_9103758, EventType.ENTITY_TICK);
    }

    public void logBlockEntityTick(C_5553933 world, C_3622326 blockEntity) {
        this.tryLogEvent(world, blockEntity.f_4390267, blockEntity.f_7270670, blockEntity.f_7068054, EventType.BLOCK_ENTITY_TICK);
    }

    public void logBlockUpdate(C_5553933 world, int x, int y, int z) {
        this.tryLogEvent(world, x, y, z, EventType.BLOCK_UPDATE);
    }

    public void logComparatorUpdate(C_5553933 world, int x, int y, int z) {
        this.tryLogEvent(world, x, y, z, EventType.COMPARATOR_UPDATE);
    }

    public void logShapeUpdate(C_5553933 world, int x, int y, int z, Direction dir) {
        this.tryLogEvent(world, x, y, z, EventType.SHAPE_UPDATE, dir.getIndex());
    }

    public void logObserverUpdate(C_5553933 world, int x, int y, int z) {
        this.tryLogEvent(world, x, y, z, EventType.OBSERVER_UPDATE);
    }

    public void logInteractBlock(C_5553933 world, int x, int y, int z) {
        this.tryLogEvent(world, x, y, z, EventType.INTERACT_BLOCK);
    }

    public void logDataChange(C_5553933 world, int x, int y, int z, int oldMetadata, int newMetadata) {
        this.tryLogEvent(world, x, y, z, EventType.BLOCK_DATA_CHANGE, oldMetadata << 8 | newMetadata, (ServerMeterGroup meterGroup, Meter meter, MeterEvent event) -> {
            int newData;
            int data = event.getMetadata();
            int oldData = data >> 8 & 0xFF;
            return oldData != (newData = data & 0xFF);
        });
    }

    private void tryLogEvent(C_5553933 world, int x, int y, int z, EventType type) {
        this.tryLogEvent(world, x, y, z, type, 0);
    }

    private void tryLogEvent(C_5553933 world, int x, int y, int z, EventType type, int data) {
        this.tryLogEvent(world, x, y, z, type, data, (ServerMeterGroup meterGroup, Meter meter, MeterEvent event) -> true);
    }

    private void tryLogEvent(C_5553933 world, int x, int y, int z, EventType type, int data, MeterEventPredicate predicate) {
        this.tryLogEvent(world, x, y, z, type, (Supplier<Integer>)Suppliers.memoize(() -> data), predicate);
    }

    private void tryLogEvent(C_5553933 world, int x, int y, int z, EventType type, Supplier<Integer> data, MeterEventPredicate predicate) {
        if (this.options.hasEventType(type)) {
            for (ServerMeterGroup meterGroup : this.activeMeterGroups) {
                meterGroup.tryLogEvent(world, x, y, z, type, data, predicate);
            }
        }
    }

    static {
        NUMBER_FORMAT.setGroupingUsed(false);
    }
}

