/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.server;

import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.unmapped.C_1241852;
import net.minecraft.unmapped.C_3292284;
import net.minecraft.unmapped.C_3865296;
import net.minecraft.unmapped.C_5553933;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.common.DimPos;
import redstone.multimeter.common.TickPhase;
import redstone.multimeter.common.TickPhaseTree;
import redstone.multimeter.common.TickTask;
import redstone.multimeter.common.network.RSMMPacket;
import redstone.multimeter.common.network.packets.HandshakePacket;
import redstone.multimeter.common.network.packets.TickPhaseTreePacket;
import redstone.multimeter.common.network.packets.TickTimePacket;
import redstone.multimeter.interfaces.mixin.IMinecraftServer;
import redstone.multimeter.server.Multimeter;
import redstone.multimeter.server.PlayerList;
import redstone.multimeter.server.ServerPacketHandler;
import redstone.multimeter.util.Dimensions;

public class MultimeterServer {
    private final MinecraftServer server;
    private final ServerPacketHandler packetHandler;
    private final PlayerList playerList;
    private final Multimeter multimeter;
    private final TickPhaseTree tickPhaseTree;
    private boolean loaded;
    private TickPhase tickPhase;

    public MultimeterServer(MinecraftServer server) {
        this.server = server;
        this.packetHandler = new ServerPacketHandler(this);
        this.playerList = new PlayerList(this);
        this.multimeter = new Multimeter(this);
        this.tickPhaseTree = new TickPhaseTree();
        this.tickPhase = TickPhase.UNKNOWN;
    }

    public MinecraftServer getMinecraftServer() {
        return this.server;
    }

    public ServerPacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    public Multimeter getMultimeter() {
        return this.multimeter;
    }

    public TickPhaseTree getTickPhaseTree() {
        return this.tickPhaseTree;
    }

    public long getTicks() {
        return this.server.m_2752854();
    }

    public boolean isDedicated() {
        return this.server.m_9852120();
    }

    public Path getConfigDirectory() {
        return this.server.m_8498077("config/redstone_multimeter").toPath();
    }

    public TickPhase getTickPhase() {
        return this.tickPhase;
    }

    public void worldLoaded() {
        this.loaded = true;
    }

    public void startTickTask(TickTask task, String ... args) {
        this.tickPhase = this.tickPhase.startTask(task);
        if (this.tickPhaseTree.isBuilding()) {
            this.tickPhaseTree.startTask(task, args);
        }
    }

    public void endTickTask() {
        this.tickPhase = this.tickPhase.endTask();
        if (this.tickPhaseTree.isBuilding()) {
            this.tickPhaseTree.endTask();
        }
    }

    public void swapTickTask(TickTask task, String ... args) {
        this.tickPhase = this.tickPhase.swapTask(task);
        if (this.tickPhaseTree.isBuilding()) {
            this.tickPhaseTree.swapTask(task, args);
        }
    }

    public TickTask getCurrentTickTask() {
        return this.tickPhase.peekTask();
    }

    public boolean isPaused() {
        return ((IMinecraftServer)this.server).rsmm$isPaused();
    }

    public boolean isPausedOrFrozen() {
        return this.isPaused();
    }

    public void tickStart() {
        boolean paused = this.isPaused();
        if (!paused) {
            if (this.shouldBuildTickPhaseTree()) {
                this.tickPhaseTree.start();
            }
            this.playerList.tick();
        }
        this.tickPhase = TickPhase.UNKNOWN;
        this.multimeter.tickStart(paused);
    }

    private boolean shouldBuildTickPhaseTree() {
        return this.loaded && !this.tickPhaseTree.isComplete() && !this.tickPhaseTree.isBuilding() && !this.isPausedOrFrozen() && !this.playerList.get().isEmpty();
    }

    public void tickEnd() {
        boolean paused = this.isPaused();
        if (this.tickPhaseTree.isBuilding()) {
            this.tickPhaseTree.end();
        }
        this.tickPhase = TickPhase.UNKNOWN;
        this.multimeter.tickEnd(paused);
    }

    public void tickTime(C_5553933 world) {
        TickTimePacket packet = new TickTimePacket(world.m_0604488());
        this.playerList.send((RSMMPacket)packet, world.f_6669533.f_8006473);
    }

    public void onHandshake(C_3292284 player, String modVersion) {
        if (!this.playerList.has(player.m_2013188())) {
            this.playerList.add(player);
            HandshakePacket packet = new HandshakePacket();
            this.playerList.send((RSMMPacket)packet, player);
        }
    }

    public void onPlayerJoin(C_3292284 player) {
        this.multimeter.onPlayerJoin(player);
    }

    public void onPlayerLeave(C_3292284 player) {
        this.multimeter.onPlayerLeave(player);
    }

    public void refreshTickPhaseTree(C_3292284 player) {
        if (this.tickPhaseTree.isComplete()) {
            TickPhaseTreePacket packet = new TickPhaseTreePacket(this.tickPhaseTree.toNbt());
            this.playerList.send((RSMMPacket)packet, player);
        }
    }

    public void rebuildTickPhaseTree(C_3292284 player) {
        if (this.tickPhaseTree.isComplete()) {
            this.tickPhaseTree.reset();
        }
    }

    public C_3865296[] getWorlds() {
        return this.server.f_0746062;
    }

    public C_3865296 getWorld(String key) {
        int dimension = (Integer)Dimensions.REGISTRY.m_6111517(key);
        return this.server.m_4667880(dimension);
    }

    public C_3865296 getWorld(DimPos pos) {
        return this.getWorld(pos.getDimension());
    }

    public C_1241852 getBlock(DimPos pos) {
        C_3865296 world = this.getWorld(pos);
        if (world == null) {
            return null;
        }
        return world.m_9893076(pos.getX(), pos.getY(), pos.getZ());
    }

    public int getBlockMetadata(DimPos pos) {
        C_3865296 world = this.getWorld(pos);
        if (world == null) {
            return 0;
        }
        return world.m_5024208(pos.getX(), pos.getY(), pos.getZ());
    }

    public PlayerList getPlayerList() {
        return this.playerList;
    }

    public boolean isMultimeterClient(UUID uuid) {
        return this.playerList.has(uuid);
    }

    public boolean isMultimeterClient(C_3292284 player) {
        return this.playerList.has(player.m_2013188());
    }

    public void sendMessage(C_3292284 player, Text message, boolean actionBar) {
        if (actionBar) {
            message = Texts.actionBar(message);
        }
        player.m_9290236(message.resolve());
    }
}

