/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.unmapped.C_3292284;
import net.minecraft.unmapped.C_5385258;
import redstone.multimeter.common.network.RSMMPacket;
import redstone.multimeter.server.MultimeterServer;
import redstone.multimeter.server.meter.ServerMeterGroup;

public class PlayerList {
    private final MultimeterServer server;
    private final Map<UUID, C_3292284> playersByUuid;
    private final Map<String, C_3292284> playersByName;
    private final Map<UUID, String> nameCache;

    public PlayerList(MultimeterServer server) {
        this.server = server;
        this.playersByUuid = new HashMap<UUID, C_3292284>();
        this.playersByName = new HashMap<String, C_3292284>();
        this.nameCache = new HashMap<UUID, String>();
    }

    public MultimeterServer getServer() {
        return this.server;
    }

    public void tick() {
        if (this.server.getTicks() % 72000L == 0L) {
            this.cleanNameCache();
        }
    }

    private void cleanNameCache() {
        Collection<ServerMeterGroup> meterGroups = this.server.getMultimeter().getMeterGroups();
        this.nameCache.keySet().removeIf(uuid -> {
            for (ServerMeterGroup meterGroup : meterGroups) {
                if (!meterGroup.hasMember((UUID)uuid)) continue;
                return false;
            }
            return true;
        });
    }

    public void add(C_3292284 player) {
        if (!this.has(player.m_2013188())) {
            this.playersByUuid.put(player.m_2013188(), player);
            this.playersByName.put(player.m_6689989(), player);
            this.nameCache.remove(player.m_2013188());
            this.server.onPlayerJoin(player);
        }
    }

    public void remove(C_3292284 player) {
        if (this.has(player.m_2013188())) {
            this.playersByUuid.remove(player.m_2013188());
            this.playersByName.remove(player.m_6689989());
            this.nameCache.put(player.m_2013188(), player.m_6689989());
            this.server.onPlayerLeave(player);
        }
    }

    public void respawn(C_3292284 player) {
        if (this.has(player.m_2013188())) {
            this.playersByUuid.put(player.m_2013188(), player);
            this.playersByName.put(player.m_6689989(), player);
        }
    }

    public Collection<C_3292284> get() {
        return this.playersByUuid.values();
    }

    public C_3292284 get(UUID uuid) {
        return this.playersByUuid.get(uuid);
    }

    public C_3292284 get(String name) {
        return this.playersByName.get(name);
    }

    public boolean has(UUID uuid) {
        return this.playersByUuid.containsKey(uuid);
    }

    public boolean has(String name) {
        return this.playersByName.containsKey(name);
    }

    public String getName(UUID uuid) {
        C_3292284 player = this.get(uuid);
        return player == null ? this.nameCache.get(uuid) : player.m_6689989();
    }

    public void send(RSMMPacket packet) {
        this.send(packet, (C_3292284 player) -> true);
    }

    public void send(RSMMPacket packet, ServerMeterGroup meterGroup) {
        this.send(packet, (C_3292284 player) -> meterGroup.hasSubscriber((C_3292284)player));
    }

    public void send(RSMMPacket packet, int dimension) {
        this.send(packet, (C_3292284 player) -> player.f_4703454.f_6669533.f_8006473 == dimension);
    }

    public void send(RSMMPacket packet, Predicate<C_3292284> predicate) {
        C_5385258 mcPacket = this.server.getPacketHandler().encode(packet);
        for (C_3292284 player : this.playersByUuid.values()) {
            if (!predicate.test(player)) continue;
            player.f_2111610.m_3258329(mcPacket);
        }
    }

    public void send(RSMMPacket packet, C_3292284 player) {
        C_5385258 mcPacket = this.server.getPacketHandler().encode(packet);
        player.f_2111610.m_3258329(mcPacket);
    }
}

