/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.server.meter;

import com.google.common.base.Supplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.unmapped.C_3292284;
import net.minecraft.unmapped.C_3865296;
import net.minecraft.unmapped.C_5553933;
import redstone.multimeter.common.DimPos;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.MeterGroup;
import redstone.multimeter.common.meter.MeterProperties;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.common.meter.event.MeterEvent;
import redstone.multimeter.common.network.RSMMPacket;
import redstone.multimeter.common.network.packets.MeterUpdatesPacket;
import redstone.multimeter.server.Multimeter;
import redstone.multimeter.server.meter.event.MeterEventPredicate;
import redstone.multimeter.server.meter.log.ServerLogManager;
import redstone.multimeter.util.Direction;

public class ServerMeterGroup
extends MeterGroup {
    private final Multimeter multimeter;
    private final ServerLogManager logManager;
    private final UUID owner;
    private final Set<UUID> members;
    private final Set<UUID> subscribers;
    private final List<Long> removedMeters;
    private final Map<Long, MeterProperties> meterUpdates;
    private boolean meterIndicesChanged;
    private boolean isPrivate;
    private boolean idle;
    private long idleTime;

    public ServerMeterGroup(Multimeter multimeter, String name, C_3292284 owner) {
        super(name);
        this.multimeter = multimeter;
        this.logManager = new ServerLogManager(this);
        this.owner = owner.m_2013188();
        this.members = new HashSet<UUID>();
        this.subscribers = new HashSet<UUID>();
        this.removedMeters = new ArrayList<Long>();
        this.meterUpdates = new LinkedHashMap<Long, MeterProperties>();
        this.isPrivate = false;
        this.idle = true;
        this.idleTime = 0L;
    }

    @Override
    public void clear() {
        super.clear();
        this.removedMeters.clear();
        this.meterUpdates.clear();
    }

    @Override
    protected void moveMeter(Meter meter, DimPos newPos) {
        if (this.hasMeterAt(newPos)) {
            return;
        }
        C_3865296 world = this.multimeter.getServer().getWorld(newPos);
        if (world == null) {
            return;
        }
        super.moveMeter(meter, newPos);
    }

    @Override
    protected void meterAdded(Meter meter) {
        this.meterUpdates.put(meter.getId(), meter.getProperties());
    }

    @Override
    protected void meterRemoved(Meter meter) {
        this.removedMeters.add(meter.getId());
        this.meterUpdates.remove(meter.getId());
    }

    @Override
    protected void meterUpdated(Meter meter) {
        this.meterUpdates.put(meter.getId(), meter.getProperties());
    }

    @Override
    protected void indexChanged(Meter meter) {
        this.meterIndicesChanged = true;
    }

    @Override
    public ServerLogManager getLogManager() {
        return this.logManager;
    }

    public Multimeter getMultimeter() {
        return this.multimeter;
    }

    public boolean addMeter(MeterProperties.MutableMeterProperties properties) {
        return this.addMeter(new Meter(properties));
    }

    public boolean removeMeter(long id) {
        return this.hasMeter(id) && this.removeMeter(this.getMeter(id));
    }

    public boolean updateMeter(long id, MeterProperties newProperties) {
        return this.hasMeter(id) && this.updateMeter(this.getMeter(id), newProperties);
    }

    public void tryMoveMeter(DimPos pos, Direction dir) {
        if (!this.hasMeterAt(pos)) {
            return;
        }
        Meter meter = this.getMeterAt(pos);
        if (!meter.isMovable()) {
            return;
        }
        this.moveMeter(meter, pos.offset(dir));
    }

    public boolean setMeterIndex(long id, int index) {
        return this.hasMeter(id) && this.setIndex(this.getMeter(id), index);
    }

    public boolean isPastMeterLimit() {
        int limit = this.multimeter.options.meter_group.meter_limit;
        return limit >= 0 && this.getMeters().size() >= limit;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public boolean isOwnedBy(C_3292284 player) {
        return this.isOwnedBy(player.m_2013188());
    }

    public boolean isOwnedBy(UUID playerUuid) {
        return this.owner.equals(playerUuid);
    }

    public boolean hasMembers() {
        return !this.members.isEmpty();
    }

    public Collection<UUID> getMembers() {
        return Collections.unmodifiableCollection(this.members);
    }

    public boolean hasMember(C_3292284 player) {
        return this.hasMember(player.m_2013188());
    }

    public boolean hasMember(UUID playerUuid) {
        return this.members.contains(playerUuid);
    }

    public void addMember(UUID playerUuid) {
        this.members.add(playerUuid);
    }

    public void removeMember(UUID playerUuid) {
        this.members.remove(playerUuid);
    }

    public void clearMembers() {
        this.members.clear();
    }

    public boolean hasSubscribers() {
        return !this.subscribers.isEmpty();
    }

    public Collection<UUID> getSubscribers() {
        return Collections.unmodifiableCollection(this.subscribers);
    }

    public boolean hasSubscriber(C_3292284 player) {
        return this.hasSubscriber(player.m_2013188());
    }

    public boolean hasSubscriber(UUID playerUuid) {
        return this.subscribers.contains(playerUuid);
    }

    public void addSubscriber(UUID playerUuid) {
        this.subscribers.add(playerUuid);
    }

    public void removeSubscriber(UUID playerUuid) {
        this.subscribers.remove(playerUuid);
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
        if (isPrivate) {
            for (UUID playerUuid : this.subscribers) {
                if (playerUuid == this.owner) continue;
                this.addMember(playerUuid);
            }
        }
    }

    public boolean isIdle() {
        return this.idle;
    }

    public long getIdleTime() {
        return this.idleTime;
    }

    public boolean updateIdleState() {
        boolean wasIdle = this.idle;
        boolean bl = this.idle = !this.hasSubscribers();
        if (wasIdle && !this.idle) {
            this.idleTime = 0L;
        }
        return wasIdle != this.idle;
    }

    public boolean isPastIdleTimeLimit() {
        return this.idle && this.multimeter.options.meter_group.max_idle_time >= 0 && this.idleTime > (long)this.multimeter.options.meter_group.max_idle_time;
    }

    public void tick() {
        if (this.idle) {
            ++this.idleTime;
        }
    }

    public void broadcastUpdates() {
        if (this.removedMeters.isEmpty() && this.meterUpdates.isEmpty() && !this.meterIndicesChanged) {
            return;
        }
        LinkedList<Long> meters = new LinkedList<Long>();
        if (this.meterIndicesChanged) {
            for (Meter meter : this.getMeters()) {
                meters.add(meter.getId());
            }
        }
        MeterUpdatesPacket packet = new MeterUpdatesPacket(this.removedMeters, this.meterUpdates, meters);
        this.multimeter.getServer().getPlayerList().send((RSMMPacket)packet, this);
        this.removedMeters.clear();
        this.meterUpdates.clear();
        this.meterIndicesChanged = false;
    }

    public void tryLogEvent(C_5553933 world, int x, int y, int z, EventType type, Supplier<Integer> data, MeterEventPredicate predicate) {
        MeterEvent event;
        DimPos pos = new DimPos(world, x, y, z);
        Meter meter = this.getMeterAt(pos);
        if (meter != null && meter.isMetering(type) && predicate.test(this, meter, event = new MeterEvent(type, (Integer)data.get()))) {
            this.logManager.logEvent(world, meter, event);
        }
    }
}

