/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.server.meter.log;

import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import net.minecraft.unmapped.C_2018497;
import net.minecraft.unmapped.C_3225627;
import net.minecraft.unmapped.C_3865296;
import net.minecraft.unmapped.C_5553933;
import net.minecraft.unmapped.C_5693434;
import redstone.multimeter.common.TickPhase;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.event.MeterEvent;
import redstone.multimeter.common.meter.log.EventLog;
import redstone.multimeter.common.meter.log.LogManager;
import redstone.multimeter.common.network.RSMMPacket;
import redstone.multimeter.common.network.packets.MeterLogsPacket;
import redstone.multimeter.server.meter.ServerMeterGroup;

public class ServerLogManager
extends LogManager {
    private final ServerMeterGroup meterGroup;
    private final Long2IntMap subticks;
    private long cutoff;
    private int unsentLogs;

    public ServerLogManager(ServerMeterGroup meterGroup) {
        this.meterGroup = meterGroup;
        this.subticks = new Long2IntLinkedOpenHashMap();
        this.cutoff = -1L;
    }

    @Override
    protected ServerMeterGroup getMeterGroup() {
        return this.meterGroup;
    }

    @Override
    public void clearLogs() {
        super.clearLogs();
        this.subticks.clear();
        this.cutoff = -1L;
        this.unsentLogs = 0;
    }

    public void tick() {
        this.cutoff = Long.MAX_VALUE;
        for (C_3865296 world : this.meterGroup.getMultimeter().getServer().getWorlds()) {
            long gameTime = world.m_0604488();
            if (gameTime >= this.cutoff) continue;
            this.cutoff = gameTime;
        }
        this.subticks.long2IntEntrySet().removeIf(e -> e.getLongKey() < this.cutoff);
    }

    private int nextSubtick(long tick) {
        return this.subticks.compute(tick, (key, value) -> {
            int n;
            if (value == null) {
                n = 0;
            } else {
                value = value + 1;
                n = value;
            }
            return n;
        });
    }

    public void logEvent(C_5553933 world, Meter meter, MeterEvent event) {
        long tick = world.m_0604488();
        int subtick = this.nextSubtick(tick);
        TickPhase phase = this.meterGroup.getMultimeter().getServer().getTickPhase();
        meter.getLogs().add(new EventLog(tick, subtick, phase, event));
        ++this.unsentLogs;
    }

    public void broadcastLogs() {
        if (this.unsentLogs == 0) {
            return;
        }
        C_5693434 list = new C_5693434();
        for (Meter meter : this.meterGroup.getMeters()) {
            if (meter.getLogs().isEmpty()) continue;
            long id = meter.getId();
            C_2018497 logs = meter.getLogs().toNbt();
            C_2018497 nbt = new C_2018497();
            nbt.m_7177295("id", id);
            nbt.m_2972230("logs", (C_3225627)logs);
            nbt.m_0815577("powered", meter.isPowered());
            nbt.m_0815577("active", meter.isActive());
            list.m_0728373((C_3225627)nbt);
            meter.getLogs().clear();
        }
        if (list.m_8051737() == 0) {
            return;
        }
        MeterLogsPacket packet = new MeterLogsPacket(list);
        this.meterGroup.getMultimeter().getServer().getPlayerList().send((RSMMPacket)packet, this.meterGroup);
        this.unsentLogs = 0;
    }
}

