/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.server.option;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.server.option.Options;

public class OptionsManager {
    private static final String FILE_NAME = "options.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static Options load(Path dir) {
        Path file = dir.resolve(FILE_NAME);
        return OptionsManager.validate(Files.exists(file, new LinkOption[0]) ? OptionsManager.read(file) : OptionsManager.write(file));
    }

    private static Options read(Path file) {
        Options options;
        block8: {
            BufferedReader br = Files.newBufferedReader(file);
            try {
                options = (Options)GSON.fromJson((Reader)br, Options.class);
                if (br == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new Options();
                }
            }
            br.close();
        }
        return options;
    }

    private static Options write(Path file) {
        Path dir = file.getParent();
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("unable to create config directory", e);
            }
        }
        Options options = new Options();
        try (BufferedWriter bw = Files.newBufferedWriter(file, new OpenOption[0]);){
            bw.write(GSON.toJson((Object)options));
        }
        catch (IOException e) {
            throw new RuntimeException("exception while saving options", e);
        }
        return options;
    }

    private static Options validate(Options options) {
        switch (options.event_types.allowed) {
            case "all": {
                break;
            }
            case "blacklist": {
                for (String name : options.event_types.blacklist) {
                    EventType type = EventType.byLegacyKey(name);
                    if (type == null) continue;
                    options.enabledEventTypes &= ~type.flag();
                }
                break;
            }
            case "whitelist": {
                options.enabledEventTypes = 0;
                for (String name : options.event_types.whitelist) {
                    EventType type = EventType.byLegacyKey(name);
                    if (type == null) continue;
                    options.enabledEventTypes |= type.flag();
                }
                break;
            }
            default: {
                throw new IllegalStateException("unknown event types filter " + options.event_types.allowed);
            }
        }
        return options;
    }
}

