/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.util;

public enum Direction {
    DOWN(Axis.Y, 0, 1, 0, -1, 0, "down"),
    UP(Axis.Y, 1, 0, 0, 1, 0, "up"),
    NORTH(Axis.Z, 2, 3, 0, 0, -1, "north"),
    SOUTH(Axis.Z, 3, 2, 0, 0, 1, "south"),
    WEST(Axis.X, 4, 5, -1, 0, 0, "west"),
    EAST(Axis.X, 5, 4, 1, 0, 0, "east");

    public static final Direction[] ALL;
    private final Axis axis;
    private final int index;
    private final int opposite;
    private final int offsetX;
    private final int offsetY;
    private final int offsetZ;
    private final String name;

    private Direction(Axis axis, int index, int opposite, int offsetX, int offsetY, int offsetZ, String name) {
        this.axis = axis;
        this.index = index;
        this.opposite = opposite;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.name = name;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public int getIndex() {
        return this.index;
    }

    public static Direction fromIndex(int index) {
        if (index < 0 && index >= ALL.length) {
            return null;
        }
        return ALL[index];
    }

    public Direction getOpposite() {
        return ALL[this.opposite];
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public int getOffsetZ() {
        return this.offsetZ;
    }

    public String getName() {
        return this.name;
    }

    static {
        ALL = new Direction[Direction.values().length];
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; i < n; ++i) {
            Direction dir;
            Direction.ALL[dir.index] = dir = directionArray[i];
        }
    }

    public static enum Axis {
        X("x"){

            @Override
            public int choose(int x, int y, int z) {
                return x;
            }
        }
        ,
        Y("y"){

            @Override
            public int choose(int x, int y, int z) {
                return y;
            }
        }
        ,
        Z("z"){

            @Override
            public int choose(int x, int y, int z) {
                return z;
            }
        };

        private final String name;

        private Axis(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public abstract int choose(int var1, int var2, int var3);
    }
}

