/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;
import redstone.multimeter.RedstoneMultimeterMod;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.interfaces.mixin.IKeyMapping;

public class Keybinds {
    private static final String FILE_NAME = "hotkeys.txt";
    private static final Set<String> CATEGORIES = new LinkedHashSet<String>();
    private static final Map<String, class_304> KEYBINDS = new LinkedHashMap<String, class_304>();
    private static final Map<String, class_304> LEGACY_KEYBINDS = new HashMap<String, class_304>();
    public static final class_304[] TOGGLE_EVENT_TYPES = new class_304[EventType.ALL.length];
    public static final String MAIN = Keybinds.registerCategory("redstoneMultimeter");
    public static final String METER_EVENT_TYPES = Keybinds.registerCategory("meterEventTypes");
    public static final class_304 TOGGLE_METER = Keybinds.registerKeybind("toggleMeter", "Toggle Meter", MAIN, 77);
    public static final class_304 RESET_METER = Keybinds.registerKeybind("resetMeter", "Reset Meter", MAIN, 66);
    public static final class_304 LOAD_METER_GROUP = Keybinds.registerKeybind("loadMeterGroup", "Load Meter Group", MAIN, 91);
    public static final class_304 SAVE_METER_GROUP = Keybinds.registerKeybind("saveMeterGroup", "Save Meter Group", MAIN, 93);
    public static final class_304 PAUSE_TIMELINE = Keybinds.registerKeybind("pauseTimeline", "Pause Meters", MAIN, 78);
    public static final class_304 TOGGLE_FOCUS_MODE;
    public static final class_304 TOGGLE_MARKER;
    public static final class_304 STEP_BACKWARD;
    public static final class_304 STEP_FORWARD;
    public static final class_304 SCROLL_HUD;
    public static final class_304 TOGGLE_HUD;
    public static final class_304 OPEN_MULTIMETER_SCREEN;
    public static final class_304 OPEN_METER_CONTROLS;
    public static final class_304 OPEN_OPTIONS_MENU;
    public static final class_304 VIEW_TICK_PHASE_TREE;
    public static final class_304 PRINT_LOGS;

    private static String registerCategory(String category) {
        category = "rsmm.keybind.category." + category;
        if (!CATEGORIES.add(category)) {
            throw new IllegalStateException("Cannot register multiple keybind categories with the same name! (" + category + ")");
        }
        return category;
    }

    private static class_304 registerKeybind(String name, String legacyName, String category, int defaultKey) {
        name = "rsmm.keybind." + name;
        if (KEYBINDS.containsKey(name)) {
            throw new IllegalStateException("Cannot register multiple keybinds with the same name! (" + name + ")");
        }
        class_304 keybind = new class_304(name, defaultKey, category);
        KEYBINDS.put(name, keybind);
        if (legacyName != null) {
            LEGACY_KEYBINDS.put(legacyName, keybind);
        }
        return keybind;
    }

    public static Collection<String> getCategories() {
        return Collections.unmodifiableSet(CATEGORIES);
    }

    public static Collection<class_304> getKeybinds() {
        return Collections.unmodifiableCollection(KEYBINDS.values());
    }

    public static void load(Path dir) {
        Path file = dir.resolve(FILE_NAME);
        if (!Files.exists(file, new LinkOption[0])) {
            Keybinds.save(dir);
            return;
        }
        try (BufferedReader br = Files.newBufferedReader(file);){
            String line;
            while ((line = br.readLine()) != null) {
                String[] args = line.split("=", 2);
                if (args.length < 2) continue;
                String name = args[0];
                String key = args[1];
                class_304 keybind = KEYBINDS.get(name);
                if (keybind == null) {
                    keybind = LEGACY_KEYBINDS.get(name);
                }
                if (keybind == null) continue;
                keybind.method_1422(class_3675.method_15981((String)key));
            }
        }
        catch (IOException e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while loading keybinds", (Throwable)e);
        }
    }

    public static void patchLegacyAmecsOptions(Path dir) {
        int p = 14;
        Path file = dir.resolve("options.amecsapi.txt");
        Path tmp = dir.resolve(file.getFileName() + ".tmp");
        if (!Files.exists(file, new LinkOption[0])) {
            return;
        }
        boolean modified = false;
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader br = Files.newBufferedReader(file);){
            Object line;
            while ((line = br.readLine()) != null) {
                String legacyKey;
                class_304 keybind;
                int i = ((String)line).indexOf(58);
                if (i > p && (keybind = LEGACY_KEYBINDS.get(legacyKey = ((String)line).substring(p, i))) != null) {
                    modified = true;
                    line = ((String)line).substring(0, p) + keybind.method_1431() + ((String)line).substring(i);
                }
                lines.add((String)line);
            }
        }
        catch (IOException e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while reading Amecs options", (Throwable)e);
            return;
        }
        if (!modified) {
            return;
        }
        try (BufferedWriter bw = Files.newBufferedWriter(tmp, new OpenOption[0]);){
            for (String line : lines) {
                bw.write(line);
                bw.newLine();
            }
        }
        catch (IOException e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while writing patched Amecs options", (Throwable)e);
            try {
                Files.delete(tmp);
            }
            catch (Exception ee) {
                RedstoneMultimeterMod.LOGGER.warn("exception while deleting patched Amecs options", (Throwable)e);
            }
            return;
        }
        try {
            Files.delete(file);
            Files.copy(tmp, file, new CopyOption[0]);
        }
        catch (IOException e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while saving patched Amecs options", (Throwable)e);
        }
    }

    public static void save(Path dir) {
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("unable to create parent directories of keybinds file", e);
            }
        }
        Path file = dir.resolve(FILE_NAME);
        try (BufferedWriter bw = Files.newBufferedWriter(file, new OpenOption[0]);){
            for (class_304 keybind : KEYBINDS.values()) {
                String name = keybind.method_1431();
                String key = keybind.method_1428();
                bw.write(name + "=" + key);
                bw.newLine();
            }
        }
        catch (IOException e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while saving keybinds", (Throwable)e);
        }
    }

    public static boolean isPressed(class_304 keybind) {
        class_3675.class_306 key = ((IKeyMapping)keybind).rsmm$getKey();
        return key != null && GLFW.glfwGetKey((long)MultimeterClient.MINECRAFT.method_22683().method_4490(), (int)key.method_1444()) == 1;
    }

    static {
        STEP_BACKWARD = Keybinds.registerKeybind("stepBackwardTimeline", "Step Backward", MAIN, 44);
        STEP_FORWARD = Keybinds.registerKeybind("stepForwardTimeline", "Step Forward", MAIN, 46);
        SCROLL_HUD = Keybinds.registerKeybind("scrollTimeline", "Scroll HUD", MAIN, 342);
        TOGGLE_HUD = Keybinds.registerKeybind("toggleHud", "Toggle HUD", MAIN, 72);
        TOGGLE_MARKER = Keybinds.registerKeybind("toggleTickMarker", "Toggle Tick Marker", MAIN, 89);
        TOGGLE_FOCUS_MODE = Keybinds.registerKeybind("toggleFocusMode", "Toggle Focus Mode", MAIN, 70);
        OPEN_MULTIMETER_SCREEN = Keybinds.registerKeybind("openMultimeterScreen", "Open Multimeter Screen", MAIN, 71);
        OPEN_METER_CONTROLS = Keybinds.registerKeybind("openMeterControlsScreen", "Open Meter Controls", MAIN, 73);
        OPEN_OPTIONS_MENU = Keybinds.registerKeybind("openOptionsScreen", "Open Options Menu", MAIN, 79);
        VIEW_TICK_PHASE_TREE = Keybinds.registerKeybind("openTickPhaseTreeScreen", "View Tick Phases", MAIN, 85);
        PRINT_LOGS = Keybinds.registerKeybind("toggleLogPrinter", "Print Logs To File", MAIN, 80);
        for (int index = 0; index < EventType.ALL.length; ++index) {
            Keybinds.TOGGLE_EVENT_TYPES[index] = Keybinds.registerKeybind("toggleMeterEventType." + EventType.byId(index).getKey(), String.format("Toggle '%s'", EventType.byId(index).getLegacyKey()), METER_EVENT_TYPES, -1);
        }
    }
}

