/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client;

import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_638;
import redstone.multimeter.client.ClientPacketHandler;
import redstone.multimeter.client.InputHandler;
import redstone.multimeter.client.SavedMeterGroupsManager;
import redstone.multimeter.client.gui.FontRenderer;
import redstone.multimeter.client.gui.hud.MultimeterHud;
import redstone.multimeter.client.gui.screen.MultimeterScreen;
import redstone.multimeter.client.gui.screen.OptionsScreen;
import redstone.multimeter.client.gui.screen.RSMMScreen;
import redstone.multimeter.client.gui.screen.ScreenWrapper;
import redstone.multimeter.client.gui.screen.TickPhaseTreeScreen;
import redstone.multimeter.client.gui.text.Formatting;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.meter.ClientMeterGroup;
import redstone.multimeter.client.meter.ClientMeterPropertiesManager;
import redstone.multimeter.client.option.Options;
import redstone.multimeter.client.render.MeterRenderer;
import redstone.multimeter.client.tutorial.Tutorial;
import redstone.multimeter.common.DimPos;
import redstone.multimeter.common.TickPhaseTree;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.MeterGroup;
import redstone.multimeter.common.meter.MeterProperties;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.common.network.RSMMPacket;
import redstone.multimeter.common.network.packets.AddMeterPacket;
import redstone.multimeter.common.network.packets.HandshakePacket;
import redstone.multimeter.common.network.packets.MeterGroupRefreshPacket;
import redstone.multimeter.common.network.packets.MeterGroupSubscriptionPacket;
import redstone.multimeter.common.network.packets.MeterUpdatePacket;
import redstone.multimeter.common.network.packets.RebuildTickPhaseTreePacket;
import redstone.multimeter.common.network.packets.RemoveMeterPacket;
import redstone.multimeter.common.network.packets.TickPhaseTreePacket;

public class MultimeterClient {
    public static MultimeterClient INSTANCE;
    public static class_310 MINECRAFT;
    private final class_310 minecraft;
    private final ClientPacketHandler packetHandler;
    private final InputHandler inputHandler;
    private final FontRenderer fontRenderer;
    private final MeterRenderer meterRenderer;
    private final MultimeterHud hud;
    private final SavedMeterGroupsManager savedMeterGroupsManager;
    private final ClientMeterPropertiesManager meterPropertiesManager;
    private final Tutorial tutorial;
    private final TickPhaseTree tickPhaseTree;
    private ClientMeterGroup meterGroup;
    private ClientMeterGroup meterGroupPreview;
    private boolean connected;
    private boolean hudEnabled;
    private long prevGameTime;
    private int pendingMeterGroupSlot = -1;
    private String pendingMeterGroupName = null;

    public MultimeterClient(class_310 minecraft) {
        INSTANCE = this;
        MINECRAFT = minecraft;
        this.minecraft = minecraft;
        this.packetHandler = new ClientPacketHandler(this);
        this.inputHandler = new InputHandler(this);
        this.fontRenderer = new FontRenderer(this);
        this.meterRenderer = new MeterRenderer(this);
        this.hud = new MultimeterHud(this);
        this.savedMeterGroupsManager = new SavedMeterGroupsManager(this);
        this.meterPropertiesManager = new ClientMeterPropertiesManager(this);
        this.tutorial = new Tutorial(this);
        this.tickPhaseTree = new TickPhaseTree();
        this.meterGroup = new ClientMeterGroup(this);
        this.meterGroupPreview = new ClientMeterGroup(this);
        this.connected = false;
        this.hudEnabled = true;
        this.prevGameTime = -1L;
        this.hud.init();
        this.reloadResources();
    }

    public class_310 getMinecraft() {
        return this.minecraft;
    }

    public ClientPacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    public void sendPacket(RSMMPacket packet) {
        this.minecraft.method_1562().method_2883(this.packetHandler.encode(packet));
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }

    public MeterRenderer getMeterRenderer() {
        return this.meterRenderer;
    }

    public MultimeterHud getHud() {
        return this.hud;
    }

    public SavedMeterGroupsManager getSavedMeterGroupsManager() {
        return this.savedMeterGroupsManager;
    }

    public ClientMeterPropertiesManager getMeterPropertiesManager() {
        return this.meterPropertiesManager;
    }

    public Tutorial getTutorial() {
        return this.tutorial;
    }

    public ClientMeterGroup getMeterGroup() {
        return this.meterGroup;
    }

    public ClientMeterGroup getMeterGroupPreview() {
        return this.meterGroupPreview;
    }

    public boolean hasSubscription() {
        return this.meterGroup.isSubscribed();
    }

    public boolean isPreviewing() {
        return this.meterGroupPreview.isPreviewing();
    }

    public TickPhaseTree getTickPhaseTree() {
        return this.tickPhaseTree;
    }

    public void requestTickPhaseTree() {
        this.tickPhaseTree.reset();
        TickPhaseTreePacket packet = new TickPhaseTreePacket(new class_2487());
        this.sendPacket(packet);
    }

    public void rebuildTickPhaseTree() {
        this.tickPhaseTree.reset();
        RebuildTickPhaseTreePacket packet = new RebuildTickPhaseTreePacket();
        this.sendPacket(packet);
    }

    public void refreshTickPhaseTree(class_2487 nbt) {
        RSMMScreen screen;
        if (this.tickPhaseTree.isComplete()) {
            this.tickPhaseTree.reset();
        }
        this.tickPhaseTree.fromNbt(nbt);
        if (this.hasRSMMScreenOpen() && (screen = this.getScreen()) instanceof TickPhaseTreeScreen) {
            ((TickPhaseTreeScreen)screen).refresh();
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isHudEnabled() {
        return this.hudEnabled;
    }

    public boolean isHudActive() {
        return this.hud.hasContent() && (this.hudEnabled && this.hud.settings.opacity() > 0 || this.hud.isOnScreen());
    }

    public long getPrevGameTime() {
        return this.prevGameTime;
    }

    public Path getConfigDirectory() {
        return MultimeterClient.getConfigDirectory(this.minecraft);
    }

    public static Path getConfigDirectory(class_310 minecraft) {
        return minecraft.field_1697.toPath().resolve("config/redstone_multimeter");
    }

    public void reloadResources() {
        this.meterPropertiesManager.reload();
    }

    public void tickTime(long gameTime) {
        this.prevGameTime = gameTime;
        this.meterGroup.tick();
        this.hud.tickTime();
        this.savedMeterGroupsManager.tick();
    }

    public void onStartup() {
        this.savedMeterGroupsManager.load();
    }

    public void onShutdown() {
        this.savedMeterGroupsManager.save();
        this.meterGroup.getLogManager().getPrinter().stop(false);
    }

    public void onConnect() {
        if (!this.connected) {
            HandshakePacket packet = new HandshakePacket();
            this.sendPacket(packet);
        }
    }

    public void onDisconnect() {
        if (this.connected) {
            this.connected = false;
            this.hud.reset();
            this.tickPhaseTree.reset();
            this.meterGroup.unsubscribe(true);
        }
    }

    public void onHandshake(String modVersion) {
        if (!this.connected) {
            this.connected = true;
            if (((Boolean)Options.Miscellaneous.VERSION_WARNING.get()).booleanValue() && !"1.16.0".equals(modVersion)) {
                Text warning = modVersion == null || modVersion.isEmpty() ? Texts.translatable("rsmm.multiplayer.serverVersionWarning.versionUnknown") : Texts.translatable("rsmm.multiplayer.serverVersionWarning.versionKnown", modVersion);
                this.sendMessage(warning.format(Formatting.RED), false);
            }
            this.hud.reset();
            if (((Boolean)Options.RedstoneMultimeter.CREATE_GROUP_ON_JOIN.get()).booleanValue()) {
                this.createDefaultMeterGroup();
            }
        }
    }

    public void createDefaultMeterGroup() {
        String name = (String)Options.RedstoneMultimeter.DEFAULT_METER_GROUP.get();
        if (!MeterGroup.isValidName(name)) {
            name = this.minecraft.method_1548().method_1676();
        }
        this.subscribeToMeterGroup(-1, name);
    }

    public void subscribeToMeterGroup(int slot, String name) {
        this.pendingMeterGroupSlot = slot;
        this.pendingMeterGroupName = name;
        MeterGroupSubscriptionPacket packet = new MeterGroupSubscriptionPacket(name, true);
        this.sendPacket(packet);
    }

    public void handleSubscribeToMeterGroup(String name) {
        int slot = name.equals(this.pendingMeterGroupName) ? this.pendingMeterGroupSlot : -1;
        this.meterGroup.subscribe(slot, name);
        this.pendingMeterGroupSlot = -1;
        this.pendingMeterGroupName = null;
    }

    public void unsubscribeFromMeterGroup() {
        MeterGroupSubscriptionPacket packet = new MeterGroupSubscriptionPacket(this.meterGroup.getName(), false);
        this.sendPacket(packet);
    }

    public void refreshMeterGroup() {
        MeterGroupRefreshPacket packet = new MeterGroupRefreshPacket(this.meterGroup);
        this.sendPacket(packet);
    }

    public void toggleMeter() {
        this.onTargetBlock(pos -> {
            Meter meter = this.meterGroup.getMeterAt((DimPos)pos);
            if (meter == null) {
                this.addMeter((DimPos)pos);
            } else {
                RemoveMeterPacket packet = new RemoveMeterPacket(meter.getId());
                this.sendPacket(packet);
                this.tutorial.onMeterRemoveRequested((DimPos)pos);
            }
        });
    }

    private void addMeter(DimPos pos) {
        MeterProperties.MutableMeterProperties properties = new MeterProperties.MutableMeterProperties();
        properties.setPos(pos);
        if (this.meterPropertiesManager.validate(properties)) {
            AddMeterPacket packet = new AddMeterPacket(properties);
            this.sendPacket(packet);
            this.tutorial.onMeterAddRequested(pos);
        }
    }

    public void resetMeter() {
        this.onTargetMeter(meter -> {
            MeterProperties.MutableMeterProperties newProperties = new MeterProperties.MutableMeterProperties();
            newProperties.setPos(meter.getPos());
            if (this.meterPropertiesManager.validate(newProperties)) {
                MeterUpdatePacket packet = new MeterUpdatePacket(meter.getId(), newProperties);
                this.sendPacket(packet);
            }
        });
    }

    public void togglePrinter() {
        if (this.hud.hasContent()) {
            this.meterGroup.getLogManager().getPrinter().toggle();
        }
    }

    public void openMeterControls() {
        this.onTargetMeter(meter -> {
            this.openScreen(new MultimeterScreen());
            this.hud.selectMeter((Meter)meter);
        });
    }

    public void toggleEventType(EventType type) {
        this.onTargetMeter(meter -> {
            MeterProperties.MutableMeterProperties newProperties = new MeterProperties.MutableMeterProperties();
            newProperties.setEventTypes(meter.getEventTypes());
            newProperties.toggleEventType(type);
            MeterUpdatePacket packet = new MeterUpdatePacket(meter.getId(), newProperties);
            this.sendPacket(packet);
        });
    }

    private void onTargetMeter(Consumer<Meter> action) {
        this.onTargetBlock(pos -> {
            Meter meter = this.meterGroup.getMeterAt((DimPos)pos);
            if (meter != null) {
                action.accept(meter);
            }
        });
    }

    private void onTargetBlock(Consumer<DimPos> action) {
        class_239 hit = this.minecraft.field_1765;
        if (hit.method_17783() == class_239.class_240.field_1332) {
            class_638 level = this.minecraft.field_1687;
            class_2338 pos = ((class_3965)hit).method_17777();
            action.accept(new DimPos((class_1937)level, pos));
        }
    }

    public void toggleHud() {
        if (this.hud.hasContent()) {
            this.hudEnabled = !this.hudEnabled;
            this.tutorial.onToggleHud(this.hudEnabled);
            String action = this.hudEnabled ? "enabled" : "disabled";
            this.sendMessage(Texts.translatable("rsmm.toggleHud." + action), true);
        }
    }

    public RSMMScreen getScreen() {
        if (this.minecraft.field_1755 != null && this.minecraft.field_1755 instanceof ScreenWrapper) {
            ScreenWrapper screenWrapper = (ScreenWrapper)this.minecraft.field_1755;
            return screenWrapper.getScreen();
        }
        return null;
    }

    public void openScreen(RSMMScreen screen) {
        this.minecraft.method_1507((class_437)new ScreenWrapper(this.minecraft.field_1755, screen));
        this.tutorial.onScreenOpened(screen);
    }

    public boolean hasScreenOpen() {
        return this.minecraft.field_1755 != null;
    }

    public boolean hasRSMMScreenOpen() {
        return this.minecraft.field_1755 != null && this.minecraft.field_1755 instanceof ScreenWrapper;
    }

    public boolean hasMultimeterScreenOpen() {
        RSMMScreen screen = this.getScreen();
        return screen != null && screen instanceof MultimeterScreen;
    }

    public boolean hasOptionsScreenOpen() {
        RSMMScreen screen = this.getScreen();
        return screen != null && screen instanceof OptionsScreen;
    }

    public void sendMessage(Text message, boolean actionBar) {
        this.minecraft.field_1724.method_7353(message.resolve(), actionBar);
    }
}

