/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_327;
import net.minecraft.class_5348;

public class Tooltip {
    public static final Tooltip EMPTY = new Tooltip(new class_2561[0]);
    private final List<class_2561> lines = new ArrayList<class_2561>();

    public Tooltip(class_2561 ... lines) {
        if (lines != null && lines.length > 0) {
            for (class_2561 line : lines) {
                this.lines.add(line);
            }
        }
    }

    public boolean isEmpty() {
        return this == EMPTY || this.lines.isEmpty();
    }

    public List<class_2561> getLines() {
        return Collections.unmodifiableList(this.lines);
    }

    public Tooltip add(String line) {
        this.add((class_2561)new class_2585(line));
        return this;
    }

    public Tooltip add(class_2561 line) {
        if (this == EMPTY) {
            throw new UnsupportedOperationException("cannot add more lines to the EMPTY tooltip!");
        }
        this.lines.add(line);
        return this;
    }

    public int getWidth(class_327 font) {
        int width = 0;
        for (int index = 0; index < this.lines.size(); ++index) {
            class_2561 text = this.lines.get(index);
            int lineWidth = font.method_27525((class_5348)text);
            if (lineWidth <= width) continue;
            width = lineWidth;
        }
        return width;
    }

    public int getHeight(class_327 font) {
        int n = this.lines.size() - 1;
        Objects.requireNonNull(font);
        int n2 = n * (9 + 1);
        Objects.requireNonNull(font);
        return n2 + 9;
    }

    public static Tooltip of(String ... strings) {
        if (strings == null || strings.length == 0) {
            return EMPTY;
        }
        class_2561[] lines = new class_2561[strings.length];
        for (int index = 0; index < strings.length; ++index) {
            lines[index] = new class_2585(strings[index]);
        }
        return new Tooltip(lines);
    }

    public static Tooltip of(class_2561 ... lines) {
        if (lines == null || lines.length == 0) {
            return EMPTY;
        }
        return new Tooltip(lines);
    }

    public static Tooltip of(List<class_2561> components) {
        if (components == null || components.isEmpty()) {
            return EMPTY;
        }
        class_2561[] lines = new class_2561[components.size()];
        for (int index = 0; index < components.size(); ++index) {
            lines[index] = components.get(index);
        }
        return new Tooltip(lines);
    }
}

