/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.element;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.element.AbstractElement;
import redstone.multimeter.client.gui.element.Element;
import redstone.multimeter.client.gui.element.SelectorList;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.client.gui.tooltip.Tooltips;

public class BlockSelectorList
extends SelectorList {
    private final Consumer<class_2960> selectionListener;

    public BlockSelectorList(int width, int height, Consumer<class_2960> selectionListener) {
        this(width, height, 0, 0, selectionListener);
    }

    public BlockSelectorList(int width, int height, int topBorder, int bottomBorder, Consumer<class_2960> selectionListener) {
        super(width, height, topBorder, bottomBorder);
        this.selectionListener = selectionListener;
        this.setSorter((o1, o2) -> {
            if (o1 instanceof BlockListEntry && o2 instanceof BlockListEntry) {
                BlockListEntry e1 = (BlockListEntry)o1;
                BlockListEntry e2 = (BlockListEntry)o2;
                return COLLATOR.compare(e1.key.toString(), e2.key.toString());
            }
            return 0;
        });
    }

    @Override
    protected void selectionChanged(Element element) {
        super.selectionChanged(element);
        if (element instanceof BlockListEntry) {
            BlockListEntry entry = (BlockListEntry)element;
            this.selectionListener.accept(entry.key);
        }
    }

    public void add(class_2960 key) {
        this.addChild(new BlockListEntry(this.getEffectiveWidth(), 20, key));
    }

    public void add(Collection<class_2960> keys) {
        for (class_2960 key : keys) {
            this.add(key);
        }
    }

    public void setBlockFilter(Predicate<class_2960> filter) {
        this.setFilter(e -> {
            if (e instanceof BlockListEntry) {
                BlockListEntry entry = (BlockListEntry)e;
                return filter.test(entry.key);
            }
            return false;
        });
    }

    private class BlockListEntry
    extends AbstractElement {
        private final class_2960 key;
        private final class_1799 icon;

        protected BlockListEntry(int width, int height, class_2960 key) {
            super(0, 0, width, height);
            class_2248 block = (class_2248)class_2378.field_11146.method_10223(key);
            this.icon = block == null ? null : new class_1799((class_1935)block.method_8389());
            this.key = key;
        }

        @Override
        public void render(GuiRenderer renderer, int mouseX, int mouseY) {
            int height = this.getHeight();
            int x = this.getX() + 2;
            int y = this.getY() + (height - 16) / 2;
            if (this.icon != null) {
                renderer.renderItem(this.icon, x, y);
            }
            x = this.getX() + 22;
            y = this.getY() + height - (height + BlockSelectorList.this.font.height()) / 2;
            String text = BlockSelectorList.this.font.trim(this.key.toString(), this.getWidth() - 22);
            renderer.drawStringWithShadow(text, x, y);
        }

        @Override
        public void mouseMove(double mouseX, double mouseY) {
        }

        @Override
        public boolean mouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return false;
        }

        @Override
        public boolean mouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
            return false;
        }

        @Override
        public boolean keyPress(int keyCode, int scanCode, int modifiers) {
            return false;
        }

        @Override
        public boolean keyRelease(int keyCode, int scanCode, int modifiers) {
            return false;
        }

        @Override
        public boolean typeChar(char chr, int modifiers) {
            return false;
        }

        @Override
        public void onRemoved() {
        }

        @Override
        public void tick() {
        }

        @Override
        public Tooltip getTooltip(int mouseX, int mouseY) {
            String keyString;
            Tooltip tooltip = super.getTooltip(mouseX, mouseY);
            if (tooltip.isEmpty() && BlockSelectorList.this.font.width(keyString = this.key.toString()) > this.getWidth() - 22) {
                tooltip = Tooltips.split(BlockSelectorList.this.font, keyString);
            }
            return tooltip;
        }

        @Override
        public void update() {
        }
    }
}

