/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.element;

import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.element.Element;
import redstone.multimeter.client.gui.element.SimpleList;
import redstone.multimeter.client.option.Options;

public class ScrollableList
extends SimpleList {
    private int height;
    private int scrollBarX;
    private int scrollBarY;
    private int scrollBarWidth;
    private int scrollBarHeight;
    private double scrollAmount;
    private ScrollMode scrollMode;

    public ScrollableList(int width, int height) {
        this(width, height, 0, 0);
    }

    public ScrollableList(int width, int height, int topBorder, int bottomBorder) {
        super(width, topBorder, bottomBorder);
        this.height = height;
        this.scrollBarWidth = 6;
        this.scrollMode = ScrollMode.NONE;
        this.updateScrollBar();
    }

    @Override
    protected void renderList(GuiRenderer renderer, int mouseX, int mouseY) {
        super.renderList(renderer, mouseX, mouseY);
        if (this.getMaxScrollAmount() > 0.0) {
            if (this.scrollMode == ScrollMode.PULL) {
                int margin;
                int totalHeight;
                int visibleHeight = this.getHeight();
                int middle = this.scrollBarY + this.scrollBarHeight * ((int)this.scrollAmount + visibleHeight / 2) / (totalHeight = visibleHeight + (int)this.getMaxScrollAmount());
                if (mouseY < middle - (margin = 5)) {
                    this.scroll(-((Integer)Options.Miscellaneous.SCROLL_SPEED.get()).intValue());
                } else if (mouseY > middle + margin) {
                    this.scroll(((Integer)Options.Miscellaneous.SCROLL_SPEED.get()).intValue());
                }
            }
            this.renderScrollBar(renderer, this.scrollMode == ScrollMode.DRAG || this.isHovered() && this.isMouseOverScrollBar(mouseX, mouseY));
        }
    }

    private boolean isMouseOverScrollBar(double mouseX, double mouseY) {
        return mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + this.scrollBarWidth) && mouseY >= (double)this.scrollBarY && mouseY <= (double)(this.scrollBarY + this.scrollBarHeight);
    }

    @Override
    public boolean mouseClick(double mouseX, double mouseY, int button) {
        boolean consumed = super.mouseClick(mouseX, mouseY, button);
        if (!consumed && button == 0) {
            this.scrollMode = this.getScrollMode(mouseX, mouseY);
            if (this.scrollMode != ScrollMode.NONE) {
                consumed = true;
            }
        }
        return consumed;
    }

    @Override
    public boolean mouseRelease(double mouseX, double mouseY, int button) {
        boolean consumed = super.mouseRelease(mouseX, mouseY, button);
        if (button == 0) {
            this.scrollMode = ScrollMode.NONE;
        }
        return consumed;
    }

    @Override
    public boolean mouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        boolean consumed = super.mouseDrag(mouseX, mouseY, button, deltaX, deltaY);
        if (!consumed && this.scrollMode == ScrollMode.DRAG) {
            consumed = this.scroll(deltaY * (this.getMaxScrollAmount() + (double)this.getHeight()) / (double)this.scrollBarHeight);
        }
        return consumed;
    }

    @Override
    public boolean mouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean consumed = super.mouseScroll(mouseX, mouseY, scrollX, scrollY);
        if (!consumed && this.scrollMode == ScrollMode.NONE) {
            consumed = this.scroll((double)(-((Integer)Options.Miscellaneous.SCROLL_SPEED.get()).intValue()) * scrollY);
        }
        return consumed;
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        this.scrollBarX = x + this.getWidth() - (this.scrollBarWidth + 2);
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.updateScrollBar();
    }

    @Override
    public int getHeight() {
        return this.height - this.getTopBorderAndMargin() - this.getBottomBorderAndMargin();
    }

    @Override
    public int getEffectiveWidth() {
        return this.scrollBarX - 2 - this.getX();
    }

    @Override
    protected void updateContentY() {
        super.updateContentY();
        this.updateScrollBar();
        this.validateScrollAmount();
    }

    @Override
    protected int getOffsetY() {
        return -((int)this.scrollAmount);
    }

    @Override
    public void setDrawBackground(boolean drawBackground) {
        super.setDrawBackground(drawBackground);
        this.updateScrollBar();
    }

    protected double getMaxScrollAmount() {
        double amount = this.getTotalSpacing() - this.getHeight();
        for (Element element : this.getChildren()) {
            if (!element.isVisible()) continue;
            amount += (double)element.getHeight();
        }
        if (amount < 0.0) {
            amount = 0.0;
        }
        return amount;
    }

    protected boolean scroll(double amount) {
        return this.setScrollAmount(this.scrollAmount + amount);
    }

    protected boolean setScrollAmount(double amount) {
        double maxAmount;
        double prevScroll = this.scrollAmount;
        this.scrollAmount = amount;
        if (this.scrollAmount < 0.0) {
            this.scrollAmount = 0.0;
        }
        if (this.scrollAmount > (maxAmount = this.getMaxScrollAmount())) {
            this.scrollAmount = maxAmount;
        }
        if (this.scrollAmount != prevScroll) {
            this.updateContentY();
        }
        return this.scrollAmount != prevScroll;
    }

    protected boolean validateScrollAmount() {
        return this.setScrollAmount(this.scrollAmount);
    }

    protected ScrollMode getScrollMode(double mouseX, double mouseY) {
        int left = this.scrollBarX;
        int right = this.scrollBarX + this.scrollBarWidth;
        int top = this.scrollBarY;
        int bot = this.scrollBarY + this.scrollBarHeight;
        if (mouseX < (double)left || mouseX > (double)right || mouseY < (double)top || mouseY > (double)bot) {
            return ScrollMode.NONE;
        }
        int screenHeight = this.getHeight();
        int totalHeight = screenHeight + (int)this.getMaxScrollAmount();
        int barTop = this.scrollBarY + this.scrollBarHeight * (int)this.scrollAmount / totalHeight;
        int barBot = this.scrollBarY + this.scrollBarHeight * ((int)this.scrollAmount + this.getHeight()) / totalHeight;
        if (mouseY >= (double)barTop && mouseY <= (double)barBot) {
            return ScrollMode.DRAG;
        }
        return ScrollMode.PULL;
    }

    private void updateScrollBar() {
        this.scrollBarY = this.getY() + this.getTopBorder() + 3;
        this.scrollBarHeight = this.getHeight() - 6;
        if (this.shouldDrawBackground()) {
            this.scrollBarHeight += 9;
        } else {
            this.scrollBarY += 6;
        }
    }

    protected void renderScrollBar(GuiRenderer renderer, boolean light) {
        renderer.fill(this.scrollBarX, this.scrollBarY, this.scrollBarX + this.scrollBarWidth, this.scrollBarY + this.scrollBarHeight, -16777216);
        int visibleHeight = this.getHeight();
        int totalHeight = visibleHeight + (int)this.getMaxScrollAmount();
        int x = this.scrollBarX;
        int y = this.scrollBarY + (int)Math.round((double)this.scrollBarHeight * this.scrollAmount / (double)totalHeight);
        int width = this.scrollBarWidth;
        int height = Math.round((float)this.scrollBarHeight * (float)visibleHeight / (float)totalHeight);
        int color0 = light ? -8947849 : -11184811;
        int color1 = light ? -4473925 : -6710887;
        renderer.fill(x, y, x + width, y + height, color0);
        renderer.fill(x, y, x + width - 1, y + height - 1, color1);
    }

    protected static enum ScrollMode {
        NONE,
        DRAG,
        PULL;

    }
}

