/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.element.button;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_155;
import net.minecraft.class_309;
import net.minecraft.class_3532;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.CursorType;
import redstone.multimeter.client.gui.FontRenderer;
import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.element.Element;
import redstone.multimeter.client.gui.element.button.AbstractButton;
import redstone.multimeter.client.gui.element.button.SuggestionsMenu;
import redstone.multimeter.client.gui.element.button.SuggestionsProvider;
import redstone.multimeter.client.gui.screen.RSMMScreen;
import redstone.multimeter.client.gui.text.Formatting;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.client.gui.tooltip.Tooltips;
import redstone.multimeter.client.option.Options;

public class TextField
extends AbstractButton {
    private final FontRenderer font = MultimeterClient.INSTANCE.getFontRenderer();
    private final class_309 keyboard;
    private final Consumer<String> listener;
    private final Supplier<String> updater;
    private SuggestionsMenu suggestions;
    private Text hint;
    private String value;
    private String suffix;
    private int textX;
    private int textY;
    private int textWidth;
    private int textHeight;
    private int selectionY;
    private int selectionHeight;
    private int maxLength;
    private int maxScroll;
    private int scroll;
    private int cursor;
    private long cursorTicks;
    private int selection;
    private SelectionMethod selectionMethod;

    public TextField(int x, int y, Supplier<Tooltip> tooltip, Consumer<String> listener, Supplier<String> updater) {
        this(x, y, 150, 20, tooltip, listener, updater);
    }

    public TextField(int x, int y, int width, int height, Supplier<Tooltip> tooltip, Consumer<String> listener, Supplier<String> updater) {
        super(x, y, width, height, () -> Texts.literal(""), tooltip);
        this.keyboard = MultimeterClient.MINECRAFT.field_1774;
        this.listener = listener;
        this.updater = updater;
        this.hint = null;
        this.value = "";
        this.suffix = "";
        this.textX = this.getX() + 4;
        this.textY = this.getY() + (this.getHeight() - this.font.height()) / 2;
        this.textWidth = this.getWidth() - 8;
        this.textHeight = this.font.height();
        this.selectionY = this.textY - 1;
        this.selectionHeight = this.textHeight + 2;
        this.maxLength = 32;
        this.maxScroll = 0;
        this.scroll = 0;
        this.cursor = 0;
        this.cursorTicks = -1L;
        this.selection = -1;
        this.selectionMethod = SelectionMethod.NONE;
    }

    @Override
    public void render(GuiRenderer renderer, int mouseX, int mouseY) {
        if (this.selectionMethod == SelectionMethod.MOUSE) {
            if (mouseX < this.textX) {
                this.moveCursor(-1);
            } else if (mouseX > this.textX + this.textWidth) {
                this.moveCursor(1);
            }
        }
        super.render(renderer, mouseX, mouseY);
    }

    @Override
    public void mouseMove(double mouseX, double mouseY) {
    }

    @Override
    public boolean mouseClick(double mouseX, double mouseY, int button) {
        boolean consumed = super.mouseClick(mouseX, mouseY, button);
        if (!consumed && button == 0) {
            if (!this.isSelecting() && this.isDoubleClick()) {
                this.setDraggingMouse(false);
                this.selectAll();
            } else {
                this.setCursorFromMouse(mouseX);
            }
            consumed = true;
        }
        return consumed;
    }

    @Override
    public boolean mouseRelease(double mouseX, double mouseY, int button) {
        boolean consumed = super.mouseRelease(mouseX, mouseY, button);
        if (button == 0) {
            consumed = this.stopSelecting(SelectionMethod.MOUSE) || consumed;
        }
        return consumed;
    }

    @Override
    public boolean mouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        boolean consumed = false;
        if (this.selectionMethod == SelectionMethod.MOUSE && button == 0) {
            consumed = this.setCursorFromMouse(mouseX);
        }
        return consumed;
    }

    @Override
    public boolean mouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        return false;
    }

    @Override
    public boolean keyPress(int keyCode, int scanCode, int modifiers) {
        block0 : switch (keyCode) {
            case 340: 
            case 344: {
                this.startSelecting(SelectionMethod.KEYBOARD);
                break;
            }
            case 263: {
                this.moveCursorFromKeyboard(-1);
                break;
            }
            case 262: {
                this.moveCursorFromKeyboard(1);
                break;
            }
            case 265: 
            case 266: {
                this.setCursorFromKeyboard(0);
                break;
            }
            case 264: 
            case 267: {
                this.setCursorFromKeyboard(this.value.length());
                break;
            }
            case 259: {
                this.erase(false);
                break;
            }
            case 261: {
                this.erase(true);
                break;
            }
            case 256: 
            case 257: {
                this.setFocused(false);
                break;
            }
            default: {
                if (!RSMMScreen.isControlPressed()) break;
                switch (keyCode) {
                    case 65: {
                        if (this.selectionMethod == SelectionMethod.MOUSE) break block0;
                        this.selectAll();
                        break block0;
                    }
                    case 67: {
                        this.copySelectionToClipboard(false);
                        break block0;
                    }
                    case 88: {
                        this.copySelectionToClipboard(true);
                        break block0;
                    }
                    case 86: {
                        this.pasteClipboard();
                        break block0;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean keyRelease(int keyCode, int scanCode, int modifiers) {
        boolean consumed = false;
        if (keyCode == 340 || keyCode == 344) {
            consumed = this.stopSelecting(SelectionMethod.KEYBOARD);
        }
        return consumed;
    }

    @Override
    public boolean typeChar(char chr, int modifiers) {
        if (this.isActive() && class_155.method_643((char)chr)) {
            this.write(String.valueOf(chr));
            return true;
        }
        return false;
    }

    @Override
    public void setHovered(boolean hovered) {
        if (this.suggestions == null) {
            this.setHoveredAndUpdateCursor(hovered);
        }
    }

    public void setHoveredAndUpdateCursor(boolean hovered) {
        boolean wasHovered = this.isHovered();
        super.setHovered(hovered);
        if (hovered) {
            Element.setCursor(CursorType.IBEAM);
        } else if (wasHovered) {
            Element.setCursor(CursorType.ARROW);
        }
    }

    @Override
    public void setFocused(boolean focused) {
        super.setFocused(focused);
        this.update();
        if (!focused) {
            this.stopSelecting();
            this.clearSelection();
            this.setCursor(this.value.length());
            this.cursorTicks = -1L;
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.suggestions != null) {
            this.suggestions.setVisible(visible);
        }
    }

    @Override
    public void tick() {
        if (this.isFocused()) {
            ++this.cursorTicks;
        }
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        if (this.suggestions != null) {
            this.suggestions.updatePosition();
        }
        this.textX = x + 4;
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        if (this.suggestions != null) {
            this.suggestions.updatePosition();
        }
        this.textY = y + this.getHeight() - (this.getHeight() + this.font.height()) / 2;
        this.selectionY = this.textY - 1;
    }

    @Override
    public Tooltip getTooltip(int mouseX, int mouseY) {
        Tooltip tooltip = super.getTooltip(mouseX, mouseY);
        if (tooltip.isEmpty() && !this.isFocused() && this.font.width(this.value) > this.textWidth) {
            tooltip = Tooltips.split(this.font, this.value);
        }
        return tooltip;
    }

    @Override
    public void update() {
        if (!this.isFocused() && this.updater != null) {
            this.setValue(this.updater.get(), false);
        }
        if (this.suggestions != null) {
            this.suggestions.update();
        }
    }

    @Override
    public void setWidth(int width) {
        super.setWidth(width);
        if (this.suggestions != null) {
            this.suggestions.updateSize();
        }
        this.textWidth = width - 8;
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        if (this.suggestions != null) {
            this.suggestions.updatePosition();
        }
        this.textHeight = this.font.height();
        this.selectionHeight = this.textHeight + 2;
    }

    @Override
    protected void renderButton(GuiRenderer renderer) {
        int x0 = this.getX();
        int y0 = this.getY();
        int x1 = x0 + this.getWidth();
        int y1 = y0 + this.getHeight();
        int borderColor = this.getBorderColor();
        int backgroundColor = -16777216;
        renderer.fill(x0 + 1, y0 + 1, x1 - 1, y1 - 1, backgroundColor);
        renderer.borders(x0, y0, x1, y1, borderColor);
    }

    @Override
    protected void renderButtonMessage(GuiRenderer renderer) {
        if (!this.isFocused() && this.isActive() && this.value.isEmpty() && this.hint != null) {
            Text hint = this.hint.format(Formatting.ITALIC);
            int hintColor = this.getHintColor();
            renderer.drawStringWithShadow(hint, this.textX, this.textY, hintColor);
        } else {
            String scrolledValue = this.value.substring(this.scroll);
            String visibleValue = this.font.trim(scrolledValue, this.textWidth, false);
            String coveredValue = scrolledValue.substring(0, this.cursor - this.scroll);
            int valueColor = this.getTextColor();
            renderer.drawStringWithShadow(visibleValue, this.textX, this.textY, valueColor);
            int valueWidth = this.font.width(visibleValue);
            int coveredWidth = this.font.width(coveredValue);
            if (coveredValue.length() < visibleValue.length() && this.suggestions != null && this.suggestions.hasSuggestions()) {
                String visibleRemainder = visibleValue.substring(coveredValue.length());
                int remainderColor = this.getRemainderColor();
                renderer.drawStringWithShadow(visibleRemainder, this.textX + coveredWidth, this.textY, remainderColor);
            }
            if (!this.suffix.isEmpty() && valueWidth < this.textWidth) {
                String visibleSuffix = this.font.trim(this.suffix, this.textWidth - valueWidth, false);
                int suggestionColor = this.getSuggestionColor();
                renderer.drawStringWithShadow(visibleSuffix, this.textX + valueWidth, this.textY, suggestionColor);
            }
            if (this.isFocused()) {
                if (this.isActive() && this.cursorTicks / 6L % 2L == 0L) {
                    if (this.cursor == this.value.length()) {
                        renderer.drawStringWithShadow("_", this.textX + valueWidth, this.textY, valueColor);
                    } else {
                        renderer.fill(this.textX + coveredWidth, this.selectionY, this.textX + coveredWidth + 1, this.selectionY + this.selectionHeight, valueColor);
                    }
                }
                if (this.hasSelection()) {
                    this.drawSelectionHighlight(renderer);
                }
            }
        }
    }

    private void drawSelectionHighlight(GuiRenderer renderer) {
        String t;
        int start = Math.min(this.cursor, this.selection);
        int end = Math.max(this.cursor, this.selection);
        int x0 = this.textX;
        int x1 = this.textX + this.textWidth;
        String visibleText = this.font.trim(this.value.substring(this.scroll), this.textWidth, false);
        if (start >= this.scroll) {
            t = this.value.substring(this.scroll, start);
            x0 = this.textX + this.font.width(t);
        }
        if (end <= this.scroll + visibleText.length()) {
            t = this.value.substring(this.scroll, end);
            x1 = this.textX + this.font.width(t);
        }
        if (x0 >= x1) {
            return;
        }
        int y0 = this.selectionY;
        int y1 = this.selectionY + this.selectionHeight;
        renderer.highlight(x0, y0, x1, y1, -16776961);
    }

    private int getBorderColor() {
        if (!this.isActive()) {
            return -12566464;
        }
        if (this.isFocused()) {
            return -1;
        }
        return this.isHovered() ? -5197648 : -8355712;
    }

    private int getHintColor() {
        return -10461088;
    }

    private int getTextColor() {
        return this.isActive() ? -1 : -5197648;
    }

    private int getRemainderColor() {
        return -5197648;
    }

    private int getSuggestionColor() {
        return -8355712;
    }

    public SuggestionsMenu setSuggestions(SuggestionsProvider provider) {
        this.suggestions = new SuggestionsMenu(this, provider);
        return this.suggestions;
    }

    public void setHint(Text text) {
        this.hint = text;
    }

    public String getValue() {
        return this.value;
    }

    public String getValueBeforeCursor() {
        return this.value.substring(0, Math.min(this.cursor, this.value.length()));
    }

    public void setValue(String text) {
        this.replace(text, 0, this.value.length());
    }

    public void clear() {
        this.replace("", 0, this.value.length());
    }

    private void write(String text) {
        if (!this.isActive()) {
            return;
        }
        if (this.hasSelection()) {
            int start = Math.min(this.selection, this.cursor);
            int end = Math.max(this.selection, this.cursor);
            this.replace(text, start, end);
        } else {
            this.insert(text, this.cursor);
        }
    }

    private void erase(boolean forward) {
        if (!this.isActive()) {
            return;
        }
        if (this.hasSelection()) {
            int start = Math.min(this.selection, this.cursor);
            int end = Math.max(this.selection, this.cursor);
            this.replace("", start, end);
        } else if (forward) {
            this.replace("", this.cursor, this.cursor + 1);
        } else if (this.cursor > 0) {
            this.replace("", this.cursor - 1, this.cursor);
        }
    }

    private boolean insert(String text, int index) {
        return this.replace(text, index, index);
    }

    private boolean replace(String text, int start, int end) {
        String t0 = this.value.substring(0, start);
        String t1 = this.value.substring(end);
        return this.setValue(t0 + text + t1, start + text.length(), true);
    }

    private boolean setValue(String text, boolean updateListener) {
        return this.setValue(text, text.length(), updateListener);
    }

    private boolean setValue(String text, int cursor, boolean updateListener) {
        if (this.value.equals(text) || text.length() > this.maxLength) {
            return false;
        }
        this.value = text;
        this.stopSelecting();
        this.clearSelection();
        if (this.suggestions != null) {
            this.suggestions.update();
        }
        if (cursor >= 0) {
            this.setCursor(cursor);
        }
        if (updateListener) {
            this.listener.accept(this.value);
        }
        return true;
    }

    private void copySelectionToClipboard(boolean erase) {
        String text;
        if (this.hasSelection() && !(text = this.getSelection()).isEmpty()) {
            this.keyboard.method_1455(text);
            if (erase) {
                this.erase(false);
            }
        }
    }

    private void pasteClipboard() {
        String text = this.keyboard.method_1460();
        if (!text.isEmpty()) {
            this.write(text);
        }
    }

    public void updateSuggestion() {
        String suggestion;
        int index;
        this.suffix = "";
        if (this.suggestions.hasSelection() && (index = (suggestion = this.suggestions.getSelection()).indexOf(this.value)) == 0) {
            this.suffix = suggestion.substring(this.value.length());
        }
        this.updateMaxScroll();
        this.updateScroll();
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
    }

    private void updateScroll() {
        String valueAndCursor;
        int maxCursorForScroll;
        if (this.scroll > this.maxScroll) {
            this.scroll(this.maxScroll - this.scroll);
        }
        if (this.cursor < this.scroll) {
            this.scroll(this.cursor - this.scroll);
        }
        if (this.cursor > (maxCursorForScroll = this.scroll + (valueAndCursor = this.font.trim(this.value + "_", this.textWidth + 1, true)).length() - 1)) {
            this.scroll(this.cursor - maxCursorForScroll);
        }
    }

    private void updateMaxScroll() {
        String valueAndCursor;
        this.maxScroll = 0;
        if (!this.value.isEmpty() && (valueAndCursor = this.font.trim(this.value + "_", this.textWidth + 1, true)).length() <= this.value.length()) {
            this.maxScroll = this.value.length() - (valueAndCursor.length() - 1);
        }
    }

    private void scroll(int amount) {
        this.setScroll(this.scroll + amount);
    }

    private void setScroll(int value) {
        this.scroll = class_3532.method_15340((int)value, (int)0, (int)this.maxScroll);
    }

    private boolean setCursorFromMouse(double mouseX) {
        if (this.selectionMethod != SelectionMethod.KEYBOARD) {
            String scrolledValue = this.value.substring(this.scroll);
            String visibleValue = this.font.trim(scrolledValue, this.textWidth, false);
            if (mouseX < (double)this.textX) {
                this.setCursor(this.scroll - 5);
            } else if (mouseX > (double)(this.textX + this.textWidth)) {
                this.setCursor(this.scroll + visibleValue.length() + 5);
            } else {
                String coveredValue = this.font.trim(visibleValue, (int)(mouseX + 2.0) - this.textX, false);
                this.setCursor(this.scroll + coveredValue.length());
                this.startSelecting(SelectionMethod.MOUSE);
            }
            return true;
        }
        return false;
    }

    private void moveCursorFromKeyboard(int amount) {
        this.setCursorFromKeyboard(this.cursor + amount);
    }

    private void setCursorFromKeyboard(int index) {
        if (this.selectionMethod != SelectionMethod.MOUSE) {
            this.setCursor(index);
        }
    }

    private void moveCursor(int amount) {
        this.setCursor(this.cursor + amount);
    }

    private void setCursor(int index) {
        this.cursor = class_3532.method_15340((int)index, (int)0, (int)this.value.length());
        this.cursorTicks = this.isFocused() ? 0L : -1L;
        this.onCursorMoved();
    }

    private void onCursorMoved() {
        if (!this.isSelecting()) {
            this.clearSelection();
            if (this.suggestions != null) {
                this.suggestions.update();
            }
        }
        this.updateScroll();
    }

    private boolean isDoubleClick() {
        return this.cursorTicks >= 0L && this.cursorTicks < (long)((Integer)Options.Miscellaneous.DOUBLE_CLICK_TIME.get()).intValue();
    }

    private boolean hasSelection() {
        return this.selection >= 0 && this.selection != this.cursor;
    }

    private String getSelection() {
        int start = Math.min(this.selection, this.cursor);
        int end = Math.max(this.selection, this.cursor);
        return this.value.substring(start, end);
    }

    private void clearSelection() {
        this.selection = -1;
    }

    private boolean startSelecting(SelectionMethod method) {
        if (this.selectionMethod == SelectionMethod.NONE) {
            this.selectionMethod = method;
            if (this.selection < 0) {
                this.selection = this.cursor;
            }
            return true;
        }
        return false;
    }

    private boolean stopSelecting(SelectionMethod method) {
        if (this.selectionMethod == method) {
            this.selectionMethod = SelectionMethod.NONE;
            return true;
        }
        return false;
    }

    private boolean stopSelecting() {
        return this.stopSelecting(this.selectionMethod);
    }

    private void selectAll() {
        this.setCursor(this.value.length());
        this.selection = 0;
    }

    private boolean isSelecting() {
        return this.selectionMethod != SelectionMethod.NONE;
    }

    private static enum SelectionMethod {
        NONE,
        MOUSE,
        KEYBOARD;

    }
}

