/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.element.option;

import java.util.Collection;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.FontRenderer;
import redstone.multimeter.client.gui.element.AbstractParentElement;
import redstone.multimeter.client.gui.element.Label;
import redstone.multimeter.client.gui.element.SimpleList;
import redstone.multimeter.client.gui.element.button.BasicButton;
import redstone.multimeter.client.gui.element.button.Button;
import redstone.multimeter.client.gui.text.Formatting;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltips;
import redstone.multimeter.client.option.Option;
import redstone.multimeter.client.option.OptionListener;

public class OptionsCategoryElement
extends AbstractParentElement {
    private final FontRenderer font = MultimeterClient.INSTANCE.getFontRenderer();
    private final Label category = new Label(0, 0, t -> t.setLines(Texts.translatable(category).format(Formatting.ITALIC)).setShadow(true));
    private final SimpleList options;

    public OptionsCategoryElement(int width, String category, Collection<Option> options) {
        this.options = new SimpleList(width);
        for (Option option : options) {
            this.options.add(new OptionElement(option));
        }
        this.options.update();
        this.addChild(this.category);
        this.addChild(this.options);
        this.setWidth(width);
        this.setHeight(this.category.getHeight() + this.options.getHeight() + 6);
    }

    @Override
    public void setX(int x) {
        super.setX(x);
        this.category.setX(x + (this.options.getWidth() - this.category.getWidth()) / 2);
        this.options.setX(x);
    }

    @Override
    public void setY(int y) {
        super.setY(y);
        this.category.setY(y);
        this.options.setY(y + this.category.getHeight() + 6);
    }

    private class OptionElement
    extends AbstractParentElement
    implements OptionListener {
        private final Option option;
        private final Label name;
        private final Button control;
        private final Button reset;

        public OptionElement(Option option) {
            this.option = option;
            this.name = new Label(0, 0, t -> t.setLines(this.option.getName()).setShadow(true), () -> Tooltips.split(OptionsCategoryElement.this.font, option.getDescription()), t -> false);
            this.control = this.option.createControl(100, 20);
            this.reset = new BasicButton(0, 0, 50, 20, Texts::guiControlsReset, Tooltips::empty, button -> {
                this.option.reset();
                return true;
            });
            this.addChild(this.name);
            this.addChild(this.control);
            this.addChild(this.reset);
            this.setWidth(OptionsCategoryElement.this.options.getWidth());
            this.setHeight(20);
            this.option.setListener(this);
        }

        @Override
        public void setX(int x) {
            super.setX(x);
            int mid = x + OptionsCategoryElement.this.options.getWidth() / 2;
            this.name.setX(mid - this.name.getWidth() - 2);
            this.control.setX(mid + 2);
            this.reset.setX(mid + 2 + this.control.getWidth() + 10);
        }

        @Override
        public void setY(int y) {
            super.setY(y);
            int height = this.getHeight();
            this.name.setY(y + height - (height + OptionsCategoryElement.this.font.height()) / 2);
            this.control.setY(y);
            this.reset.setY(y);
        }

        @Override
        public void onRemoved() {
            this.option.setListener(null);
            super.onRemoved();
        }

        @Override
        public void valueChanged() {
            this.control.update();
            this.reset.setActive(!this.option.isDefault());
        }
    }
}

