/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.hud.element;

import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.element.AbstractElement;
import redstone.multimeter.client.gui.hud.MultimeterHud;
import redstone.multimeter.client.gui.hud.Orientation;
import redstone.multimeter.common.meter.Meter;

public abstract class MeterEventViewer
extends AbstractElement {
    protected final MultimeterHud hud;

    protected MeterEventViewer(MultimeterHud hud) {
        super(0, 0, 0, 0);
        this.hud = hud;
    }

    @Override
    public void render(GuiRenderer renderer, int mouseX, int mouseY) {
        renderer.pushMatrix();
        if (!this.hud.client.isPreviewing()) {
            this.drawHighlights(renderer, mouseX, mouseY);
            renderer.translate(0.0, 0.0, -1.0);
            this.drawDecorators(renderer);
            renderer.translate(0.0, 0.0, -1.0);
            this.drawMeterEvents(renderer);
            renderer.translate(0.0, 0.0, -1.0);
        }
        this.drawGridLines(renderer);
        renderer.translate(0.0, 0.0, -1.0);
        renderer.fill(0, 0, this.getWidth(), this.getHeight(), this.hud.settings.colorBackground);
        renderer.popMatrix();
    }

    @Override
    public boolean mouseDrag(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return false;
    }

    @Override
    public boolean mouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        return false;
    }

    @Override
    public boolean keyPress(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @Override
    public boolean keyRelease(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @Override
    public boolean typeChar(char chr, int modifiers) {
        return false;
    }

    @Override
    public void tick() {
    }

    @Override
    public void update() {
    }

    protected void drawMeterLogs(MeterEventRenderEvent event) {
        int x = 0;
        int y = 0;
        for (int index = 0; index < this.hud.meters.size(); ++index) {
            Meter meter = this.hud.meters.get(index);
            event.accept(x, y, meter);
            y += this.hud.settings.rowHeight + this.hud.settings.gridSize;
        }
    }

    protected abstract void drawHighlights(GuiRenderer var1, int var2, int var3);

    protected void drawHighlight(GuiRenderer renderer, int column, int columnCount, int row, int rowCount, boolean selection) {
        int color = selection ? this.hud.settings.colorHighlightSelected : this.hud.settings.colorHighlightHovered;
        this.drawHighlight(renderer, column, columnCount, row, rowCount, color);
    }

    protected void drawHighlight(GuiRenderer renderer, int column, int columnCount, int row, int rowCount, int color) {
        int d = this.hud.settings.gridSize;
        int w = this.hud.settings.columnWidth + d;
        int h = this.hud.settings.rowHeight + d;
        int x0 = column * w;
        int y0 = row * h;
        int x1 = x0 + columnCount * w + d;
        int y1 = y0 + rowCount * h + d;
        renderer.borders(x0, y0, x1, y1, d, color);
    }

    protected abstract void drawDecorators(GuiRenderer var1);

    protected abstract void drawMeterEvents(GuiRenderer var1);

    private void drawGridLines(GuiRenderer renderer) {
        int color;
        int y1;
        int x1;
        int y0;
        int x0;
        int i;
        renderer.pushMatrix();
        int columns = this.getColumnCount();
        int rows = this.hud.meters.size();
        int marker = this.getCurrentTickMarkerColumn();
        if (marker >= 0) {
            int x02 = marker * (this.hud.settings.columnWidth + this.hud.settings.gridSize);
            int y02 = this.hud.settings.gridSize;
            int x12 = x02 + this.hud.settings.gridSize;
            int y12 = y02 + this.getHeight() - 2 * this.hud.settings.gridSize;
            int color2 = this.hud.settings.colorGridMarker;
            renderer.fill(x02, y02, x12, y12, color2);
        }
        renderer.translate(0.0, 0.0, -0.1);
        for (i = 0; i <= rows; ++i) {
            x0 = 0;
            y0 = i * (this.hud.settings.rowHeight + this.hud.settings.gridSize);
            x1 = x0 + this.getWidth();
            y1 = y0 + this.hud.settings.gridSize;
            color = this.hud.settings.colorGridMain;
            renderer.fill(x0, y0, x1, y1, color);
        }
        renderer.translate(0.0, 0.0, -0.1);
        for (i = 0; i <= columns; ++i) {
            x0 = i * (this.hud.settings.columnWidth + this.hud.settings.gridSize);
            y0 = 0;
            x1 = x0 + this.hud.settings.gridSize;
            y1 = y0 + this.getHeight();
            color = i > 0 && i < columns && i % 5 == 0 ? this.hud.settings.colorGridInterval : this.hud.settings.colorGridMain;
            renderer.fill(x0, y0, x1, y1, color);
        }
        renderer.popMatrix();
    }

    protected abstract int getColumnCount();

    protected int getCurrentTickMarkerColumn() {
        return -1;
    }

    public int getHoveredColumn(double mouseX) {
        int max = this.getColumnCount() - 1;
        int column = Math.min(max, (int)((mouseX - (double)this.getX()) / (double)(this.hud.settings.columnWidth + this.hud.settings.gridSize)));
        if (this.hud.getOrientationX() == Orientation.X.RIGHT_TO_LEFT) {
            column = max - column;
        }
        return column;
    }

    public void updateWidth() {
        int columns = this.getColumnCount();
        if (columns == 0) {
            this.setWidth(0);
        } else {
            this.setWidth(columns * (this.hud.settings.columnWidth + this.hud.settings.gridSize) + this.hud.settings.gridSize);
        }
    }

    public void updateHeight() {
        this.setHeight(this.hud.meters.size() * (this.hud.settings.rowHeight + this.hud.settings.gridSize) + this.hud.settings.gridSize);
    }

    protected static interface MeterEventRenderEvent {
        public void accept(int var1, int var2, Meter var3);
    }
}

