/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.hud.element;

import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.hud.MultimeterHud;
import redstone.multimeter.client.gui.hud.element.MeterEventViewer;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.log.EventLog;
import redstone.multimeter.common.meter.log.MeterLogs;

public class SecondaryEventViewer
extends MeterEventViewer {
    public SecondaryEventViewer(MultimeterHud hud) {
        super(hud);
    }

    @Override
    public void render(GuiRenderer renderer, int mouseX, int mouseY) {
        if (!this.hud.client.isPreviewing() && this.hud.isPaused() && this.getColumnCount() > 0) {
            super.render(renderer, mouseX, mouseY);
        }
    }

    @Override
    public void mouseMove(double mouseX, double mouseY) {
    }

    @Override
    public Tooltip getTooltip(int mouseX, int mouseY) {
        if (!this.hud.isFocusMode() && this.isMouseOver(mouseX, mouseY)) {
            int row = this.hud.getHoveredRow(mouseY);
            Meter meter = this.hud.meters.get(row);
            long tick = this.hud.getSelectedTick();
            int subtick = this.getHoveredColumn(mouseX);
            MeterLogs logs = meter.getLogs();
            EventLog log = logs.getLogAt(tick, subtick);
            if (log != null && meter.isMetering(log.getEvent().getType())) {
                return log.getTooltip();
            }
        }
        return super.getTooltip(mouseX, mouseY);
    }

    @Override
    protected void drawHighlights(GuiRenderer renderer, int mouseX, int mouseY) {
        EventLog highlight;
        if (this.hud.isFocusMode() && (highlight = this.hud.getFocussedEvent()) != null) {
            this.drawHighlight(renderer, highlight.getSubtick(), 1, 0, this.hud.meters.size(), true);
        }
        if (this.isMouseOver(mouseX, mouseY)) {
            int column = this.getHoveredColumn(mouseX);
            int row = this.hud.getHoveredRow(mouseY);
            this.drawHighlight(renderer, column, 1, row, 1, false);
        }
    }

    @Override
    protected void drawDecorators(GuiRenderer renderer) {
    }

    @Override
    protected void drawMeterEvents(GuiRenderer renderer) {
        long tick = this.hud.getSelectedTick();
        int subticks = this.hud.client.getMeterGroup().getLogManager().getSubtickCount(tick);
        this.drawMeterLogs((x, y, meter) -> this.hud.eventRenderers.renderSubtickLogs(renderer, x, y, tick, subticks, meter));
    }

    @Override
    protected int getColumnCount() {
        if (this.hud.isPaused()) {
            return this.hud.client.getMeterGroup().getLogManager().getSubtickCount(this.hud.getSelectedTick());
        }
        return 0;
    }
}

