/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.screen;

import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_437;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.FontRenderer;
import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.element.AbstractParentElement;
import redstone.multimeter.client.gui.screen.ScreenWrapper;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.texture.Textures;
import redstone.multimeter.client.gui.tooltip.Tooltip;

public abstract class RSMMScreen
extends AbstractParentElement {
    protected final MultimeterClient client = MultimeterClient.INSTANCE;
    protected final class_310 minecraft = MultimeterClient.MINECRAFT;
    protected final FontRenderer font = this.client.getFontRenderer();
    private final Text title;
    private final boolean drawTitle;
    protected ScreenWrapper wrapper;

    protected RSMMScreen(Text title, boolean drawTitle) {
        this.title = title;
        this.drawTitle = drawTitle;
    }

    @Override
    public void render(GuiRenderer renderer, int mouseX, int mouseY) {
        Tooltip tooltip;
        this.renderBackground(renderer);
        this.renderContent(renderer, mouseX, mouseY);
        if (this.drawTitle) {
            int width = this.font.width(this.title);
            int x = this.getX() + (this.getWidth() - width) / 2;
            int y = this.getY() + 6;
            this.font.drawWithShadow(this.title, x, y);
        }
        if (!(tooltip = this.getTooltip(mouseX, mouseY)).isEmpty()) {
            renderer.tooltip(tooltip, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClick(double mouseX, double mouseY, int button) {
        return super.mouseClick(mouseX, mouseY, button) || this.client.getInputHandler().mouseClick(this, mouseX, mouseY, button);
    }

    @Override
    public boolean keyPress(int keyCode, int scanCode, int modifiers) {
        return super.keyPress(keyCode, scanCode, modifiers) || this.client.getInputHandler().keyPress(this, keyCode, scanCode, modifiers);
    }

    @Override
    public boolean mouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        return this.client.getInputHandler().mouseScroll(this, scrollX, scrollY) || super.mouseScroll(mouseX, mouseY, scrollX, scrollY);
    }

    @Override
    public final boolean isHovered() {
        return true;
    }

    @Override
    public final void setX(int x) {
    }

    @Override
    public final void setY(int y) {
    }

    public void init(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        this.removeChildren();
        this.initScreen();
        this.update();
        class_1041 window = this.minecraft.method_22683();
        class_312 mouse = this.minecraft.field_1729;
        double mouseX = mouse.method_1603() * (double)window.method_4486() / (double)window.method_4489();
        double mouseY = mouse.method_1604() * (double)window.method_4502() / (double)window.method_4506();
        this.mouseMove(mouseX, mouseY);
    }

    protected abstract void initScreen();

    protected boolean shouldCloseOnEsc() {
        return true;
    }

    public void close() {
        this.minecraft.method_1507(this.wrapper.getParent());
    }

    protected boolean hasTransparentBackground() {
        return this.minecraft.field_1687 != null;
    }

    protected void renderBackground(GuiRenderer renderer) {
        if (this.hasTransparentBackground()) {
            renderer.gradient(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), -1072689136, -804253680);
        } else {
            int x0 = this.getX();
            int y0 = this.getY();
            int x1 = x0 + this.getWidth();
            int y1 = y0 + this.getHeight();
            int u0 = x0 / 2;
            int v0 = y0 / 2;
            int u1 = x1 / 2;
            int v1 = y1 / 2;
            renderer.blit(Textures.OPTIONS_BACKGROUND, x0, y0, x1, y1, u0, v0, u1, v1, -12566464);
        }
    }

    protected void renderContent(GuiRenderer renderer, int mouseX, int mouseY) {
        super.render(renderer, mouseX, mouseY);
    }

    public Text getTitle() {
        return this.title;
    }

    public boolean isPauseScreen() {
        return true;
    }

    public static boolean isControlPressed() {
        return class_437.method_25441() && !class_437.method_25442() && !class_437.method_25443();
    }
}

