/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.text;

import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_5244;
import redstone.multimeter.client.gui.text.Formatting;
import redstone.multimeter.client.gui.text.LiteralText;
import redstone.multimeter.client.gui.text.Style;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.TranslatableText;
import redstone.multimeter.interfaces.mixin.IKeyMapping;

public class Texts {
    public static final Text MOD_NAME = Texts.literal("Redstone Multimeter");
    public static final Text GUI_DONE = Texts.of(class_5244.field_24334);
    public static final Text GUI_CANCEL = Texts.of(class_5244.field_24335);
    public static final Text GUI_CONTROLS = Texts.translatable("options.controls");
    public static final Text GUI_CONTROLS_RESET = Texts.translatable("controls.reset");

    public static Text of(Object o) {
        if (o instanceof Text) {
            return (Text)o;
        }
        if (o instanceof class_2561) {
            return Texts.resolve((class_2561)o);
        }
        if (o instanceof String) {
            return Texts.resolve((String)o);
        }
        return Texts.literal(o.toString());
    }

    public static Text literal(String t) {
        return new LiteralText(t);
    }

    public static Text literal(String t, Object ... args) {
        return new LiteralText(String.format(t, args));
    }

    public static Text translatable(String t) {
        return new TranslatableText(t, new Object[0]);
    }

    public static Text translatable(String t, Object ... args) {
        return new TranslatableText(t, args);
    }

    public static Text composite(Object ... ts) {
        Text t = Texts.literal("");
        for (Object o : ts) {
            t.append(Texts.of(o));
        }
        return t;
    }

    public static Text modName() {
        return MOD_NAME;
    }

    public static Text guiDone() {
        return GUI_DONE;
    }

    public static Text guiCancel() {
        return GUI_CANCEL;
    }

    public static Text guiControls() {
        return GUI_CONTROLS;
    }

    public static Text guiControlsReset() {
        return GUI_CONTROLS_RESET;
    }

    public static Text keyValue(Object key, Object value) {
        return Texts.composite(Texts.composite(key, ": ").format(Formatting.GOLD), value);
    }

    public static Text keybinds(Object ... keybinds) {
        Text t = Texts.literal("");
        int i = 0;
        for (Object o : keybinds) {
            Text keybind = o instanceof class_304 ? Texts.keybind(true, (class_304)o) : (o instanceof class_3675.class_306 ? Texts.key((class_3675.class_306)o) : (o instanceof Object[] ? Texts.keys(true, (Object[])o) : Texts.key(o)));
            if (keybind == null) continue;
            if (i++ > 0) {
                t.append(" OR ");
            }
            t.append(keybind);
        }
        if (i == 0) {
            t.append(Texts.composite("<", Texts.translatable("rsmm.keybind.unbound"), ">"));
        }
        return t;
    }

    public static Text keys(Object ... keys) {
        return Texts.keys(false, keys);
    }

    private static Text keys(boolean nullable, Object ... keys) {
        Text t = Texts.literal("");
        for (int i = 0; i < keys.length; ++i) {
            Object o = keys[i];
            Text key = o instanceof class_304 ? Texts.keybind(nullable, (class_304)o) : (o instanceof class_3675.class_306 ? Texts.key((class_3675.class_306)o) : Texts.key(o));
            if (nullable && key == null) {
                return null;
            }
            if (i > 0) {
                t.append(" + ");
            }
            t.append(key);
        }
        return t;
    }

    public static Text keybind(class_304 keybind) {
        return Texts.keybind(false, keybind);
    }

    private static Text keybind(boolean nullable, class_304 keybind) {
        if (keybind.method_1415()) {
            if (nullable) {
                return null;
            }
            return Texts.composite("<", Texts.translatable("rsmm.keybind.unbound"), ">");
        }
        return Texts.key(((IKeyMapping)keybind).rsmm$getKey());
    }

    public static Text key(class_3675.class_306 key) {
        return Texts.of(key.method_27445()).format(Formatting.YELLOW);
    }

    public static Text key(Object name) {
        return Texts.of(name).format(Formatting.YELLOW);
    }

    public static Text resolve(class_2561 component) {
        Text t;
        if (component instanceof class_2585) {
            t = Texts.literal(((class_2585)component).method_10993());
        } else if (component instanceof class_2588) {
            class_2588 translatable = (class_2588)component;
            t = Texts.translatable(translatable.method_11022(), translatable.method_11023());
        } else {
            throw new IllegalStateException("cannot convert " + component + " to RSMM Text!");
        }
        t.format(Style.resolve(component.method_10866()));
        for (class_2561 sibling : component.method_10855()) {
            t.append(Texts.resolve(sibling));
        }
        return t;
    }

    public static Text resolve(String fs) {
        Text t = Texts.literal("");
        Style s = Style.EMPTY;
        int from = 0;
        boolean lastWasFormattingPrefix = false;
        boolean lastWasFormatting = false;
        for (int to = 0; to < fs.length(); ++to) {
            boolean thisIsStringEnd;
            char chr = fs.charAt(to);
            boolean thisIsFormattingPrefix = chr == '\u00a7';
            boolean bl = thisIsStringEnd = to == fs.length() - 1;
            if (lastWasFormattingPrefix) {
                Formatting f = Formatting.byCode(chr);
                s = f == Formatting.RESET ? Style.EMPTY : s.applyFormattings(f);
                if (thisIsStringEnd) {
                    from = to;
                }
                lastWasFormattingPrefix = false;
                lastWasFormatting = true;
            } else if (thisIsFormattingPrefix) {
                lastWasFormattingPrefix = true;
                lastWasFormatting = false;
            } else {
                if (lastWasFormatting) {
                    from = to;
                }
                if (thisIsStringEnd) {
                    ++to;
                }
                lastWasFormattingPrefix = false;
                lastWasFormatting = false;
            }
            if (!thisIsFormattingPrefix && !thisIsStringEnd) continue;
            if (from != to) {
                t.append(Texts.literal(fs.substring(from, to)).format(s));
            }
            from = to;
        }
        return t;
    }
}

