/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.tooltip;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_304;
import redstone.multimeter.client.gui.FontRenderer;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.client.gui.tooltip.TooltipBuilder;

public class Tooltips {
    public static final Tooltip EMPTY = Tooltip.EMPTY;

    public static Tooltip empty() {
        return EMPTY;
    }

    public static Tooltip lines(Collection<Text> lines) {
        return lines.isEmpty() ? Tooltip.EMPTY : new Tooltip(new ArrayList<Text>(lines));
    }

    public static Tooltip lines(List<String> lines) {
        return Tooltips.lines(lines.stream().map(Texts::literal).collect(Collectors.toList()));
    }

    public static Tooltip lines(Object ... lines) {
        return Tooltips.lines(Stream.of(lines).map(Texts::of).collect(Collectors.toList()));
    }

    public static Tooltip line(Text line) {
        return Tooltips.lines(Arrays.asList(line));
    }

    public static Tooltip line(String line) {
        return Tooltips.line(Texts.literal(line));
    }

    public static Tooltip line(String line, Object ... args) {
        return Tooltips.line(Texts.literal(line, args));
    }

    public static Tooltip translatable(String line) {
        return Tooltips.line(Texts.translatable(line));
    }

    public static Tooltip translatable(String line, Object ... args) {
        return Tooltips.line(Texts.translatable(line, args));
    }

    public static Tooltip split(FontRenderer font, String text) {
        return Tooltips.split(font, text, 200);
    }

    public static Tooltip split(FontRenderer font, String text, int width) {
        return Tooltips.lines(font.split(text, width));
    }

    public static Tooltip split(FontRenderer font, Text text) {
        return Tooltips.split(font, text, 200);
    }

    public static Tooltip split(FontRenderer font, Text text, int width) {
        return Tooltips.lines(font.split(text, width));
    }

    public static Tooltip keybind(class_304 keybind) {
        return Tooltips.keybind(Texts.translatable(keybind.method_1431()), keybind);
    }

    public static Tooltip keybind(class_304 keybind, Object ... keys) {
        return Tooltips.keybind(Texts.translatable(keybind.method_1431()), keys);
    }

    public static Tooltip keybind(Text keybind, Object ... keys) {
        return Tooltips.lines(keybind, Texts.keyValue(Texts.translatable("rsmm.keybind"), Texts.keybinds(keys)));
    }

    public static TooltipBuilder builder() {
        return new TooltipBuilder();
    }
}

