/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.meter.log;

import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.meter.ClientMeterGroup;
import redstone.multimeter.client.meter.log.LogPrinter;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.log.EventLog;
import redstone.multimeter.common.meter.log.LogManager;
import redstone.multimeter.common.meter.log.MeterLogs;

public class ClientLogManager
extends LogManager {
    private static final long AGE_CUTOFF = 10000L;
    private static final long MAX_LOG_AGE = 1000000L;
    private final ClientMeterGroup meterGroup;
    private final Long2IntMap subticks;
    private final LogPrinter printer;

    public ClientLogManager(ClientMeterGroup meterGroup) {
        this.meterGroup = meterGroup;
        this.subticks = new Long2IntLinkedOpenHashMap();
        this.printer = new LogPrinter(this);
    }

    @Override
    protected ClientMeterGroup getMeterGroup() {
        return this.meterGroup;
    }

    @Override
    public void clearLogs() {
        super.clearLogs();
        this.subticks.clear();
    }

    public LogPrinter getPrinter() {
        return this.printer;
    }

    public int getSubtickCount(long tick) {
        return this.subticks.getOrDefault(tick, -1) + 1;
    }

    public void tick() {
        this.clearOldLogs();
        this.printer.tick();
    }

    private void clearOldLogs() {
        long serverTickCutoff;
        MultimeterClient client = this.meterGroup.getMultimeterClient();
        long selectedTickCutoff = client.getHud().getSelectedTick() - 10000L;
        long cutoff = selectedTickCutoff > (serverTickCutoff = client.getPrevGameTime() - 1000000L) ? selectedTickCutoff : serverTickCutoff;
        this.subticks.long2IntEntrySet().removeIf(e -> e.getLongKey() < cutoff);
        for (Meter meter : this.meterGroup.getMeters()) {
            meter.getLogs().clearOldLogs(cutoff);
        }
    }

    public void updateMeterLogs(class_2499 data) {
        for (int index = 0; index < data.size(); ++index) {
            class_2487 nbt = data.method_10602(index);
            long id = nbt.method_10537("id");
            Meter meter = this.meterGroup.getMeter(id);
            if (meter == null) continue;
            class_2487 logs = nbt.method_10562("logs");
            boolean powered = nbt.method_10577("powered");
            boolean active = nbt.method_10577("active");
            meter.setPowered(powered);
            meter.setActive(active);
            for (EventLog log : MeterLogs.fromNbt(logs)) {
                long tick = log.getTick();
                int subtick = log.getSubtick();
                this.subticks.compute(tick, (key, value) -> value == null || value < subtick ? subtick : value);
                meter.getLogs().add(log);
            }
        }
        this.printer.printLogs();
    }
}

