/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.meter.log;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.PriorityQueue;
import java.util.Queue;
import net.minecraft.class_310;
import net.minecraft.class_437;
import redstone.multimeter.RedstoneMultimeterMod;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.meter.log.ClientLogManager;
import redstone.multimeter.client.option.Options;
import redstone.multimeter.common.TickPhase;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.common.meter.log.EventLog;
import redstone.multimeter.common.meter.log.MeterLogs;

public class LogPrinter {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private final ClientLogManager logManager;
    private final MultimeterClient client;
    private final Path folder;
    private final Queue<MeterEventLog> printQueue;
    private BufferedWriter writer;
    private long firstTick;
    private long prevTick;

    public LogPrinter(ClientLogManager logManager) {
        this.logManager = logManager;
        this.client = this.logManager.getMeterGroup().getMultimeterClient();
        class_310 minecraft = this.client.getMinecraft();
        this.folder = minecraft.field_1697.toPath().resolve("redstone_multimeter/logs/");
        this.printQueue = new PriorityQueue<MeterEventLog>();
        this.writer = null;
        this.firstTick = -1L;
        this.prevTick = -1L;
    }

    public ClientLogManager getLogManager() {
        return this.logManager;
    }

    private long getGameTime() {
        return this.logManager.getMeterGroup().getMultimeterClient().getPrevGameTime();
    }

    public boolean isPrinting() {
        return this.writer != null;
    }

    public void toggle() {
        if (this.isPrinting()) {
            this.stop(true);
        } else {
            this.start(true);
        }
    }

    public void start(boolean notifyPlayer) {
        if (this.isPrinting()) {
            return;
        }
        try {
            Path file = this.createLogFile();
            BufferedWriter bw = Files.newBufferedWriter(file, new OpenOption[0]);
            this.writer = new BufferedWriter(bw);
            this.firstTick = this.getGameTime();
            this.writer.write("Logs for meter group '" + this.logManager.getMeterGroup().getName() + "'");
            this.writer.newLine();
            this.writer.write("Logs are added in chronological order");
            this.writer.newLine();
            this.writer.write("-------------------------------------");
            this.writer.newLine();
            if (((Boolean)Options.LogPrinter.PRINT_OLD_LOGS.get()).booleanValue() || class_437.method_25442()) {
                this.printLogs();
            } else {
                this.prevTick = this.firstTick;
            }
            if (notifyPlayer) {
                this.client.sendMessage(Texts.translatable("rsmm.logPrinter.start"), false);
            }
            this.client.getHud().onTogglePrinter();
        }
        catch (IOException e) {
            this.client.sendMessage(Texts.translatable("rsmm.logPrinter.error"), false);
            RedstoneMultimeterMod.LOGGER.warn("Log Printer encountered issues!", (Throwable)e);
            this.stop(notifyPlayer);
        }
    }

    public void stop(boolean notifyPlayer) {
        this.firstTick = -1L;
        this.prevTick = -1L;
        if (!this.isPrinting()) {
            return;
        }
        try {
            this.writer.close();
        }
        catch (IOException e) {
            this.client.sendMessage(Texts.translatable("rsmm.logPrinter.error"), false);
            RedstoneMultimeterMod.LOGGER.warn("Log Printer encountered issues!", (Throwable)e);
        }
        finally {
            this.writer = null;
            if (notifyPlayer) {
                this.client.sendMessage(Texts.translatable("rsmm.logPrinter.stop"), false);
            }
            this.client.getHud().onTogglePrinter();
        }
    }

    private Path createLogFile() throws IOException {
        if (!Files.exists(this.folder, new LinkOption[0])) {
            Files.createDirectories(this.folder, new FileAttribute[0]);
        }
        String date = DATE_FORMAT.format(new Date());
        Path file = this.folder.resolve(date + ".txt");
        int i = 1;
        while (Files.exists(file, new LinkOption[0])) {
            String fileName = String.format("%s (%d).txt", date, i++);
            file = this.folder.resolve(fileName);
        }
        return file;
    }

    public void tick() {
        if (this.isPrinting()) {
            int limit = (Integer)Options.LogPrinter.MAX_RUNTIME.get();
            long runtime = this.getGameTime() - this.firstTick;
            if (limit >= 0 && runtime > (long)limit) {
                this.client.sendMessage(Texts.translatable("rsmm.logPrinter.maxRuntimeExceeded"), false);
                this.stop(true);
            }
        }
    }

    public void printLogs() {
        if (!this.isPrinting()) {
            return;
        }
        long lastTick = this.getGameTime();
        for (Meter meter : this.logManager.getMeterGroup().getMeters()) {
            MeterLogs logs = meter.getLogs();
            for (EventType type : EventType.ALL) {
                int index = logs.getLastLogBefore(type, this.prevTick + 1L) + 1;
                EventLog log = logs.getLog(type, index);
                if (log == null) continue;
                while (!log.isAfter(lastTick)) {
                    this.printQueue.add(new MeterEventLog(meter, log));
                    if ((log = logs.getLog(type, ++index)) != null) continue;
                }
            }
        }
        this.prevTick = lastTick;
        this.print();
    }

    private void print() {
        long tick = -1L;
        TickPhase phase = null;
        try {
            while (!this.printQueue.isEmpty()) {
                MeterEventLog meterEventLog = this.printQueue.poll();
                if (meterEventLog.log.getTick() != tick) {
                    tick = meterEventLog.log.getTick();
                    phase = null;
                    this.writer.write("" + tick);
                    this.writer.newLine();
                }
                if (!meterEventLog.log.getTickPhase().equals(phase)) {
                    phase = meterEventLog.log.getTickPhase();
                    this.writer.write("    " + phase.toString());
                    this.writer.newLine();
                }
                this.writer.write("        " + meterEventLog.toString());
                this.writer.newLine();
            }
        }
        catch (IOException e) {
            this.client.sendMessage(Texts.translatable("rsmm.logPrinter.error"), false);
            RedstoneMultimeterMod.LOGGER.warn("Log Printer encountered issues!", (Throwable)e);
            this.stop(true);
        }
    }

    public void onNewMeterGroup() {
        if (this.isPrinting()) {
            this.stop(false);
            this.start(false);
        }
    }

    private class MeterEventLog
    implements Comparable<MeterEventLog> {
        private final Meter meter;
        private final EventLog log;

        public MeterEventLog(Meter meter, EventLog log) {
            this.meter = meter;
            this.log = log;
        }

        public String toString() {
            return String.format("%d - (%s) %s", this.log.getSubtick(), this.meter.getName(), this.log.getEvent());
        }

        @Override
        public int compareTo(MeterEventLog o) {
            if (this.log.isBefore(o.log)) {
                return -1;
            }
            if (this.log.isAfter(o.log)) {
                return 1;
            }
            return 0;
        }
    }
}

