/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.render;

import net.minecraft.class_1159;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_765;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.meter.ClientMeterGroup;
import redstone.multimeter.client.option.Options;
import redstone.multimeter.client.render.MeterNameMode;
import redstone.multimeter.client.render.RenderTypes;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.mixin.client.LevelRendererAccessor;
import redstone.multimeter.util.ColorUtils;

public class MeterRenderer {
    private static final class_265 OUTLINE_SHAPE = class_259.method_1081((double)-0.002f, (double)-0.002f, (double)-0.002f, (double)1.002f, (double)1.002f, (double)1.002f);
    private final MultimeterClient client;
    private final class_310 minecraft;

    public MeterRenderer(MultimeterClient client) {
        this.client = client;
        this.minecraft = this.client.getMinecraft();
    }

    public void renderMeters(class_4587 poses, class_4597.class_4598 bufferSource) {
        this.renderMeters(poses, bufferSource, this::renderMeterHighlight);
    }

    public void renderMeterNameTags(class_4587 poses, class_4597.class_4598 bufferSource) {
        MeterNameMode mode = (MeterNameMode)Options.RedstoneMultimeter.RENDER_METER_NAMES.get();
        if (mode == MeterNameMode.ALWAYS || mode == MeterNameMode.WHEN_PREVIEWING && this.client.isPreviewing() || mode == MeterNameMode.IN_FOCUS_MODE && this.client.getHud().isFocusMode() && !this.client.isPreviewing()) {
            this.renderMeters(poses, bufferSource, this::renderMeterNameTag);
        }
    }

    private void renderMeters(class_4587 poses, class_4597.class_4598 bufferSource, MeterPartRenderer renderer) {
        if (this.client.isPreviewing() || !this.client.getHud().isFocusMode()) {
            ClientMeterGroup meterGroup = this.client.isPreviewing() ? this.client.getMeterGroupPreview() : this.client.getMeterGroup();
            for (Meter meter : meterGroup.getMeters()) {
                if (!meter.isIn((class_1937)this.minecraft.field_1687)) continue;
                renderer.render(poses, bufferSource, meter);
            }
        } else {
            Meter focussed = this.client.getHud().getFocussedMeter();
            if (focussed != null && focussed.isIn((class_1937)this.minecraft.field_1687)) {
                renderer.render(poses, bufferSource, focussed);
            }
        }
    }

    private void renderMeterHighlight(class_4587 poses, class_4597.class_4598 bufferSource, Meter meter) {
        class_2338 pos = meter.getPos().getBlockPos();
        int color = meter.getColor();
        boolean movable = meter.isMovable();
        class_4184 camera = this.minecraft.field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        double dx = (double)pos.method_10263() - cameraPos.field_1352;
        double dy = (double)pos.method_10264() - cameraPos.field_1351;
        double dz = (double)pos.method_10260() - cameraPos.field_1350;
        poses.method_22903();
        poses.method_22904(dx, dy, dz);
        float r = (float)ColorUtils.getRed(color) / 255.0f;
        float g = (float)ColorUtils.getGreen(color) / 255.0f;
        float b = (float)ColorUtils.getBlue(color) / 255.0f;
        this.renderMeterHighlight(bufferSource, poses, r, g, b, 0.5f);
        if (movable) {
            this.renderMeterOutline(bufferSource, poses, r, g, b, 1.0f);
        }
        poses.method_22909();
    }

    private void renderMeterNameTag(class_4587 poses, class_4597.class_4598 bufferSource, Meter meter) {
        int range;
        double rangeSquared;
        double dz;
        double dy;
        String name = meter.getName();
        class_2338 pos = meter.getPos().getBlockPos();
        class_4184 camera = this.minecraft.field_1773.method_19418();
        class_243 cameraPos = camera.method_19326();
        double dx = (double)pos.method_10263() - cameraPos.field_1352;
        double distanceSquared = dx * dx + (dy = (double)pos.method_10264() - cameraPos.field_1351) * dy + (dz = (double)pos.method_10260() - cameraPos.field_1350) * dz;
        if (distanceSquared < (rangeSquared = (double)((range = ((Integer)Options.RedstoneMultimeter.METER_NAME_RANGE.get()).intValue()) * range))) {
            poses.method_22903();
            poses.method_22904(dx + 0.5, dy + 0.75, dz + 0.5);
            poses.method_22907(camera.method_23767());
            poses.method_22905(-0.025f, -0.025f, 0.025f);
            class_1159 pose = poses.method_23760().method_23761();
            float x = -((float)this.minecraft.field_1772.method_1727(name) / 2.0f);
            float y = 0.0f;
            this.minecraft.field_1772.method_27521(name, x, y, -1, false, pose, (class_4597)bufferSource, true, 0, class_765.method_23687((int)15, (int)15));
            poses.method_22909();
        }
    }

    private void renderMeterHighlight(class_4597.class_4598 bufferSource, class_4587 poses, float r, float g, float b, float a) {
        class_4588 buffer = bufferSource.getBuffer(RenderTypes.debugQuads());
        class_1159 pose = poses.method_23760().method_23761();
        this.drawBox(buffer, pose, r, g, b, a);
    }

    private void renderMeterOutline(class_4597.class_4598 bufferSource, class_4587 poses, float r, float g, float b, float a) {
        class_4588 buffer = bufferSource.getBuffer(class_1921.method_23594());
        LevelRendererAccessor.rsmm$renderShape(poses, buffer, OUTLINE_SHAPE, 0.0, 0.0, 0.0, r, g, b, a);
    }

    private void drawBox(class_4588 buffer, class_1159 pose, float r, float g, float b, float a) {
        float c0 = -0.002f;
        float c1 = 1.002f;
        buffer.method_22918(pose, c0, c0, c0).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c0, c0, c1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c0, c1, c1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c0, c1, c0).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c1, c0, c0).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c1, c1, c0).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c1, c1, c1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c1, c0, c1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c0, c0, c0).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c0, c1, c0).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c1, c1, c0).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c1, c0, c0).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c0, c0, c1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c1, c0, c1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c1, c1, c1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c0, c1, c1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c0, c0, c0).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c1, c0, c0).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c1, c0, c1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c0, c0, c1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c0, c1, c0).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c0, c1, c1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c1, c1, c1).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(pose, c1, c1, c0).method_22915(r, g, b, a).method_1344();
    }

    @FunctionalInterface
    private static interface MeterPartRenderer {
        public void render(class_4587 var1, class_4597.class_4598 var2, Meter var3);
    }
}

