/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.tutorial.instance;

import redstone.multimeter.client.Keybinds;
import redstone.multimeter.client.gui.element.tutorial.StagedTutorialToast;
import redstone.multimeter.client.gui.element.tutorial.TutorialToast;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.meter.ClientMeterGroup;
import redstone.multimeter.client.tutorial.Tutorial;
import redstone.multimeter.client.tutorial.TutorialStep;
import redstone.multimeter.client.tutorial.instance.StagedTutorialInstance;
import redstone.multimeter.common.meter.Meter;

public class OpenMeterControlsTutorial
extends StagedTutorialInstance {
    private Stage stage;

    public OpenMeterControlsTutorial(Tutorial tutorial) {
        super(tutorial);
        this.findStage();
    }

    @Override
    protected TutorialToast createToast() {
        return new StagedTutorialToast(this, TutorialStep.OPEN_METER_CONTROLS.getName(), TutorialStep.OPEN_METER_CONTROLS.getDescription(Texts.keybind(Keybinds.OPEN_METER_CONTROLS)));
    }

    @Override
    public void onMeterControlsOpened() {
        if (this.stage == Stage.OPEN_METER_CONTROLS) {
            this.completed = true;
        }
    }

    @Override
    public void onJoinMeterGroup() {
        if (this.stage == Stage.JOIN_METER_GROUP) {
            this.findStage();
        }
    }

    @Override
    public void onLeaveMeterGroup() {
        this.findStage();
    }

    @Override
    public void onMeterGroupRefreshed() {
        this.findStage();
    }

    @Override
    public void onMeterAdded(Meter meter) {
        if (this.stage == Stage.ADD_METER) {
            this.findStage();
        }
    }

    @Override
    public void onMeterRemoved(Meter meter) {
        this.findStage();
    }

    @Override
    public void tick() {
    }

    @Override
    public TutorialStep getNextStep() {
        return TutorialStep.REMOVE_METER;
    }

    @Override
    public float getProgress() {
        return this.completed ? 1.0f : (float)this.stage.ordinal() / 3.0f;
    }

    private void findStage() {
        ClientMeterGroup meterGroup = this.tutorial.getClient().getMeterGroup();
        this.stage = !meterGroup.isSubscribed() ? Stage.JOIN_METER_GROUP : (!meterGroup.hasMeters() ? Stage.ADD_METER : Stage.OPEN_METER_CONTROLS);
    }

    public static enum Stage {
        JOIN_METER_GROUP,
        ADD_METER,
        OPEN_METER_CONTROLS;

    }
}

