/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.tutorial.instance;

import redstone.multimeter.client.Keybinds;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.element.tutorial.StagedTutorialToast;
import redstone.multimeter.client.gui.element.tutorial.TutorialToast;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.meter.ClientMeterGroup;
import redstone.multimeter.client.tutorial.Tutorial;
import redstone.multimeter.client.tutorial.TutorialStep;
import redstone.multimeter.client.tutorial.instance.StagedTutorialInstance;
import redstone.multimeter.common.meter.Meter;

public class PauseTimelineTutorial
extends StagedTutorialInstance {
    private Stage stage;

    public PauseTimelineTutorial(Tutorial tutorial) {
        super(tutorial);
        this.findStage();
    }

    @Override
    protected TutorialToast createToast() {
        return new StagedTutorialToast(this, TutorialStep.PAUSE_TIMELINE.getName(), TutorialStep.PAUSE_TIMELINE.getDescription(Texts.keybind(Keybinds.PAUSE_TIMELINE)));
    }

    @Override
    public void onToggleHud(boolean enabled) {
        if (!enabled || this.stage == Stage.ACTIVE_HUD) {
            this.findStage();
        }
    }

    @Override
    public void onPauseHud(boolean paused) {
        if (this.stage == Stage.PAUSE_HUD && paused) {
            this.completed = true;
        }
    }

    @Override
    public void onJoinMeterGroup() {
        if (this.stage == Stage.JOIN_METER_GROUP) {
            this.findStage();
        }
    }

    @Override
    public void onLeaveMeterGroup() {
        this.findStage();
    }

    @Override
    public void onMeterGroupRefreshed() {
        this.findStage();
    }

    @Override
    public void onMeterAdded(Meter meter) {
        if (this.stage == Stage.ADD_METER) {
            this.findStage();
        }
    }

    @Override
    public void onMeterRemoved(Meter meter) {
        this.findStage();
    }

    @Override
    public void tick() {
    }

    @Override
    public TutorialStep getNextStep() {
        return TutorialStep.SCROLL_TIMELINE;
    }

    @Override
    public float getProgress() {
        return this.completed ? 1.0f : (float)this.stage.ordinal() / 4.0f;
    }

    private void findStage() {
        MultimeterClient client = this.tutorial.getClient();
        ClientMeterGroup meterGroup = client.getMeterGroup();
        this.stage = !meterGroup.isSubscribed() ? Stage.JOIN_METER_GROUP : (!meterGroup.hasMeters() ? Stage.ADD_METER : (!client.isHudActive() ? Stage.ACTIVE_HUD : Stage.PAUSE_HUD));
    }

    public static enum Stage {
        JOIN_METER_GROUP,
        ADD_METER,
        ACTIVE_HUD,
        PAUSE_HUD;

    }
}

