/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.tutorial.instance;

import redstone.multimeter.client.Keybinds;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.element.tutorial.StagedTutorialToast;
import redstone.multimeter.client.gui.element.tutorial.TutorialToast;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.meter.ClientMeterGroup;
import redstone.multimeter.client.tutorial.Tutorial;
import redstone.multimeter.client.tutorial.TutorialStep;
import redstone.multimeter.client.tutorial.instance.StagedTutorialInstance;
import redstone.multimeter.common.meter.Meter;

public class ScrollTimelineTutorial
extends StagedTutorialInstance {
    private static final int TIMES_SCROLLED_TARGET = 5;
    private Stage stage;
    private int timesScrolled;

    public ScrollTimelineTutorial(Tutorial tutorial) {
        super(tutorial);
        this.findStage();
    }

    @Override
    protected TutorialToast createToast() {
        return new StagedTutorialToast(this, TutorialStep.SCROLL_TIMELINE.getName(), TutorialStep.SCROLL_TIMELINE.getDescription(Texts.keybind(Keybinds.STEP_BACKWARD), Texts.keybind(Keybinds.STEP_FORWARD), Texts.keys(Keybinds.SCROLL_HUD, "scroll")));
    }

    @Override
    public void onToggleHud(boolean enabled) {
        if (!enabled || this.stage == Stage.ACTIVE_HUD) {
            this.findStage();
        }
    }

    @Override
    public void onPauseHud(boolean paused) {
        if (!paused || this.stage == Stage.PAUSE_HUD) {
            this.findStage();
        }
    }

    @Override
    public void onScrollHud(int amount) {
        if (this.stage == Stage.SCROLL_HUD && amount != 0 && ++this.timesScrolled >= 5) {
            this.completed = true;
        }
    }

    @Override
    public void onJoinMeterGroup() {
        if (this.stage == Stage.JOIN_METER_GROUP) {
            this.findStage();
        }
    }

    @Override
    public void onLeaveMeterGroup() {
        this.findStage();
    }

    @Override
    public void onMeterGroupRefreshed() {
        this.findStage();
    }

    @Override
    public void onMeterAdded(Meter meter) {
        if (this.stage == Stage.ADD_METER) {
            this.findStage();
        }
    }

    @Override
    public void onMeterRemoved(Meter meter) {
        this.findStage();
    }

    @Override
    public void tick() {
    }

    @Override
    public TutorialStep getNextStep() {
        return TutorialStep.OPEN_MULTIMETER_SCREEN;
    }

    @Override
    public float getProgress() {
        float progress;
        float f = progress = this.completed ? 1.0f : (float)this.stage.ordinal() / 5.0f;
        if (this.stage == Stage.SCROLL_HUD) {
            progress += (float)this.timesScrolled / 25.0f;
        }
        return progress;
    }

    private void findStage() {
        MultimeterClient client = this.tutorial.getClient();
        ClientMeterGroup meterGroup = client.getMeterGroup();
        this.stage = !meterGroup.isSubscribed() ? Stage.JOIN_METER_GROUP : (!meterGroup.hasMeters() ? Stage.ADD_METER : (!client.isHudActive() ? Stage.ACTIVE_HUD : (!client.getHud().isPaused() ? Stage.PAUSE_HUD : Stage.SCROLL_HUD)));
        this.timesScrolled = 0;
    }

    public static enum Stage {
        JOIN_METER_GROUP,
        ADD_METER,
        ACTIVE_HUD,
        PAUSE_HUD,
        SCROLL_HUD;

    }
}

