/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common;

import com.google.common.base.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import redstone.multimeter.util.NbtUtils;

public class DimPos {
    private final class_2960 dimension;
    private final class_2338 pos;

    public DimPos(class_2960 dimension, class_2338 pos) {
        this.dimension = dimension;
        this.pos = pos.method_10062();
    }

    public DimPos(class_2960 dimension, int x, int y, int z) {
        this(dimension, new class_2338(x, y, z));
    }

    public DimPos(class_1937 level, class_2338 pos) {
        this(level.method_27983().method_29177(), pos);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DimPos) {
            DimPos other = (DimPos)obj;
            return other.dimension.equals((Object)this.dimension) && other.pos.equals((Object)this.pos);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dimension, this.pos});
    }

    public String toString() {
        return String.format("%s[%d, %d, %d]", this.dimension.toString(), this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260());
    }

    public class_2960 getDimension() {
        return this.dimension;
    }

    public boolean is(class_1937 level) {
        return level.method_27983().method_29177().equals((Object)this.dimension);
    }

    public DimPos relative(class_2960 dimension) {
        return new DimPos(dimension, this.pos);
    }

    public class_2338 getBlockPos() {
        return this.pos;
    }

    public boolean is(class_2338 pos) {
        return pos.equals((Object)this.pos);
    }

    public DimPos relative(class_2350 dir) {
        return this.relative(dir, 1);
    }

    public DimPos relative(class_2350 dir, int distance) {
        return new DimPos(this.dimension, this.pos.method_10079(dir, distance));
    }

    public DimPos relative(class_2350.class_2351 axis) {
        return this.relative(axis, 1);
    }

    public DimPos relative(class_2350.class_2351 axis, int distance) {
        int dx = axis.method_10173(distance, 0, 0);
        int dy = axis.method_10173(0, distance, 0);
        int dz = axis.method_10173(0, 0, distance);
        return new DimPos(this.dimension, this.pos.method_10069(dx, dy, dz));
    }

    public DimPos offset(int dx, int dy, int dz) {
        return new DimPos(this.dimension, this.pos.method_10069(dx, dy, dz));
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10566("dim", (class_2520)NbtUtils.resourceLocationToNbt(this.dimension));
        nbt.method_10569("x", this.pos.method_10263());
        nbt.method_10569("y", this.pos.method_10264());
        nbt.method_10569("z", this.pos.method_10260());
        return nbt;
    }

    public static DimPos fromNbt(class_2487 nbt) {
        class_2960 dimension = NbtUtils.nbtToResourceLocation(nbt.method_10562("dim"));
        int x = nbt.method_10550("x");
        int y = nbt.method_10550("y");
        int z = nbt.method_10550("z");
        return new DimPos(dimension, x, y, z);
    }
}

