/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common;

import java.util.Arrays;
import net.minecraft.class_2479;
import net.minecraft.class_2520;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.TooltipBuilder;
import redstone.multimeter.common.TickTask;
import redstone.multimeter.util.NbtUtils;

public class TickPhase {
    public static final TickPhase UNKNOWN = new TickPhase(TickTask.UNKNOWN);
    private final TickTask[] tasks;

    public TickPhase(TickTask ... tasks) {
        this.tasks = tasks;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof TickPhase)) {
            return false;
        }
        return Arrays.equals((Object[])this.tasks, (Object[])((TickPhase)obj).tasks);
    }

    public String toString() {
        String string = this.tasks[0].getName().buildString();
        for (int index = 1; index < this.tasks.length; ++index) {
            string = string + " > " + this.tasks[index].getName().buildString();
        }
        return string;
    }

    public void buildTooltip(TooltipBuilder builder) {
        builder.line(Texts.keyValue("tick phase", this.tasks[0].getName()));
        String whitespace = "              ";
        for (int index = 1; index < this.tasks.length; ++index) {
            builder.line(Texts.composite(whitespace, "> ", this.tasks[index].getName()));
            whitespace = whitespace + "  ";
        }
    }

    public TickPhase startTask(TickTask task) {
        if (this == UNKNOWN || this.tasks.length == 0) {
            return new TickPhase(task);
        }
        TickTask[] array = new TickTask[this.tasks.length + 1];
        for (int index = 0; index < this.tasks.length; ++index) {
            array[index] = this.tasks[index];
        }
        array[this.tasks.length] = task;
        return new TickPhase(array);
    }

    public TickPhase endTask() {
        if (this == UNKNOWN || this.tasks.length == 1) {
            return UNKNOWN;
        }
        TickTask[] array = new TickTask[this.tasks.length - 1];
        for (int index = 0; index < array.length; ++index) {
            array[index] = this.tasks[index];
        }
        return new TickPhase(array);
    }

    public TickPhase swapTask(TickTask task) {
        if (this == UNKNOWN || this.tasks.length == 1) {
            return new TickPhase(task);
        }
        TickTask[] array = new TickTask[this.tasks.length];
        for (int index = 0; index < this.tasks.length; ++index) {
            array[index] = this.tasks[index];
        }
        array[array.length - 1] = task;
        return new TickPhase(array);
    }

    public class_2520 toNbt() {
        if (this == UNKNOWN) {
            return NbtUtils.NULL;
        }
        byte[] array = new byte[this.tasks.length];
        for (int index = 0; index < array.length; ++index) {
            array[index] = (byte)this.tasks[index].getId();
        }
        return new class_2479(array);
    }

    public static TickPhase fromNbt(class_2520 nbt) {
        if (nbt.method_10711() != 7) {
            return UNKNOWN;
        }
        class_2479 nbtArray = (class_2479)nbt;
        byte[] array = nbtArray.method_10521();
        TickTask[] tasks = new TickTask[array.length];
        for (int index = 0; index < tasks.length; ++index) {
            tasks[index] = TickTask.byId(array[index]);
        }
        return new TickPhase(tasks);
    }
}

