/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import redstone.multimeter.RedstoneMultimeterMod;
import redstone.multimeter.common.PruneType;
import redstone.multimeter.common.TickTask;

public class TickPhaseTree {
    public final Node root;
    private Node current;
    private boolean building;
    private boolean complete;

    public TickPhaseTree() {
        this.current = this.root = new Node(null, TickTask.RUN_LOOP, new String[0]);
        this.building = false;
        this.complete = false;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean isBuilding() {
        return this.building;
    }

    public void reset() {
        if (this.building) {
            RedstoneMultimeterMod.LOGGER.warn("Cannot reset tick phase tree: currently building!");
        } else {
            this.root.children.clear();
            this.current = this.root;
            this.building = false;
            this.complete = false;
        }
    }

    public void start() {
        if (this.building) {
            RedstoneMultimeterMod.LOGGER.warn("Cannot start building tick phase tree: already building!");
        } else {
            this.root.children.clear();
            this.current = this.root;
            this.building = true;
            this.complete = false;
        }
    }

    public void end() {
        if (this.building) {
            this.building = false;
            this.complete = true;
            this.prune();
        } else {
            RedstoneMultimeterMod.LOGGER.warn("Cannot complete tick phase tree: not building!");
        }
    }

    private void prune() {
        new Pruner().run();
    }

    public void startTask(TickTask task, String ... args) {
        if (this.building) {
            this.current = new Node(this.current, task, args);
            this.current.parent.children.add(this.current);
        }
    }

    public void endTask() {
        if (this.building) {
            this.current = this.current.parent;
            if (this.current == null) {
                this.current = this.root;
            }
        }
    }

    public void swapTask(TickTask task, String ... args) {
        if (this.building) {
            this.endTask();
            this.startTask(task, args);
        }
    }

    public class_2487 toNbt() {
        class_2499 tasks = new class_2499();
        class_2499 args = new class_2499();
        this.addNode(tasks, args, this.root, 0);
        class_2487 nbt = new class_2487();
        nbt.method_10566("tasks", (class_2520)tasks);
        nbt.method_10566("args", (class_2520)args);
        return nbt;
    }

    private void addNode(class_2499 tasks, class_2499 args, Node node, int depth) {
        if (depth > 0) {
            byte[] array = new byte[]{(byte)depth, (byte)node.task.getId(), (byte)node.args.length};
            class_2479 taskNbt = new class_2479(array);
            tasks.add((Object)taskNbt);
            for (int index = 0; index < node.args.length; ++index) {
                String arg = node.args[index];
                class_2519 argNbt = class_2519.method_23256((String)arg);
                args.add((Object)argNbt);
            }
        }
        ++depth;
        for (int index = 0; index < node.children.size(); ++index) {
            this.addNode(tasks, args, node.children.get(index), depth);
        }
    }

    public void fromNbt(class_2487 nbt) {
        class_2499 tasks = nbt.method_10554("tasks", 7);
        class_2499 args = nbt.method_10554("args", 8);
        if (!tasks.isEmpty()) {
            this.start();
            this.addNode(tasks, args, 0, 0, 0);
            this.end();
        }
    }

    private void addNode(class_2499 tasks, class_2499 args, int taskIndex, int argIndex, int lastDepth) {
        String[] taskArgs;
        class_2479 taskNbt = (class_2479)tasks.method_10534(taskIndex);
        byte[] array = taskNbt.method_10521();
        byte depth = array[0];
        TickTask task = TickTask.byId(array[1]);
        int argsLength = array[2];
        if (argsLength > 0) {
            taskArgs = new String[argsLength];
            int i = 0;
            while (i < argsLength && argIndex < args.size()) {
                taskArgs[i++] = args.method_10608(argIndex++);
            }
        } else {
            taskArgs = new String[]{};
        }
        int endedTasks = lastDepth - depth;
        while (endedTasks-- > 0) {
            this.endTask();
        }
        if (depth > lastDepth) {
            this.startTask(task, taskArgs);
        } else {
            this.swapTask(task, taskArgs);
        }
        if (++taskIndex < tasks.size()) {
            this.addNode(tasks, args, taskIndex, argIndex, depth);
        }
    }

    public class Node {
        public final Node parent;
        public final List<Node> children;
        public final TickTask task;
        public final String[] args;

        public Node(Node parent, TickTask task, String ... args) {
            this.parent = parent;
            this.children = new ArrayList<Node>();
            this.task = task;
            this.args = args;
        }
    }

    private class Pruner {
        private final Set<TickTask> tasks = EnumSet.noneOf(TickTask.class);
        private final Stack<Set<TickTask>> layers = new Stack();
        private final Stack<TickTask> phase = new Stack();

        private Pruner() {
        }

        private void run() {
            this.tasks.clear();
            this.layers.clear();
            this.phase.clear();
            this.layers.push(EnumSet.noneOf(TickTask.class));
            this.prune(TickPhaseTree.this.root);
        }

        private boolean prune(Node node) {
            TickTask task = node.task;
            PruneType type = task.getPruneType();
            if (type.is(PruneType.TREE) && this.tasks.contains((Object)task)) {
                return true;
            }
            Set<TickTask> layer = this.layers.peek();
            if (type.is(PruneType.SIBLING) && layer.contains((Object)task)) {
                return true;
            }
            if (type.is(PruneType.BRANCH) && this.phase.contains((Object)task)) {
                return true;
            }
            this.tasks.add(task);
            layer.add(task);
            this.phase.push(task);
            this.layers.push(EnumSet.noneOf(TickTask.class));
            Iterator<Node> it = node.children.iterator();
            while (it.hasNext()) {
                Node child = it.next();
                if (!this.prune(child)) continue;
                it.remove();
            }
            this.phase.pop();
            this.layers.pop();
            return false;
        }
    }
}

