/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common.meter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import redstone.multimeter.common.DimPos;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.MeterProperties;
import redstone.multimeter.common.meter.log.LogManager;

public abstract class MeterGroup {
    private final String name;
    private final List<Meter> meters;
    private final Map<Long, Integer> byId;
    private final Map<DimPos, Integer> byPos;

    protected MeterGroup(String name) {
        this.name = name;
        this.meters = new ArrayList<Meter>();
        this.byId = new HashMap<Long, Integer>();
        this.byPos = new HashMap<DimPos, Integer>();
    }

    public static boolean isValidName(String name) {
        return !name.trim().isEmpty() && name.length() <= MeterGroup.getMaxNameLength();
    }

    public static int getMaxNameLength() {
        return 64;
    }

    public String getName() {
        return this.name;
    }

    public void clear() {
        this.meters.clear();
        this.byId.clear();
        this.byPos.clear();
        this.getLogManager().clearLogs();
    }

    public boolean hasMeters() {
        return !this.meters.isEmpty();
    }

    public List<Meter> getMeters() {
        return Collections.unmodifiableList(this.meters);
    }

    public boolean hasMeter(long id) {
        return this.byId.containsKey(id);
    }

    public boolean hasMeterAt(DimPos pos) {
        return this.byPos.containsKey(pos);
    }

    public Meter getMeter(long id) {
        return this.fromIndex(this.byId.getOrDefault(id, -1));
    }

    public Meter getMeterAt(DimPos pos) {
        return this.fromIndex(this.byPos.getOrDefault(pos, -1));
    }

    private Meter fromIndex(int index) {
        return index < 0 || index >= this.meters.size() ? null : this.meters.get(index);
    }

    protected boolean addMeter(Meter meter) {
        if (this.byId.containsKey(meter.getId()) || this.byPos.containsKey(meter.getPos())) {
            return false;
        }
        this.byId.put(meter.getId(), this.meters.size());
        this.byPos.put(meter.getPos(), this.meters.size());
        this.meters.add(meter);
        this.meterAdded(meter);
        return true;
    }

    protected boolean removeMeter(Meter meter) {
        int index = this.byId.getOrDefault(meter.getId(), -1);
        if (index < 0 || index >= this.meters.size()) {
            return false;
        }
        this.meters.remove(index);
        this.byId.remove(meter.getId(), index);
        this.byPos.remove(meter.getPos(), index);
        while (index < this.meters.size()) {
            Meter m = this.meters.get(index);
            this.byId.compute(m.getId(), (id, prevIndex) -> prevIndex - 1);
            this.byPos.compute(m.getPos(), (pos, prevIndex) -> prevIndex - 1);
            ++index;
        }
        this.meterRemoved(meter);
        return true;
    }

    protected boolean updateMeter(Meter meter, MeterProperties newProperties) {
        meter.applyUpdate(properties -> {
            boolean changed = false;
            if (newProperties.getPos() != null) {
                this.moveMeter(meter, newProperties.getPos());
            }
            if (newProperties.getName() != null) {
                changed |= properties.setName(newProperties.getName());
            }
            if (newProperties.getColor() != null) {
                changed |= properties.setColor(newProperties.getColor());
            }
            if (newProperties.getMovable() != null) {
                changed |= properties.setMovable(newProperties.getMovable());
            }
            if (newProperties.getEventTypes() != null) {
                changed |= properties.setEventTypes(newProperties.getEventTypes());
            }
            if (changed) {
                this.meterUpdated(meter);
            }
        });
        return true;
    }

    protected void moveMeter(Meter meter, DimPos newPos) {
        long id = meter.getId();
        DimPos pos = meter.getPos();
        if (pos.equals(newPos)) {
            return;
        }
        int index = this.byId.getOrDefault(id, -1);
        if (index < 0 || index >= this.meters.size()) {
            return;
        }
        this.byPos.remove(pos, index);
        this.byPos.put(newPos, index);
        meter.applyUpdate(properties -> {
            if (properties.setPos(newPos)) {
                this.meterUpdated(meter);
            }
        });
    }

    protected boolean setIndex(Meter meter, int index) {
        int oldIndex = this.byId.getOrDefault(meter.getId(), -1);
        if (index < 0 || index >= this.meters.size() || oldIndex < 0) {
            return false;
        }
        this.meters.remove(oldIndex);
        this.meters.add(index, meter);
        int start = Math.min(oldIndex, index);
        int end = Math.max(oldIndex, index);
        for (index = start; index <= end; ++index) {
            meter = this.meters.get(index);
            this.byId.put(meter.getId(), index);
            this.byPos.put(meter.getPos(), index);
            this.indexChanged(meter);
        }
        return true;
    }

    protected abstract void meterAdded(Meter var1);

    protected abstract void meterRemoved(Meter var1);

    protected abstract void meterUpdated(Meter var1);

    protected abstract void indexChanged(Meter var1);

    public abstract LogManager getLogManager();

    public class_2487 toNbt() {
        class_2499 list = new class_2499();
        for (Meter meter : this.meters) {
            list.add((Object)meter.toNbt());
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("meters", (class_2520)list);
        return nbt;
    }

    public void updateFromNbt(class_2487 nbt) {
        this.clear();
        class_2499 list = nbt.method_10554("meters", 10);
        for (int index = 0; index < list.size(); ++index) {
            class_2487 meterNbt = list.method_10602(index);
            Meter meter = Meter.fromNbt(meterNbt);
            this.addMeter(meter);
        }
    }
}

