/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common.meter.log;

import net.minecraft.class_2487;
import net.minecraft.class_2520;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.client.gui.tooltip.Tooltips;
import redstone.multimeter.common.TickPhase;
import redstone.multimeter.common.meter.event.MeterEvent;

public class EventLog {
    private long tick;
    private int subtick;
    private TickPhase tickPhase;
    private MeterEvent event;

    private EventLog() {
    }

    public EventLog(long tick, int subtick, TickPhase tickPhase, MeterEvent event) {
        this.tick = tick;
        this.subtick = subtick;
        this.tickPhase = tickPhase;
        this.event = event;
    }

    public long getTick() {
        return this.tick;
    }

    public int getSubtick() {
        return this.subtick;
    }

    public boolean isAt(long tick) {
        return this.tick == tick;
    }

    public boolean isAt(long tick, int subtick) {
        return this.tick == tick && this.subtick == subtick;
    }

    public boolean isBefore(long tick) {
        return this.tick < tick;
    }

    public boolean isBefore(long tick, int subtick) {
        if (this.tick == tick) {
            return this.subtick < subtick;
        }
        return this.tick < tick;
    }

    public boolean isBefore(EventLog event) {
        return this.isBefore(event.getTick(), event.getSubtick());
    }

    public boolean isAfter(long tick) {
        return this.tick > tick;
    }

    public boolean isAfter(long tick, int subtick) {
        if (this.tick == tick) {
            return this.subtick > subtick;
        }
        return this.tick > tick;
    }

    public boolean isAfter(EventLog event) {
        return this.isAfter(event.getTick(), event.getSubtick());
    }

    public TickPhase getTickPhase() {
        return this.tickPhase;
    }

    public MeterEvent getEvent() {
        return this.event;
    }

    public Tooltip getTooltip() {
        return Tooltips.builder().lines(this.event::buildTooltip).line(Texts.keyValue("tick", this.tick)).line(Texts.keyValue("subtick", this.subtick)).lines(this.tickPhase::buildTooltip).build();
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10566("meter event", (class_2520)this.event.toNbt());
        nbt.method_10544("tick", this.tick);
        nbt.method_10569("subtick", this.subtick);
        nbt.method_10566("tick phase", this.tickPhase.toNbt());
        return nbt;
    }

    public static EventLog fromNbt(class_2487 nbt) {
        EventLog log = new EventLog();
        log.event = MeterEvent.fromNbt(nbt.method_10562("meter event"));
        log.tick = nbt.method_10537("tick");
        log.subtick = nbt.method_10550("subtick");
        log.tickPhase = TickPhase.fromNbt(nbt.method_10580("tick phase"));
        return log;
    }
}

