/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.common.meter.log;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.common.meter.log.EventLog;
import redstone.multimeter.util.ListUtils;

public class MeterLogs {
    private final List<EventLog>[] eventLogs;
    private long count = 0L;

    public MeterLogs() {
        List[] lists = new List[EventType.ALL.length];
        for (int index = 0; index < lists.length; ++index) {
            lists[index] = new ArrayList();
        }
        this.eventLogs = lists;
    }

    public void clear() {
        for (List<EventLog> logs : this.eventLogs) {
            logs.clear();
        }
        this.count = 0L;
    }

    public boolean isEmpty() {
        return this.count == 0L;
    }

    private List<EventLog> getLogs(EventType type) {
        return this.eventLogs[type.getId()];
    }

    public void add(EventLog log) {
        EventType type = log.getEvent().getType();
        List<EventLog> logs = this.getLogs(type);
        logs.add(this.getLastLogBefore(type, log.getTick(), log.getSubtick()) + 1, log);
        ++this.count;
    }

    public void clearOldLogs(long cutoff) {
        for (List<EventLog> logs : this.eventLogs) {
            EventLog log;
            while (!logs.isEmpty() && (log = logs.get(0)).getTick() <= cutoff) {
                logs.remove(0);
            }
        }
    }

    public EventLog getLog(EventType type, int index) {
        if (index < 0) {
            return null;
        }
        List<EventLog> logs = this.getLogs(type);
        if (index >= logs.size()) {
            return null;
        }
        return logs.get(index);
    }

    public int getLastLogBefore(EventType type, long tick) {
        return this.getLastLogBefore(type, tick, 0);
    }

    public int getLastLogBefore(EventType type, long tick, int subtick) {
        List<EventLog> logs = this.getLogs(type);
        if (logs.isEmpty() || !logs.get(0).isBefore(tick, subtick)) {
            return -1;
        }
        if (logs.get(logs.size() - 1).isBefore(tick, subtick)) {
            return logs.size() - 1;
        }
        int index = ListUtils.binarySearch(logs, event -> event.isBefore(tick, subtick));
        EventLog log = logs.get(index);
        while (!log.isBefore(tick, subtick)) {
            if (index == 0) {
                return -1;
            }
            log = logs.get(--index);
        }
        return index;
    }

    public EventLog getLastLogBefore(long tick) {
        return this.getLastLogBefore(tick, 0);
    }

    public EventLog getLastLogBefore(long tick, int subtick) {
        EventLog lastLog = null;
        for (EventType type : EventType.ALL) {
            int index = this.getLastLogBefore(type, tick, subtick);
            EventLog log = this.getLog(type, index);
            if (lastLog != null && (log == null || !log.isAfter(lastLog))) continue;
            lastLog = log;
        }
        return lastLog;
    }

    public int getFirstLogAfter(EventType type, long tick) {
        return this.getFirstLogAfter(type, tick, Integer.MAX_VALUE);
    }

    public int getFirstLogAfter(EventType type, long tick, int subtick) {
        List<EventLog> logs = this.getLogs(type);
        if (logs.isEmpty() || !logs.get(logs.size() - 1).isAfter(tick, subtick)) {
            return -1;
        }
        if (logs.get(0).isAfter(tick, subtick)) {
            return 0;
        }
        int index = ListUtils.binarySearch(logs, event -> event.isBefore(tick, subtick));
        EventLog log = logs.get(index);
        while (!log.isAfter(tick, subtick)) {
            if (index == logs.size() - 1) {
                return -1;
            }
            log = logs.get(++index);
        }
        return index;
    }

    public EventLog getFirstLogAfter(long tick) {
        return this.getFirstLogAfter(tick, 0);
    }

    public EventLog getFirstLogAfter(long tick, int subtick) {
        EventLog firstLog = null;
        for (EventType type : EventType.ALL) {
            int index = this.getFirstLogAfter(type, tick, subtick);
            EventLog log = this.getLog(type, index);
            if (firstLog != null && (log == null || !log.isBefore(firstLog))) continue;
            firstLog = log;
        }
        return firstLog;
    }

    public EventLog getLogAt(long tick, int subtick) {
        EventLog log = this.getLastLogBefore(tick, subtick + 1);
        return log != null && log.isAt(tick, subtick) ? log : null;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        for (EventType type : EventType.ALL) {
            class_2499 logs = this.toNbt(type);
            if (logs.isEmpty()) continue;
            nbt.method_10566(type.getLegacyKey(), (class_2520)logs);
        }
        return nbt;
    }

    private class_2499 toNbt(EventType type) {
        class_2499 list = new class_2499();
        for (EventLog log : this.getLogs(type)) {
            list.add((Object)log.toNbt());
        }
        return list;
    }

    public static Collection<EventLog> fromNbt(class_2487 nbt) {
        ArrayList<EventLog> logs = new ArrayList<EventLog>();
        for (String key : nbt.method_10541()) {
            EventType type = EventType.byLegacyKey(key);
            if (type == null) continue;
            logs.addAll(MeterLogs.fromNbt(type, nbt.method_10554(key, 10)));
        }
        return logs;
    }

    public static Collection<EventLog> fromNbt(EventType type, class_2499 nbt) {
        ArrayList<EventLog> logs = new ArrayList<EventLog>();
        for (int i = 0; i < nbt.size(); ++i) {
            logs.add(EventLog.fromNbt(nbt.method_10602(i)));
        }
        return logs;
    }
}

