/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.mixin.common;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import redstone.multimeter.common.TickTask;
import redstone.multimeter.interfaces.mixin.IMinecraftServer;
import redstone.multimeter.server.MultimeterServer;

@Mixin(value={MinecraftServer.class})
public class MinecraftServerMixin
implements IMinecraftServer {
    private MultimeterServer multimeterServer;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        this.multimeterServer = new MultimeterServer((MinecraftServer)this);
    }

    @Inject(method={"loadLevel"}, at={@At(value="TAIL")})
    private void levelLoaded(CallbackInfo ci) {
        this.multimeterServer.levelLoaded();
    }

    @Inject(method={"waitUntilNextTick"}, at={@At(value="HEAD")})
    private void startTickTaskPackets(CallbackInfo ci) {
        this.rsmm$startTickTask(TickTask.PACKETS, new String[0]);
    }

    @Inject(method={"waitUntilNextTick"}, at={@At(value="TAIL")})
    private void endTickTaskPackets(CallbackInfo ci) {
        this.rsmm$endTickTask();
        this.multimeterServer.tickEnd();
    }

    @Inject(method={"tickServer"}, at={@At(value="HEAD")})
    private void startTickTaskTick(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        this.rsmm$startTickTask(TickTask.TICK, new String[0]);
    }

    @Inject(method={"tickServer"}, at={@At(value="INVOKE_STRING", target="Lorg/apache/logging/log4j/Logger;debug(Ljava/lang/String;)V", args={"ldc=Autosave started"})})
    private void startTickTaskAutosave(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        this.rsmm$startTickTask(TickTask.AUTOSAVE, new String[0]);
    }

    @Inject(method={"tickServer"}, at={@At(value="INVOKE_STRING", target="Lorg/apache/logging/log4j/Logger;debug(Ljava/lang/String;)V", args={"ldc=Autosave finished"})})
    private void endTickTaskAutosave(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        this.rsmm$endTickTask();
    }

    @Inject(method={"tickServer"}, at={@At(value="TAIL")})
    private void endTickTaskTick(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        this.rsmm$endTickTask();
    }

    @Inject(method={"tickChildren"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;push(Ljava/lang/String;)V", args={"ldc=commandFunctions"})})
    private void startTickTaskCommandFunctions(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        this.rsmm$startTickTask(TickTask.COMMAND_FUNCTIONS, new String[0]);
    }

    @Inject(method={"tickChildren"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=levels"})})
    private void swapTickTaskLevels(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        this.rsmm$swapTickTask(TickTask.LEVELS, new String[0]);
    }

    @Inject(method={"tickChildren"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=connection"})})
    private void swapTickTaskConnections(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        this.rsmm$swapTickTask(TickTask.CONNECTIONS, new String[0]);
    }

    @Inject(method={"tickChildren"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=players"})})
    private void swapTickTaskPlayerPing(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        this.rsmm$swapTickTask(TickTask.PLAYER_PING, new String[0]);
    }

    @Inject(method={"tickChildren"}, at={@At(value="INVOKE_STRING", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", args={"ldc=server gui refresh"})})
    private void swapTickTaskServerGui(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        this.rsmm$swapTickTask(TickTask.SERVER_GUI, new String[0]);
    }

    @Inject(method={"tickChildren"}, at={@At(value="TAIL")})
    private void endTickTaskServerGui(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        this.rsmm$endTickTask();
    }

    @Inject(method={"reloadResources"}, at={@At(value="HEAD")})
    private void onReloadResources(Collection<String> datapacks, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        ((MinecraftServer)this).execute(() -> this.multimeterServer.getMultimeter().reloadOptions());
    }

    @Inject(method={"startProfilerTick"}, at={@At(value="HEAD")})
    private void onTickStart(CallbackInfo ci) {
        this.multimeterServer.tickStart();
    }

    @Override
    public MultimeterServer getMultimeterServer() {
        return this.multimeterServer;
    }

    @Override
    public boolean rsmm$isPaused() {
        return false;
    }
}

