/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.server;

import com.google.common.base.Suppliers;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1953;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import redstone.multimeter.block.Meterable;
import redstone.multimeter.block.PowerSource;
import redstone.multimeter.client.gui.text.ClickEvent;
import redstone.multimeter.client.gui.text.Formatting;
import redstone.multimeter.client.gui.text.HoverEvent;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.TextColor;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.common.DimPos;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.MeterGroup;
import redstone.multimeter.common.meter.MeterProperties;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.common.meter.event.MeterEvent;
import redstone.multimeter.common.network.RSMMPacket;
import redstone.multimeter.common.network.packets.ClearMeterGroupPacket;
import redstone.multimeter.common.network.packets.MeterGroupDefaultPacket;
import redstone.multimeter.common.network.packets.MeterGroupRefreshPacket;
import redstone.multimeter.common.network.packets.MeterGroupSubscriptionPacket;
import redstone.multimeter.interfaces.mixin.IBlock;
import redstone.multimeter.server.MultimeterServer;
import redstone.multimeter.server.meter.ServerMeterGroup;
import redstone.multimeter.server.meter.ServerMeterPropertiesManager;
import redstone.multimeter.server.meter.event.MeterEventPredicate;
import redstone.multimeter.server.option.Options;
import redstone.multimeter.server.option.OptionsManager;

public class Multimeter {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance(Locale.US);
    private final MultimeterServer server;
    private final Map<String, ServerMeterGroup> meterGroups;
    private final Map<UUID, ServerMeterGroup> subscriptions;
    private final Set<ServerMeterGroup> activeMeterGroups;
    private final Set<ServerMeterGroup> idleMeterGroups;
    private final ServerMeterPropertiesManager meterPropertiesManager;
    public Options options;

    public Multimeter(MultimeterServer server) {
        this.server = server;
        this.meterGroups = new LinkedHashMap<String, ServerMeterGroup>();
        this.subscriptions = new HashMap<UUID, ServerMeterGroup>();
        this.activeMeterGroups = new HashSet<ServerMeterGroup>();
        this.idleMeterGroups = new HashSet<ServerMeterGroup>();
        this.meterPropertiesManager = new ServerMeterPropertiesManager(this);
        this.reloadOptions();
    }

    public MultimeterServer getServer() {
        return this.server;
    }

    public Collection<ServerMeterGroup> getMeterGroups() {
        return Collections.unmodifiableCollection(this.meterGroups.values());
    }

    public ServerMeterGroup getMeterGroup(String name) {
        return this.meterGroups.get(name);
    }

    public boolean hasMeterGroup(String name) {
        return this.meterGroups.containsKey(name);
    }

    public ServerMeterGroup getSubscription(class_3222 player) {
        return this.subscriptions.get(player.method_5667());
    }

    public boolean hasSubscription(class_3222 player) {
        return this.subscriptions.containsKey(player.method_5667());
    }

    public boolean isOwnerOfSubscription(class_3222 player) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        return meterGroup != null && meterGroup.isOwnedBy(player);
    }

    public void reloadOptions() {
        this.options = this.server.isDedicatedServer() ? OptionsManager.load(this.server.getConfigDirectory()) : new Options();
    }

    public void tickStart(boolean paused) {
        if (!paused) {
            this.removeIdleMeterGroups();
            for (ServerMeterGroup meterGroup : this.meterGroups.values()) {
                meterGroup.tick();
            }
        }
    }

    public void tickEnd(boolean paused) {
        this.broadcastMeterUpdates();
        if (!paused) {
            this.broadcastMeterLogs();
        }
    }

    private void removeIdleMeterGroups() {
        Iterator<ServerMeterGroup> it = this.idleMeterGroups.iterator();
        while (it.hasNext()) {
            ServerMeterGroup meterGroup = it.next();
            if (!this.removeIdleMeterGroup(meterGroup)) continue;
            it.remove();
        }
    }

    private boolean removeIdleMeterGroup(ServerMeterGroup meterGroup) {
        if (meterGroup.hasMeters() && !meterGroup.isPastIdleTimeLimit()) {
            return false;
        }
        this.meterGroups.remove(meterGroup.getName(), meterGroup);
        if (meterGroup.hasMeters()) {
            this.notifyOwnerOfRemoval(meterGroup);
        }
        return true;
    }

    private void notifyOwnerOfRemoval(ServerMeterGroup meterGroup) {
        UUID ownerUuid = meterGroup.getOwner();
        class_3222 owner = this.server.getPlayerList().get(ownerUuid);
        if (owner != null) {
            Text message = Texts.translatable("rsmm.meterGroup.removed.idle", meterGroup.getName(), this.options.meter_group.max_idle_time);
            this.server.sendMessage(owner, message, false);
        }
    }

    private void broadcastMeterUpdates() {
        for (ServerMeterGroup meterGroup : this.meterGroups.values()) {
            meterGroup.broadcastUpdates();
        }
    }

    private void broadcastMeterLogs() {
        for (ServerMeterGroup meterGroup : this.meterGroups.values()) {
            meterGroup.getLogManager().broadcastLogs();
        }
    }

    public void onPlayerJoin(class_3222 player) {
        this.server.refreshTickPhaseTree(player);
        this.server.getPlayerList().updatePermissions(player);
    }

    public void onPlayerLeave(class_3222 player) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null) {
            this.removeSubscriberFromMeterGroup(meterGroup, player);
        }
    }

    public void addMeter(class_3222 player, MeterProperties properties) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null) {
            if (meterGroup.isPastMeterLimit()) {
                Text message = Texts.translatable("rsmm.meterGroup.meterLimitReached", this.options.meter_group.meter_limit);
                this.server.sendMessage(player, message, true);
            } else if (!this.addMeter(meterGroup, properties)) {
                this.refreshMeterGroup(meterGroup, player);
            }
        }
    }

    public boolean addMeter(ServerMeterGroup meterGroup, MeterProperties meterProperties) {
        MeterProperties.MutableMeterProperties properties = meterProperties.mutable();
        if (!this.meterPropertiesManager.validate(properties) || !meterGroup.addMeter(properties)) {
            return false;
        }
        DimPos pos = properties.getPos();
        class_3218 level = this.server.getLevel(pos);
        class_2338 blockPos = pos.getBlockPos();
        class_2680 state = level.method_8320(blockPos);
        this.logPowered((class_1937)level, blockPos, state);
        this.logActive((class_1937)level, blockPos, state);
        return true;
    }

    public void removeMeter(class_3222 player, long id) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null && !meterGroup.removeMeter(id)) {
            this.refreshMeterGroup(meterGroup, player);
        }
    }

    public void updateMeter(class_3222 player, long id, MeterProperties newProperties) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null && !meterGroup.updateMeter(id, newProperties)) {
            this.refreshMeterGroup(meterGroup, player);
        }
    }

    public void setMeterIndex(class_3222 player, long id, int index) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null && !meterGroup.setMeterIndex(id, index)) {
            this.refreshMeterGroup(meterGroup, player);
        }
    }

    public void clearMeterGroup(class_3222 player) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null) {
            this.clearMeterGroup(meterGroup);
        }
    }

    public void clearMeterGroup(ServerMeterGroup meterGroup) {
        meterGroup.clear();
        ClearMeterGroupPacket packet = new ClearMeterGroupPacket();
        this.server.getPlayerList().send((RSMMPacket)packet, meterGroup);
    }

    public void setMeters(class_3222 player, List<MeterProperties> meters) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null) {
            if (meterGroup.isOwnedBy(player)) {
                this.setMeters(meterGroup, meters);
            } else {
                Text message = Texts.translatable("rsmm.meterGroups.load.failure.notOwner", meterGroup.getName());
                this.server.sendMessage(player, message, false);
            }
        }
    }

    public void setMeters(ServerMeterGroup meterGroup, List<MeterProperties> meters) {
        this.clearMeterGroup(meterGroup);
        for (MeterProperties meter : meters) {
            this.addMeter(meterGroup, meter);
        }
    }

    public void createMeterGroup(class_3222 player, String name) {
        if (!MeterGroup.isValidName(name) || this.meterGroups.containsKey(name)) {
            return;
        }
        ServerMeterGroup meterGroup = new ServerMeterGroup(this, name, player);
        this.meterGroups.put(name, meterGroup);
        this.subscribeToMeterGroup(meterGroup, player);
    }

    public void subscribeToMeterGroup(ServerMeterGroup meterGroup, class_3222 player) {
        ServerMeterGroup prevSubscription = this.getSubscription(player);
        if (prevSubscription == meterGroup) {
            this.refreshMeterGroup(meterGroup, player);
        } else {
            if (prevSubscription != null) {
                this.removeSubscriberFromMeterGroup(prevSubscription, player);
            }
            this.addSubscriberToMeterGroup(meterGroup, player);
            this.onSubscriptionChanged(player, prevSubscription, meterGroup);
        }
    }

    public void subscribeToDefaultMeterGroup(class_3222 player) {
        MeterGroupDefaultPacket packet = new MeterGroupDefaultPacket();
        this.server.getPlayerList().send((RSMMPacket)packet, player);
    }

    private void addSubscriberToMeterGroup(ServerMeterGroup meterGroup, class_3222 player) {
        UUID playerUuid = player.method_5667();
        this.subscriptions.put(playerUuid, meterGroup);
        meterGroup.addSubscriber(playerUuid);
        if (meterGroup.updateIdleState()) {
            this.activeMeterGroups.add(meterGroup);
            this.idleMeterGroups.remove(meterGroup);
        }
    }

    public void unsubscribeFromMeterGroup(class_3222 player) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null) {
            this.unsubscribeFromMeterGroup(meterGroup, player);
        }
    }

    public void unsubscribeFromMeterGroup(ServerMeterGroup meterGroup, class_3222 player) {
        if (meterGroup.hasSubscriber(player)) {
            this.removeSubscriberFromMeterGroup(meterGroup, player);
            this.onSubscriptionChanged(player, meterGroup, null);
        }
    }

    private void removeSubscriberFromMeterGroup(ServerMeterGroup meterGroup, class_3222 player) {
        UUID playerUuid = player.method_5667();
        this.subscriptions.remove(playerUuid, meterGroup);
        meterGroup.removeSubscriber(playerUuid);
        if (meterGroup.updateIdleState()) {
            this.activeMeterGroups.remove(meterGroup);
            this.idleMeterGroups.add(meterGroup);
        }
    }

    private void onSubscriptionChanged(class_3222 player, ServerMeterGroup prevSubscription, ServerMeterGroup newSubscription) {
        MeterGroupSubscriptionPacket packet = newSubscription == null ? new MeterGroupSubscriptionPacket(prevSubscription.getName(), false) : new MeterGroupSubscriptionPacket(newSubscription.getName(), true);
        this.server.getPlayerList().send((RSMMPacket)packet, player);
        this.server.getPlayerList().updatePermissions(player);
    }

    public void clearMembersOfMeterGroup(ServerMeterGroup meterGroup) {
        for (UUID playerUuid : meterGroup.getMembers()) {
            this.removeMemberFromMeterGroup(meterGroup, playerUuid);
        }
    }

    public void addMemberToMeterGroup(ServerMeterGroup meterGroup, UUID playerUuid) {
        if (meterGroup.hasMember(playerUuid) || meterGroup.isOwnedBy(playerUuid)) {
            return;
        }
        class_3222 player = this.server.getPlayerList().get(playerUuid);
        if (player == null) {
            return;
        }
        meterGroup.addMember(playerUuid);
        Text message = Texts.translatable("rsmm.meterGroup.member.invited", meterGroup.getName(), Texts.translatable("rsmm.meterGroup.member.invited.here").format(style -> style.withHoverEvent(HoverEvent.showText(Texts.translatable("rsmm.meterGroup.member.invited.subscribe", meterGroup.getName()))).withClickEvent(ClickEvent.runCommand(String.format("/metergroup subscribe %s", meterGroup.getName()))).withColor(Formatting.GREEN)));
        this.server.sendMessage(player, message, false);
    }

    public void removeMemberFromMeterGroup(ServerMeterGroup meterGroup, UUID playerUuid) {
        class_3222 player;
        if (!meterGroup.hasMember(playerUuid)) {
            return;
        }
        meterGroup.removeMember(playerUuid);
        if (meterGroup.isPrivate() && (player = this.server.getPlayerList().get(playerUuid)) != null && meterGroup.hasSubscriber(playerUuid)) {
            this.unsubscribeFromMeterGroup(meterGroup, player);
            Text message = Texts.translatable("rsmm.meterGroup.member.removed", meterGroup.getName());
            this.server.sendMessage(player, message, false);
        }
    }

    public void refreshMeterGroup(class_3222 player) {
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null) {
            this.refreshMeterGroup(meterGroup, player);
        }
    }

    private void refreshMeterGroup(ServerMeterGroup meterGroup, class_3222 player) {
        MeterGroupRefreshPacket packet = new MeterGroupRefreshPacket(meterGroup);
        this.server.getPlayerList().send((RSMMPacket)packet, player);
    }

    public void teleportToMeter(class_3222 player, long id) {
        DimPos pos;
        class_3218 newLevel;
        Meter meter;
        if (!this.options.meter.allow_teleports) {
            Text message = Texts.translatable("rsmm.meter.teleport.notAllowed");
            this.server.sendMessage(player, message, false);
            return;
        }
        ServerMeterGroup meterGroup = this.getSubscription(player);
        if (meterGroup != null && (meter = meterGroup.getMeter(id)) != null && (newLevel = this.server.getLevel(pos = meter.getPos())) != null) {
            class_3218 oldLevel = player.method_14220();
            double oldX = player.method_23317();
            double oldY = player.method_23318();
            double oldZ = player.method_23321();
            class_2338 blockPos = pos.getBlockPos();
            double newX = (double)blockPos.method_10263() + 0.5;
            double newY = blockPos.method_10264();
            double newZ = (double)blockPos.method_10260() + 0.5;
            float newYRot = player.field_6031;
            float newXRot = player.field_5965;
            player.method_14251(newLevel, newX, newY, newZ, newYRot, newXRot);
            Text text = Texts.translatable("rsmm.meter.teleport.success", meter.getName());
            this.server.sendMessage(player, text, false);
            this.sendClickableReturnMessage(oldLevel, oldX, oldY, oldZ, newYRot, newXRot, player);
        }
    }

    private void sendClickableReturnMessage(class_3218 level, double _x, double _y, double _z, float _yaw, float _pitch, class_3222 player) {
        String dimension = level.method_27983().method_29177().toString();
        String x = NUMBER_FORMAT.format(_x);
        String y = NUMBER_FORMAT.format(_y);
        String z = NUMBER_FORMAT.format(_z);
        String yaw = NUMBER_FORMAT.format(_yaw);
        String pitch = NUMBER_FORMAT.format(_pitch);
        Text message = Texts.translatable("rsmm.meter.teleport.return", Texts.translatable("rsmm.meter.teleport.return.here").format(style -> style.withHoverEvent(HoverEvent.showText(Texts.translatable("rsmm.meter.teleport.return.teleport", Texts.keyValue(Texts.translatable("rsmm.meter.teleport.return.teleport.dimension"), dimension), Texts.keyValue(Texts.translatable("rsmm.meter.teleport.return.teleport.x"), x), Texts.keyValue(Texts.translatable("rsmm.meter.teleport.return.teleport.y"), y), Texts.keyValue(Texts.translatable("rsmm.meter.teleport.return.teleport.z"), z)))).withClickEvent(ClickEvent.runCommand(String.format("/execute in %s run tp @s %s %s %s %s %s", dimension, x, y, z, yaw, pitch))).withColor(TextColor.GREEN)));
        this.server.sendMessage(player, message, false);
    }

    public void onBlockChange(class_1937 level, class_2338 pos, class_2680 oldState, class_2680 newState) {
        class_2248 newBlock;
        class_2248 oldBlock = oldState.method_26204();
        if (oldBlock == (newBlock = newState.method_26204()) && ((IBlock)newBlock).rsmm$isPowerSource() && ((PowerSource)newBlock).rsmm$logPowerChangeOnStateChange()) {
            this.logPowerChange(level, pos, oldState, newState);
        }
        boolean wasMeterable = ((IBlock)oldBlock).rsmm$isMeterable();
        boolean isMeterable = ((IBlock)newBlock).rsmm$isMeterable();
        if (wasMeterable || isMeterable) {
            this.logActive(level, pos, newState);
        }
    }

    public void logPowered(class_1937 level, class_2338 pos, boolean powered) {
        this.tryLogEvent(level, pos, EventType.POWERED, powered ? 1 : 0, (ServerMeterGroup meterGroup, Meter meter, MeterEvent event) -> meter.setPowered(powered));
    }

    public void logPowered(class_1937 level, class_2338 pos, class_2680 state) {
        this.tryLogEvent(level, pos, EventType.POWERED, () -> ((IBlock)state.method_26204()).rsmm$isPowered(level, pos, state) ? 1 : 0, (ServerMeterGroup meterGroup, Meter meter, MeterEvent event) -> meter.setPowered(event.getMetadata() != 0));
    }

    public void logActive(class_1937 level, class_2338 pos, boolean active) {
        this.tryLogEvent(level, pos, EventType.ACTIVE, active ? 1 : 0, (ServerMeterGroup meterGroup, Meter meter, MeterEvent event) -> meter.setActive(active));
    }

    public void logActive(class_1937 level, class_2338 pos, class_2680 state) {
        this.tryLogEvent(level, pos, EventType.ACTIVE, () -> {
            class_2248 block = state.method_26204();
            return ((IBlock)block).rsmm$isMeterable() && ((Meterable)block).rsmm$isActive(level, pos, state) ? 1 : 0;
        }, (ServerMeterGroup meterGroup, Meter meter, MeterEvent event) -> meter.setActive(event.getMetadata() != 0));
    }

    public void logMoved(class_1937 level, class_2338 blockPos, class_2350 dir) {
        this.tryLogEvent(level, blockPos, EventType.MOVED, dir.method_10146());
    }

    public void moveMeters(class_1937 level, class_2338 blockPos, class_2350 dir) {
        DimPos pos = new DimPos(level, blockPos);
        for (ServerMeterGroup meterGroup : this.activeMeterGroups) {
            meterGroup.tryMoveMeter(pos, dir);
        }
    }

    public void logPowerChange(class_1937 level, class_2338 pos, int oldPower, int newPower) {
        if (oldPower != newPower) {
            this.tryLogEvent(level, pos, EventType.POWER_CHANGE, oldPower << 8 | newPower);
        }
    }

    public void logPowerChange(class_1937 level, class_2338 pos, class_2680 oldState, class_2680 newState) {
        this.tryLogEvent(level, pos, EventType.POWER_CHANGE, () -> {
            PowerSource block = (PowerSource)newState.method_26204();
            int oldPower = block.rsmm$getPowerLevel(level, pos, oldState);
            int newPower = block.rsmm$getPowerLevel(level, pos, newState);
            return oldPower << 8 | newPower;
        }, (ServerMeterGroup meterGroup, Meter meter, MeterEvent event) -> {
            int newPower;
            int data = event.getMetadata();
            int oldPower = data >> 8 & 0xFF;
            return oldPower != (newPower = data & 0xFF);
        });
    }

    public void logRandomTick(class_1937 level, class_2338 pos) {
        this.tryLogEvent(level, pos, EventType.RANDOM_TICK);
    }

    public void logScheduledTick(class_1937 level, class_2338 pos, class_1953 priority, boolean scheduling) {
        this.tryLogEvent(level, pos, EventType.SCHEDULED_TICK, (scheduling ? 0x40000000 : 0) | priority.method_8681() + 3);
    }

    public void logBlockEvent(class_1937 level, class_2338 pos, int type, int depth, boolean queueing) {
        this.tryLogEvent(level, pos, EventType.BLOCK_EVENT, (queueing ? 0x40000000 : 0) | depth << 4 | type);
    }

    public void logEntityTick(class_1937 level, class_1297 entity) {
        this.tryLogEvent(level, entity.method_24515(), EventType.ENTITY_TICK);
    }

    public void logBlockEntityTick(class_1937 level, class_2586 blockEntity) {
        this.tryLogEvent(level, blockEntity.method_11016(), EventType.BLOCK_ENTITY_TICK);
    }

    public void logBlockUpdate(class_1937 level, class_2338 pos) {
        this.tryLogEvent(level, pos, EventType.BLOCK_UPDATE);
    }

    public void logComparatorUpdate(class_1937 level, class_2338 pos) {
        this.tryLogEvent(level, pos, EventType.COMPARATOR_UPDATE);
    }

    public void logShapeUpdate(class_1937 level, class_2338 pos, class_2350 dir) {
        this.tryLogEvent(level, pos, EventType.SHAPE_UPDATE, dir.method_10146());
    }

    public void logObserverUpdate(class_1937 level, class_2338 pos) {
        this.tryLogEvent(level, pos, EventType.OBSERVER_UPDATE);
    }

    public void logInteractBlock(class_1937 level, class_2338 pos) {
        this.tryLogEvent(level, pos, EventType.INTERACT_BLOCK);
    }

    private void tryLogEvent(class_1937 level, class_2338 pos, EventType type) {
        this.tryLogEvent(level, pos, type, 0);
    }

    private void tryLogEvent(class_1937 level, class_2338 pos, EventType type, int data) {
        this.tryLogEvent(level, pos, type, data, (ServerMeterGroup meterGroup, Meter meter, MeterEvent event) -> true);
    }

    private void tryLogEvent(class_1937 level, class_2338 pos, EventType type, int data, MeterEventPredicate predicate) {
        this.tryLogEvent(level, pos, type, (Supplier<Integer>)Suppliers.memoize(() -> data), predicate);
    }

    private void tryLogEvent(class_1937 level, class_2338 pos, EventType type, Supplier<Integer> data, MeterEventPredicate predicate) {
        if (this.options.hasEventType(type)) {
            for (ServerMeterGroup meterGroup : this.activeMeterGroups) {
                meterGroup.tryLogEvent(level, pos, type, data, predicate);
            }
        }
    }

    static {
        NUMBER_FORMAT.setGroupingUsed(false);
    }
}

