/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.server;

import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.common.DimPos;
import redstone.multimeter.common.TickPhase;
import redstone.multimeter.common.TickPhaseTree;
import redstone.multimeter.common.TickTask;
import redstone.multimeter.common.network.RSMMPacket;
import redstone.multimeter.common.network.packets.HandshakePacket;
import redstone.multimeter.common.network.packets.TickPhaseTreePacket;
import redstone.multimeter.common.network.packets.TickTimePacket;
import redstone.multimeter.interfaces.mixin.IMinecraftServer;
import redstone.multimeter.server.Multimeter;
import redstone.multimeter.server.PlayerList;
import redstone.multimeter.server.ServerPacketHandler;
import redstone.multimeter.server.compat.CarpetCompat;

public class MultimeterServer {
    private final MinecraftServer server;
    private final ServerPacketHandler packetHandler;
    private final PlayerList playerList;
    private final Multimeter multimeter;
    private final TickPhaseTree tickPhaseTree;
    private final CarpetCompat carpetCompat;
    private boolean loaded;
    private TickPhase tickPhase;

    public MultimeterServer(MinecraftServer server) {
        this.server = server;
        this.packetHandler = new ServerPacketHandler(this);
        this.playerList = new PlayerList(this);
        this.multimeter = new Multimeter(this);
        this.tickPhaseTree = new TickPhaseTree();
        this.carpetCompat = new CarpetCompat(this);
        this.tickPhase = TickPhase.UNKNOWN;
    }

    public MinecraftServer getMinecraftServer() {
        return this.server;
    }

    public ServerPacketHandler getPacketHandler() {
        return this.packetHandler;
    }

    public Multimeter getMultimeter() {
        return this.multimeter;
    }

    public TickPhaseTree getTickPhaseTree() {
        return this.tickPhaseTree;
    }

    public long getTickCount() {
        return this.server.method_3780();
    }

    public boolean isDedicatedServer() {
        return this.server.method_3816();
    }

    public Path getConfigDirectory() {
        return this.server.method_3831().toPath().resolve("config/redstone_multimeter");
    }

    public TickPhase getTickPhase() {
        return this.tickPhase;
    }

    public void levelLoaded() {
        this.loaded = true;
    }

    public void startTickTask(TickTask task, String ... args) {
        this.tickPhase = this.tickPhase.startTask(task);
        if (this.tickPhaseTree.isBuilding()) {
            this.tickPhaseTree.startTask(task, args);
        }
    }

    public void endTickTask() {
        this.tickPhase = this.tickPhase.endTask();
        if (this.tickPhaseTree.isBuilding()) {
            this.tickPhaseTree.endTask();
        }
    }

    public void swapTickTask(TickTask task, String ... args) {
        this.tickPhase = this.tickPhase.swapTask(task);
        if (this.tickPhaseTree.isBuilding()) {
            this.tickPhaseTree.swapTask(task, args);
        }
    }

    public boolean isPaused() {
        return ((IMinecraftServer)this.server).rsmm$isPaused();
    }

    public boolean isPausedOrFrozen() {
        return this.isPaused() || this.carpetCompat.isFrozen();
    }

    public void tickStart() {
        boolean paused = this.isPaused();
        if (!paused) {
            if (this.shouldBuildTickPhaseTree()) {
                this.tickPhaseTree.start();
            }
            this.playerList.tick();
        }
        this.tickPhase = TickPhase.UNKNOWN;
        this.multimeter.tickStart(paused);
    }

    private boolean shouldBuildTickPhaseTree() {
        return this.loaded && !this.tickPhaseTree.isComplete() && !this.tickPhaseTree.isBuilding() && !this.isPausedOrFrozen() && !this.playerList.get().isEmpty();
    }

    public void tickEnd() {
        boolean paused = this.isPaused();
        if (this.tickPhaseTree.isBuilding()) {
            this.tickPhaseTree.end();
        }
        this.tickPhase = TickPhase.UNKNOWN;
        this.multimeter.tickEnd(paused);
    }

    public void tickTime(class_1937 level) {
        TickTimePacket packet = new TickTimePacket(level.method_8510());
        this.playerList.send((RSMMPacket)packet, (class_5321<class_1937>)level.method_27983());
    }

    public void onHandshake(class_3222 player, String modVersion) {
        if (!this.playerList.has(player.method_5667())) {
            this.playerList.add(player);
            HandshakePacket packet = new HandshakePacket();
            this.playerList.send((RSMMPacket)packet, player);
        }
    }

    public void onPlayerJoin(class_3222 player) {
        this.multimeter.onPlayerJoin(player);
    }

    public void onPlayerLeave(class_3222 player) {
        this.multimeter.onPlayerLeave(player);
    }

    public void refreshTickPhaseTree(class_3222 player) {
        if (this.tickPhaseTree.isComplete()) {
            TickPhaseTreePacket packet = new TickPhaseTreePacket(this.tickPhaseTree.toNbt());
            this.playerList.send((RSMMPacket)packet, player);
        }
    }

    public void rebuildTickPhaseTree(class_3222 player) {
        if (this.tickPhaseTree.isComplete()) {
            this.tickPhaseTree.reset();
        }
    }

    public Iterable<class_3218> getLevels() {
        return this.server.method_3738();
    }

    public class_3218 getLevel(class_2960 key) {
        return this.server.method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)key));
    }

    public class_3218 getLevel(DimPos pos) {
        return this.getLevel(pos.getDimension());
    }

    public class_2680 getBlockState(DimPos pos) {
        class_3218 level = this.getLevel(pos);
        if (level == null) {
            return null;
        }
        return level.method_8320(pos.getBlockPos());
    }

    public PlayerList getPlayerList() {
        return this.playerList;
    }

    public boolean isMultimeterClient(UUID uuid) {
        return this.playerList.has(uuid);
    }

    public boolean isMultimeterClient(class_3222 player) {
        return this.playerList.has(player.method_5667());
    }

    public void sendMessage(class_3222 player, Text message, boolean actionBar) {
        player.method_7353(message.resolve(), actionBar);
    }
}

