/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client;

import net.minecraft.class_304;
import net.minecraft.class_310;
import redstone.multimeter.client.Keybinds;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.element.input.KeyEvent;
import redstone.multimeter.client.gui.element.input.MouseEvent;
import redstone.multimeter.client.gui.screen.MultimeterScreen;
import redstone.multimeter.client.gui.screen.OptionsScreen;
import redstone.multimeter.client.gui.screen.RSMMScreen;
import redstone.multimeter.client.gui.screen.TickPhaseTreeScreen;
import redstone.multimeter.common.meter.event.EventType;

public class InputHandler {
    private final MultimeterClient client;

    public static boolean isControlDown() {
        return MultimeterClient.MINECRAFT.method_74188();
    }

    public static boolean isShiftDown() {
        return MultimeterClient.MINECRAFT.method_74187();
    }

    public static boolean isAltDown() {
        return MultimeterClient.MINECRAFT.method_74189();
    }

    public InputHandler(MultimeterClient client) {
        this.client = client;
    }

    public void handleKeybinds() {
        if (!this.client.isConnected()) {
            return;
        }
        while (Keybinds.OPEN_MULTIMETER_SCREEN.method_1436()) {
            this.client.openScreen(new MultimeterScreen());
        }
        while (Keybinds.OPEN_OPTIONS_MENU.method_1436()) {
            this.client.openScreen(new OptionsScreen());
        }
        while (Keybinds.VIEW_TICK_PHASE_TREE.method_1436()) {
            this.client.openScreen(new TickPhaseTreeScreen());
        }
        while (Keybinds.LOAD_METER_GROUP.method_1436()) {
            this.client.getSavedMeterGroupsManager().setLoading();
        }
        while (Keybinds.SAVE_METER_GROUP.method_1436()) {
            this.client.getSavedMeterGroupsManager().setSaving();
        }
        if (!Keybinds.LOAD_METER_GROUP.method_1434() && !Keybinds.SAVE_METER_GROUP.method_1434()) {
            this.client.getSavedMeterGroupsManager().setIdle();
        }
        if (!this.client.hasSubscription()) {
            return;
        }
        while (Keybinds.TOGGLE_METER.method_1436()) {
            this.client.toggleMeter();
        }
        while (Keybinds.RESET_METER.method_1436()) {
            this.client.resetMeter();
        }
        while (Keybinds.TOGGLE_HUD.method_1436()) {
            this.client.toggleHud();
        }
        while (Keybinds.PRINT_LOGS.method_1436()) {
            this.client.togglePrinter();
        }
        while (Keybinds.OPEN_METER_CONTROLS.method_1436()) {
            this.client.openMeterControls();
        }
        for (int index = 0; index < Keybinds.TOGGLE_EVENT_TYPES.length; ++index) {
            class_304 keybind = Keybinds.TOGGLE_EVENT_TYPES[index];
            while (keybind.method_1436()) {
                this.client.toggleEventType(EventType.byId(index));
            }
        }
        if (!this.client.isHudActive()) {
            return;
        }
        while (Keybinds.PAUSE_TIMELINE.method_1436()) {
            this.client.getHud().togglePaused();
        }
        while (Keybinds.TOGGLE_FOCUS_MODE.method_1436()) {
            this.client.getHud().toggleFocusMode();
        }
        while (Keybinds.TOGGLE_MARKER.method_1436()) {
            this.client.getHud().toggleTickMarker(InputHandler.isControlDown());
        }
        while (Keybinds.STEP_BACKWARD.method_1436()) {
            this.client.getHud().stepBackward(InputHandler.isControlDown());
        }
        while (Keybinds.STEP_FORWARD.method_1436()) {
            this.client.getHud().stepForward(InputHandler.isControlDown());
        }
    }

    public boolean handleHotbarKeybinds(int slot) {
        if (!this.client.isConnected()) {
            return false;
        }
        ++slot;
        if (Keybinds.LOAD_METER_GROUP.method_1434()) {
            boolean success = this.client.getSavedMeterGroupsManager().loadSlot(slot);
            if (success) {
                this.client.getTutorial().onMeterGroupLoaded(slot);
            }
            return success;
        }
        if (Keybinds.SAVE_METER_GROUP.method_1434()) {
            boolean success = this.client.getSavedMeterGroupsManager().saveSlot(slot);
            if (success) {
                this.client.getTutorial().onMeterGroupSaved(slot);
            }
            return success;
        }
        return false;
    }

    public boolean handleMouseScroll(double scrollX, double scrollY) {
        if (Keybinds.SCROLL_HUD.method_1434() && this.client.isHudActive() && this.client.getHud().isPaused()) {
            boolean forward;
            int scroll = (int)Math.round(scrollY);
            boolean bl = forward = scroll < 0;
            if (scroll != 0) {
                this.client.getHud().scroll(Math.abs(scroll), forward);
            }
        } else {
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean mouseClick(RSMMScreen screen, MouseEvent.Click event) {
        if (Keybinds.matches(Keybinds.OPEN_MULTIMETER_SCREEN, event)) {
            if (screen instanceof MultimeterScreen) {
                screen.close();
                return true;
            } else {
                class_310 minecraft = this.client.getMinecraft();
                if (minecraft.field_1724 == null) return true;
                this.client.openScreen(new MultimeterScreen());
            }
            return true;
        } else if (Keybinds.matches(Keybinds.OPEN_OPTIONS_MENU, event)) {
            if (screen instanceof OptionsScreen) {
                screen.close();
                return true;
            } else {
                this.client.openScreen(new OptionsScreen());
            }
            return true;
        } else if (Keybinds.matches(Keybinds.VIEW_TICK_PHASE_TREE, event)) {
            if (!this.client.isConnected()) {
                return false;
            }
            if (screen instanceof TickPhaseTreeScreen) {
                screen.close();
                return true;
            } else {
                this.client.openScreen(new TickPhaseTreeScreen());
            }
            return true;
        } else {
            if (!(screen instanceof MultimeterScreen)) return false;
            if (Keybinds.matches(Keybinds.PAUSE_TIMELINE, event)) {
                this.client.getHud().togglePaused();
                return true;
            } else if (Keybinds.matches(Keybinds.TOGGLE_FOCUS_MODE, event)) {
                this.client.getHud().toggleFocusMode();
                return true;
            } else if (Keybinds.matches(Keybinds.TOGGLE_MARKER, event)) {
                this.client.getHud().toggleTickMarker(InputHandler.isControlDown());
                return true;
            } else if (Keybinds.matches(Keybinds.STEP_BACKWARD, event)) {
                this.client.getHud().stepBackward(InputHandler.isControlDown());
                return true;
            } else {
                if (!Keybinds.matches(Keybinds.STEP_FORWARD, event)) return false;
                this.client.getHud().stepForward(InputHandler.isControlDown());
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean keyPress(RSMMScreen screen, KeyEvent.Press event) {
        if (Keybinds.matches(Keybinds.OPEN_MULTIMETER_SCREEN, event)) {
            if (screen instanceof MultimeterScreen) {
                screen.close();
                return true;
            } else {
                class_310 minecraft = this.client.getMinecraft();
                if (minecraft.field_1724 == null) return true;
                this.client.openScreen(new MultimeterScreen());
            }
            return true;
        } else if (Keybinds.matches(Keybinds.OPEN_OPTIONS_MENU, event)) {
            if (screen instanceof OptionsScreen) {
                screen.close();
                return true;
            } else {
                this.client.openScreen(new OptionsScreen());
            }
            return true;
        } else if (Keybinds.matches(Keybinds.VIEW_TICK_PHASE_TREE, event)) {
            if (!this.client.isConnected()) {
                return false;
            }
            if (screen instanceof TickPhaseTreeScreen) {
                screen.close();
                return true;
            } else {
                this.client.openScreen(new TickPhaseTreeScreen());
            }
            return true;
        } else {
            if (!(screen instanceof MultimeterScreen)) return false;
            if (Keybinds.matches(Keybinds.PAUSE_TIMELINE, event)) {
                this.client.getHud().togglePaused();
                return true;
            } else if (Keybinds.matches(Keybinds.TOGGLE_FOCUS_MODE, event)) {
                this.client.getHud().toggleFocusMode();
                return true;
            } else if (Keybinds.matches(Keybinds.TOGGLE_MARKER, event)) {
                this.client.getHud().toggleTickMarker(InputHandler.isControlDown());
                return true;
            } else if (Keybinds.matches(Keybinds.STEP_BACKWARD, event)) {
                this.client.getHud().stepBackward(InputHandler.isControlDown());
                return true;
            } else {
                if (!Keybinds.matches(Keybinds.STEP_FORWARD, event)) return false;
                this.client.getHud().stepForward(InputHandler.isControlDown());
            }
        }
        return true;
    }

    public boolean mouseScroll(RSMMScreen screen, MouseEvent.Scroll event) {
        if (screen instanceof MultimeterScreen) {
            if (!Keybinds.isPressed(Keybinds.SCROLL_HUD)) {
                return false;
            }
        } else {
            return false;
        }
        this.client.getHud().scroll((int)Math.round(event.scrollY()), true);
        return true;
    }
}

