/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;
import redstone.multimeter.RedstoneMultimeterMod;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.element.input.KeyEvent;
import redstone.multimeter.client.gui.element.input.MouseEvent;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.interfaces.mixin.IKeyMapping;

public class Keybinds {
    private static final String FILE_NAME = "hotkeys.txt";
    private static final Map<String, class_304.class_11900> CATEGORIES = new LinkedHashMap<String, class_304.class_11900>();
    private static final Map<String, class_304> KEYBINDS = new LinkedHashMap<String, class_304>();
    private static final Map<String, class_304> LEGACY_KEYBINDS = new HashMap<String, class_304>();
    public static final class_304[] TOGGLE_EVENT_TYPES = new class_304[EventType.ALL.length];
    public static final class_304.class_11900 MAIN = Keybinds.registerCategory("redstone_multimeter");
    public static final class_304.class_11900 METER_EVENT_TYPES = Keybinds.registerCategory("meter_event_types");
    public static final class_304 TOGGLE_METER = Keybinds.registerKeybind("toggleMeter", "Toggle Meter", MAIN, 77);
    public static final class_304 RESET_METER = Keybinds.registerKeybind("resetMeter", "Reset Meter", MAIN, 66);
    public static final class_304 LOAD_METER_GROUP = Keybinds.registerKeybind("loadMeterGroup", "Load Meter Group", MAIN, 91);
    public static final class_304 SAVE_METER_GROUP = Keybinds.registerKeybind("saveMeterGroup", "Save Meter Group", MAIN, 93);
    public static final class_304 PAUSE_TIMELINE = Keybinds.registerKeybind("pauseTimeline", "Pause Meters", MAIN, 78);
    public static final class_304 TOGGLE_FOCUS_MODE;
    public static final class_304 TOGGLE_MARKER;
    public static final class_304 STEP_BACKWARD;
    public static final class_304 STEP_FORWARD;
    public static final class_304 SCROLL_HUD;
    public static final class_304 TOGGLE_HUD;
    public static final class_304 OPEN_MULTIMETER_SCREEN;
    public static final class_304 OPEN_METER_CONTROLS;
    public static final class_304 OPEN_OPTIONS_MENU;
    public static final class_304 VIEW_TICK_PHASE_TREE;
    public static final class_304 PRINT_LOGS;

    private static class_304.class_11900 registerCategory(String name) {
        if (CATEGORIES.containsKey(name)) {
            throw new IllegalStateException("Cannot register multiple keybind categories with the same name! (" + name + ")");
        }
        class_2960 id = class_2960.method_60655((String)"redstone_multimeter", (String)name);
        class_304.class_11900 category = class_304.class_11900.method_74698((class_2960)id);
        CATEGORIES.put(name, category);
        return category;
    }

    private static class_304 registerKeybind(String name, String legacyName, class_304.class_11900 category, int defaultKey) {
        if (KEYBINDS.containsKey(name = "rsmm.keybind." + (String)name)) {
            throw new IllegalStateException("Cannot register multiple keybinds with the same name! (" + (String)name + ")");
        }
        class_304 keybind = new class_304((String)name, defaultKey, category);
        KEYBINDS.put((String)name, keybind);
        if (legacyName != null) {
            LEGACY_KEYBINDS.put(legacyName, keybind);
        }
        return keybind;
    }

    public static Collection<class_304.class_11900> getCategories() {
        return Collections.unmodifiableCollection(CATEGORIES.values());
    }

    public static Collection<class_304> getKeybinds() {
        return Collections.unmodifiableCollection(KEYBINDS.values());
    }

    public static void load(Path dir) {
        Path file = dir.resolve(FILE_NAME);
        if (!Files.exists(file, new LinkOption[0])) {
            Keybinds.save(dir);
            return;
        }
        try (BufferedReader br = Files.newBufferedReader(file);){
            String line;
            while ((line = br.readLine()) != null) {
                String[] args = line.split("=", 2);
                if (args.length < 2) continue;
                String name = args[0];
                String key = args[1];
                class_304 keybind = KEYBINDS.get(name);
                if (keybind == null) {
                    keybind = LEGACY_KEYBINDS.get(name);
                }
                if (keybind == null) continue;
                keybind.method_1422(class_3675.method_15981((String)key));
            }
        }
        catch (IOException e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while loading keybinds", (Throwable)e);
        }
    }

    public static void save(Path dir) {
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("unable to create parent directories of keybinds file", e);
            }
        }
        Path file = dir.resolve(FILE_NAME);
        try (BufferedWriter bw = Files.newBufferedWriter(file, new OpenOption[0]);){
            for (class_304 keybind : KEYBINDS.values()) {
                String name = keybind.method_1431();
                String key = keybind.method_1428();
                bw.write(name + "=" + key);
                bw.newLine();
            }
        }
        catch (IOException e) {
            RedstoneMultimeterMod.LOGGER.warn("exception while saving keybinds", (Throwable)e);
        }
    }

    public static boolean isPressed(class_304 keybind) {
        class_3675.class_306 key = ((IKeyMapping)keybind).rsmm$getKey();
        return key != null && GLFW.glfwGetKey((long)MultimeterClient.MINECRAFT.method_22683().method_4490(), (int)key.method_1444()) == 1;
    }

    public static boolean matches(class_304 keybind, MouseEvent event) {
        return keybind.method_1433(new class_11909(event.mouseX(), event.mouseY(), new class_11910(event.button(), -1)));
    }

    public static boolean matches(class_304 keybind, KeyEvent event) {
        return keybind.method_1417(new class_11908(event.keyCode(), event.scanCode(), event.modifiers()));
    }

    static {
        STEP_BACKWARD = Keybinds.registerKeybind("stepBackwardTimeline", "Step Backward", MAIN, 44);
        STEP_FORWARD = Keybinds.registerKeybind("stepForwardTimeline", "Step Forward", MAIN, 46);
        SCROLL_HUD = Keybinds.registerKeybind("scrollTimeline", "Scroll HUD", MAIN, 342);
        TOGGLE_HUD = Keybinds.registerKeybind("toggleHud", "Toggle HUD", MAIN, 72);
        TOGGLE_MARKER = Keybinds.registerKeybind("toggleTickMarker", "Toggle Tick Marker", MAIN, 89);
        TOGGLE_FOCUS_MODE = Keybinds.registerKeybind("toggleFocusMode", "Toggle Focus Mode", MAIN, 70);
        OPEN_MULTIMETER_SCREEN = Keybinds.registerKeybind("openMultimeterScreen", "Open Multimeter Screen", MAIN, 71);
        OPEN_METER_CONTROLS = Keybinds.registerKeybind("openMeterControlsScreen", "Open Meter Controls", MAIN, 73);
        OPEN_OPTIONS_MENU = Keybinds.registerKeybind("openOptionsScreen", "Open Options Menu", MAIN, 79);
        VIEW_TICK_PHASE_TREE = Keybinds.registerKeybind("openTickPhaseTreeScreen", "View Tick Phases", MAIN, 85);
        PRINT_LOGS = Keybinds.registerKeybind("toggleLogPrinter", "Print Logs To File", MAIN, 80);
        for (int index = 0; index < EventType.ALL.length; ++index) {
            Keybinds.TOGGLE_EVENT_TYPES[index] = Keybinds.registerKeybind("toggleMeterEventType." + EventType.byId(index).getKey(), String.format("Toggle '%s'", EventType.byId(index).getLegacyKey()), METER_EVENT_TYPES, -1);
        }
    }
}

