/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.compat.amecs;

import de.siphalor.amecs.api.KeyBindingUtils;
import de.siphalor.amecs.api.KeyModifier;
import de.siphalor.amecs.api.KeyModifiers;
import de.siphalor.amecs.impl.ModifierPrefixTextProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_304;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;

public class AmecsHelper {
    private static boolean isAmecsApiLoaded = FabricLoader.getInstance().isModLoaded("amecsapi");

    public static Collection<KeyModifier> getKeyModifiers(class_304 keybind) {
        KeyModifiers keyModifiers = KeyBindingUtils.getBoundModifiers((class_304)keybind);
        if (keyModifiers.isUnset()) {
            return Collections.emptyList();
        }
        LinkedList<KeyModifier> modifiers = new LinkedList<KeyModifier>();
        for (KeyModifier modifier : KeyModifier.VALUES) {
            if (modifier == KeyModifier.NONE || !keyModifiers.get(modifier)) continue;
            modifiers.add(modifier);
        }
        return modifiers;
    }

    public static Text getModifierName(KeyModifier modifier, ModifierPrefixTextProvider.Variation variation) {
        return Texts.key(variation.getTranslatableComponent(modifier.getTranslationKey()));
    }

    public static Text getModifierName(KeyModifier modifier) {
        return AmecsHelper.getModifierName(modifier, ModifierPrefixTextProvider.Variation.NORMAL);
    }

    public static Text addModifiers(Text text, class_304 keybind) {
        if (isAmecsApiLoaded) {
            Text t = Texts.literal("");
            for (KeyModifier modifier : AmecsHelper.getKeyModifiers(keybind)) {
                t.append(AmecsHelper.getModifierName(modifier)).append(" + ");
            }
            text = t.append(text);
        }
        return text;
    }
}

