/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.TextColor;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.util.ColorUtils;

public class FontRenderer {
    final class_327 font;
    class_332 graphics;

    public FontRenderer(MultimeterClient client) {
        class_310 minecraft = client.getMinecraft();
        this.font = minecraft.field_1772;
    }

    public int height() {
        Objects.requireNonNull(this.font);
        return 9;
    }

    public void draw(String s, int x, int y) {
        this.graphics.method_51433(this.font, s, x, y, -1, false);
    }

    public void draw(Text t, int x, int y) {
        this.graphics.method_51433(this.font, t.buildFormattedString(), x, y, this.resolveColor(t, -1), false);
    }

    public void draw(String s, int x, int y, int color) {
        this.graphics.method_51433(this.font, s, x, y, color, false);
    }

    public void draw(Text t, int x, int y, int color) {
        this.graphics.method_51433(this.font, t.buildFormattedString(), x, y, this.resolveColor(t, color), false);
    }

    public void drawWithShadow(String s, int x, int y) {
        this.graphics.method_51433(this.font, s, x, y, -1, true);
    }

    public void drawWithShadow(Text t, int x, int y) {
        this.graphics.method_51433(this.font, t.buildFormattedString(), x, y, this.resolveColor(t, -1), true);
    }

    public void drawWithShadow(String s, int x, int y, int color) {
        this.graphics.method_51433(this.font, s, x, y, color, true);
    }

    public void drawWithShadow(Text t, int x, int y, int color) {
        this.graphics.method_51433(this.font, t.buildFormattedString(), x, y, this.resolveColor(t, color), true);
    }

    public void draw(String s, int x, int y, int color, boolean shadow) {
        this.graphics.method_51433(this.font, s, x, y, color, shadow);
    }

    public void draw(Text t, int x, int y, int color, boolean shadow) {
        this.graphics.method_51433(this.font, t.buildFormattedString(), x, y, this.resolveColor(t, color), shadow);
    }

    private int resolveColor(Text t, int color) {
        TextColor textColor = t.getStyle().getColor();
        if (textColor != null) {
            int rgb = textColor.getColor();
            int alpha = ColorUtils.getAlpha(color);
            color = ColorUtils.setAlpha(rgb, alpha);
        }
        return color;
    }

    public String trim(String s, int width) {
        return this.font.method_27523(s, width);
    }

    public String trim(String s, int width, boolean rightToLeft) {
        return this.font.method_27524(s, width, rightToLeft);
    }

    public List<String> split(String s, int width) {
        ArrayList<String> lines = new ArrayList<String>();
        while (!s.isEmpty()) {
            int lastSpace = -1;
            int length = 0;
            while (++length < s.length()) {
                String substring;
                int index = length - 1;
                if (s.charAt(index) == ' ') {
                    lastSpace = index;
                }
                if (this.width(substring = s.substring(0, length)) <= width) continue;
                if (lastSpace >= 0) {
                    substring = s.substring(0, lastSpace);
                    length = lastSpace + 1;
                }
                lines.add(substring);
                break;
            }
            if (length == s.length()) {
                if (length <= 0) break;
                lines.add(s);
                break;
            }
            s = s.substring(length);
        }
        return lines;
    }

    public List<Text> split(Text s, int width) {
        return this.split(s.buildFormattedString(), width).stream().map(Texts::resolve).collect(Collectors.toList());
    }

    public int width(String s) {
        return this.font.method_1727(s);
    }

    public int width(Text t) {
        return this.font.method_1727(t.buildFormattedString());
    }

    public int width(Tooltip t) {
        int width = 0;
        for (Text line : t) {
            int w = this.width(line);
            if (w <= width) continue;
            width = w;
        }
        return width;
    }

    public int height(Tooltip t) {
        int height = -1;
        for (Text line : t) {
            height += this.height() + 1;
        }
        return height;
    }
}

