/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui;

import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.FontRenderer;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.texture.Texture;
import redstone.multimeter.client.gui.texture.TextureRegion;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.mixin.client.GuiGraphicsAccessor;

public class GuiRenderer {
    final class_332 graphics;
    final FontRenderer font;

    public GuiRenderer(GuiRenderer delegate) {
        this(delegate.graphics, delegate.font);
    }

    public GuiRenderer(class_332 graphics) {
        this(graphics, MultimeterClient.INSTANCE.getFontRenderer());
    }

    private GuiRenderer(class_332 graphics, FontRenderer font) {
        this.graphics = graphics;
        this.font = font;
        this.font.graphics = this.graphics;
    }

    public void pushMatrix() {
        this.graphics.method_51448().pushMatrix();
    }

    public void translate(double dx, double dy) {
        this.graphics.method_51448().translate((float)dx, (float)dy);
    }

    public void popMatrix() {
        this.graphics.method_51448().popMatrix();
    }

    public void fill(int x0, int y0, int x1, int y1, int color) {
        this.graphics.method_25294(x0, y0, x1, y1, color);
    }

    public void gradient(int x0, int y0, int x1, int y1, int color0, int color1) {
        this.graphics.method_25296(x0, y0, x1, y1, color0, color1);
    }

    public void highlight(int x0, int y0, int x1, int y1, int color) {
        this.graphics.method_48196(class_10799.field_61068, x0, y0, x1, y1, -1);
        this.graphics.method_48196(class_10799.field_56881, x0, y0, x1, y1, color);
    }

    public void borders(int x0, int y0, int x1, int y1, int color) {
        this.borders(x0, y0, x1, y1, 1, color);
    }

    public void borders(int x0, int y0, int x1, int y1, int w, int color) {
        this.fill(x0, y0, x0 + w, y1 - w, color);
        this.fill(x0, y1 - w, x1 - w, y1, color);
        this.fill(x1 - w, y0 + w, x1, y1, color);
        this.fill(x0 + w, y0, x1, y0 + w, color);
    }

    public void tooltip(Tooltip tooltip, int mouseX, int mouseY) {
        class_1041 window = MultimeterClient.MINECRAFT.method_22683();
        int windowWidth = window.method_4486();
        int windowHeight = window.method_4502();
        int tooltipWidth = this.font.width(tooltip) + 8;
        int tooltipHeight = this.font.height(tooltip) + 8;
        int x = mouseX + 15;
        int y = mouseY;
        if (x + tooltipWidth > windowWidth) {
            x = Math.max(0, windowWidth - tooltipWidth);
            y += 15;
        }
        if (y + tooltipHeight > windowHeight) {
            y = Math.max(0, windowHeight - tooltipHeight);
        }
        this.tooltip(tooltip, x, y, x + tooltipWidth, y + tooltipHeight);
    }

    public void tooltip(Tooltip tooltip, int x0, int y0, int x1, int y1) {
        this.tooltip(tooltip, x0, y0, x1, y1, -267386864, 0x505000FF, 1344798847);
    }

    public void tooltip(Tooltip tooltip, int x0, int y0, int x1, int y1, int backgroundColor, int borderColor0, int borderColor1) {
        this.fill(x0, y0 + 1, x1, y1 - 1, backgroundColor);
        this.fill(x0 + 1, y0, x1 - 1, y0 + 1, backgroundColor);
        this.fill(x0 + 1, y1 - 1, x1 - 1, y1, backgroundColor);
        this.gradient(x0 + 1, y0 + 2, x0 + 2, y1 - 2, borderColor0, borderColor1);
        this.fill(x0 + 1, y1 - 2, x1 - 1, y1 - 1, borderColor1);
        this.gradient(x1 - 2, y0 + 2, x1 - 1, y1 - 2, borderColor0, borderColor1);
        this.fill(x0 + 1, y0 + 1, x1 - 1, y0 + 2, borderColor0);
        int textX = x0 + 4;
        int textY = y0 + 4;
        for (Text line : tooltip) {
            this.drawStringWithShadow(line, textX, textY);
            textY += this.font.height() + 1;
        }
    }

    public void blit(Texture t, int x0, int y0, int x1, int y1) {
        this.blit(t, x0, y0, x1, y1, 0, 0, t.width, t.height);
    }

    public void blit(Texture t, int x0, int y0, int x1, int y1, int color) {
        this.blit(t, x0, y0, x1, y1, 0, 0, t.width, t.height, color);
    }

    public void blit(Texture t, int x0, int y0, int x1, int y1, int u0, int v0, int u1, int v1) {
        this.blit(t, x0, y0, x1, y1, u0, v0, u1, v1, -1);
    }

    public void blit(Texture t, int x0, int y0, int x1, int y1, int u0, int v0, int u1, int v1, int color) {
        ((GuiGraphicsAccessor)this.graphics).rsmm$innerBlit(class_10799.field_56883, t.location, x0, x1, y0, y1, (float)u0 / (float)t.width, (float)u1 / (float)t.width, (float)v0 / (float)t.height, (float)v1 / (float)t.height, color);
    }

    public void blit(TextureRegion t, int x0, int y0, int x1, int y1) {
        this.blit(t.texture, x0, y0, x1, y1, t.x, t.y, t.x + t.width, t.y + t.height);
    }

    public void blit(TextureRegion t, int x0, int y0, int x1, int y1, int color) {
        this.blit(t.texture, x0, y0, x1, y1, t.x, t.y, t.x + t.width, t.y + t.height, color);
    }

    public void blitSpliced(Texture t, int x0, int y0, int x1, int y1, int edge) {
        this.blitSpliced(t, x0, y0, x1, y1, 0, 0, t.width, t.height, edge);
    }

    public void blitSpliced(Texture t, int x0, int y0, int x1, int y1, int edge, int color) {
        this.blitSpliced(t, x0, y0, x1, y1, 0, 0, t.width, t.height, edge, color);
    }

    public void blitSpliced(Texture t, int x0, int y0, int x1, int y1, int u0, int v0, int u1, int v1, int edge) {
        this.blitSpliced(t, x0, y0, x1, y1, u0, v0, u1, v1, edge, -1);
    }

    public void blitSpliced(Texture t, int x0, int y0, int x1, int y1, int u0, int v0, int u1, int v1, int edge, int color) {
        boolean mh;
        boolean mw = x1 - x0 == u1 - u0;
        boolean bl = mh = y1 - y0 == v1 - v0;
        if (mw && mh) {
            this.blitTiled(t, x0, y0, x1, y1, u0, v0, u1, v1, color);
        } else if (mw) {
            this.blitTiled(t, x0, y0, x1, y0 + edge, u0, v0, u1, v0 + edge, color);
            this.blitTiled(t, x0, y0 + edge, x1, y1 - edge, u0, v0 + edge, u1, v1 - edge, color);
            this.blitTiled(t, x0, y1 - edge, x1, y1, u0, v1 - edge, u1, v1, color);
        } else if (mh) {
            this.blitTiled(t, x0, y0, x0 + edge, y1, u0, v0, u0 + edge, v1, color);
            this.blitTiled(t, x0 + edge, y0, x1 - edge, y1, u0 + edge, v0, u1 - edge, v1, color);
            this.blitTiled(t, x1 - edge, y0, x1, y1, u1 - edge, v0, u1, v1, color);
        } else {
            this.blitTiled(t, x0, y0, x0 + edge, y0 + edge, u0, v0, u0 + edge, v0 + edge, color);
            this.blitTiled(t, x0 + edge, y0, x1 - edge, y0 + edge, u0 + edge, v0, u1 - edge, v0 + edge, color);
            this.blitTiled(t, x1 - edge, y0, x1, y0 + edge, u1 - edge, v0, u1, v0 + edge, color);
            this.blitTiled(t, x0, y0 + edge, x0 + edge, y1 - edge, u0, v0 + edge, u0 + edge, v1 - edge, color);
            this.blitTiled(t, x0 + edge, y0 + edge, x1 - edge, y1 - edge, u0 + edge, v0 + edge, u1 - edge, v1 - edge, color);
            this.blitTiled(t, x1 - edge, y0 + edge, x1, y1 - edge, u1 - edge, v0 + edge, u1, v1 - edge, color);
            this.blitTiled(t, x0, y1 - edge, x0 + edge, y1, u0, v1 - edge, u0 + edge, v1, color);
            this.blitTiled(t, x0 + edge, y1 - edge, x1 - edge, y1, u0 + edge, v1 - edge, u1 - edge, v1, color);
            this.blitTiled(t, x1 - edge, y1 - edge, x1, y1, u1 - edge, v1 - edge, u1, v1, color);
        }
    }

    public void blitSpliced(TextureRegion t, int x0, int y0, int x1, int y1, int edge) {
        this.blitSpliced(t.texture, x0, y0, x1, y1, t.x, t.y, t.x + t.width, t.y + t.height, edge);
    }

    public void blitSpliced(TextureRegion t, int x0, int y0, int x1, int y1, int edge, int color) {
        this.blitSpliced(t.texture, x0, y0, x1, y1, t.x, t.y, t.x + t.width, t.y + t.height, edge, color);
    }

    public void blitTiled(Texture t, int x0, int y0, int x1, int y1) {
        this.blitTiled(t, x0, y0, x1, y1, 0, 0, t.width, t.height);
    }

    public void blitTiled(Texture t, int x0, int y0, int x1, int y1, int color) {
        this.blitTiled(t, x0, y0, x1, y1, 0, 0, t.width, t.height, color);
    }

    public void blitTiled(Texture t, int x0, int y0, int x1, int y1, int u0, int v0, int u1, int v1) {
        this.blitTiled(t, x0, y0, x1, y1, u0, v0, u1, v1, -1);
    }

    public void blitTiled(Texture t, int x0, int y0, int x1, int y1, int u0, int v0, int u1, int v1, int color) {
        int xs = x0;
        int ys = y0;
        int xf = x1;
        int yf = y1;
        x0 = xs;
        while (x0 < xf) {
            x1 = Math.min(x0 + (u1 - u0), xf);
            u1 = Math.min(u1, u0 + (x1 - x0));
            y0 = ys;
            while (y0 < yf) {
                y1 = Math.min(y0 + (v1 - v0), yf);
                v1 = Math.min(v1, v0 + (y1 - y0));
                this.blit(t, x0, y0, x1, y1, u0, v0, u1, v1, color);
                y0 = y1;
            }
            x0 = x1;
        }
    }

    public void blitTiled(TextureRegion t, int x0, int y0, int x1, int y1) {
        this.blitTiled(t.texture, x0, y0, x1, y1, t.x, t.y, t.x + t.width, t.y + t.height);
    }

    public void blitTiled(TextureRegion t, int x0, int y0, int x1, int y1, int color) {
        this.blitTiled(t.texture, x0, y0, x1, y1, t.x, t.y, t.x + t.width, t.y + t.height, color);
    }

    public void pushScissor(int x0, int y0, int x1, int y1) {
        this.graphics.method_44379(x0, y0, x1, y1);
    }

    public void popScissor() {
        this.graphics.method_44380();
    }

    public void renderItem(class_1799 item, int x, int y) {
        this.graphics.method_51445(item, x, y);
    }

    public void drawString(String s, int x, int y) {
        this.font.draw(s, x, y);
    }

    public void drawString(Text t, int x, int y) {
        this.font.draw(t, x, y);
    }

    public void drawString(String s, int x, int y, int color) {
        this.font.draw(s, x, y, color);
    }

    public void drawString(Text t, int x, int y, int color) {
        this.font.draw(t, x, y, color);
    }

    public void drawStringWithShadow(String s, int x, int y) {
        this.font.drawWithShadow(s, x, y);
    }

    public void drawStringWithShadow(Text t, int x, int y) {
        this.font.drawWithShadow(t, x, y);
    }

    public void drawStringWithShadow(String s, int x, int y, int color) {
        this.font.drawWithShadow(s, x, y, color);
    }

    public void drawStringWithShadow(Text t, int x, int y, int color) {
        this.font.drawWithShadow(t, x, y, color);
    }

    public void drawString(String s, int x, int y, int color, boolean shadow) {
        this.font.draw(s, x, y, color, shadow);
    }

    public void drawString(Text t, int x, int y, int color, boolean shadow) {
        this.font.draw(t, x, y, color, shadow);
    }

    public int width(String s) {
        return this.font.width(s);
    }

    public int width(Text t) {
        return this.font.width(t);
    }

    public int height() {
        return this.font.height();
    }
}

