/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.element.button;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import redstone.multimeter.client.MultimeterClient;

public interface SuggestionsProvider {
    public List<String> provide(String var1);

    public static SuggestionsProvider none() {
        return input -> Collections.emptyList();
    }

    public static SuggestionsProvider matching(Collection<String> resources, boolean suggestAllOnBlankInput) {
        return input -> {
            if (input.isBlank() && !suggestAllOnBlankInput) {
                return Collections.emptyList();
            }
            return SuggestionsProvider.suggestMatching(input, resources);
        };
    }

    public static <T> SuggestionsProvider resources(class_5321<class_2378<T>> key, boolean suggestAllOnBlankInput) {
        return input -> {
            if (input.isBlank() && !suggestAllOnBlankInput) {
                return Collections.emptyList();
            }
            class_310 minecraft = MultimeterClient.MINECRAFT;
            class_5455 registries = minecraft.field_1687.method_30349();
            return SuggestionsProvider.suggestResources(input, registries.method_30530(key).method_10235());
        };
    }

    public static SuggestionsProvider resources(Collection<class_2960> resources, boolean suggestAllOnBlankInput) {
        return input -> {
            if (input.isBlank() && !suggestAllOnBlankInput) {
                return Collections.emptyList();
            }
            return SuggestionsProvider.suggestResources(input, resources);
        };
    }

    public static List<String> suggestMatching(String input, Collection<String> strings) {
        TreeSet<String> start = new TreeSet<String>();
        TreeSet<String> anywhere = new TreeSet<String>();
        for (String string : strings) {
            if (string.length() <= input.length()) continue;
            if (string.startsWith(input)) {
                start.add(string);
                continue;
            }
            if (!string.contains(input)) continue;
            anywhere.add(string);
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        suggestions.addAll(start);
        suggestions.addAll(anywhere);
        return suggestions;
    }

    public static List<String> suggestResources(String input, Collection<class_2960> resources) {
        TreeSet<String> identifiersStart = new TreeSet<String>();
        TreeSet<String> identifiersAnywhere = new TreeSet<String>();
        TreeSet<CallSite> namespacesStart = new TreeSet<CallSite>();
        TreeSet<CallSite> namespacesAnywhere = new TreeSet<CallSite>();
        boolean hasSeparator = input.indexOf(58) > 0;
        for (class_2960 dimension : resources) {
            String identifier = dimension.toString();
            String namespace = dimension.method_12836() + ":";
            String path = dimension.method_12832();
            if (hasSeparator && identifier.length() > input.length() && identifier.startsWith(input)) {
                identifiersStart.add(identifier);
            }
            if (!hasSeparator && namespace.length() > input.length()) {
                if (namespace.startsWith(input)) {
                    namespacesStart.add((CallSite)((Object)namespace));
                } else if (namespace.contains(input)) {
                    namespacesAnywhere.add((CallSite)((Object)namespace));
                }
            }
            if (hasSeparator || path.length() <= input.length()) continue;
            if (path.startsWith(input)) {
                identifiersStart.add(identifier);
                continue;
            }
            if (!path.contains(input)) continue;
            identifiersAnywhere.add(identifier);
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        suggestions.addAll(namespacesStart);
        suggestions.addAll(namespacesAnywhere);
        suggestions.addAll(identifiersStart);
        suggestions.addAll(identifiersAnywhere);
        return suggestions;
    }
}

