/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.hud;

import redstone.multimeter.client.gui.hud.MultimeterHud;
import redstone.multimeter.client.option.Options;
import redstone.multimeter.util.ColorUtils;

public class HudSettings {
    public final int colorBackground;
    public final int colorGridMain;
    public final int colorGridInterval;
    public final int colorGridMarker;
    public final int colorHighlightHovered;
    public final int colorHighlightSelected;
    public final int colorTextOn;
    public final int colorTextOff;
    public int columnWidth;
    public int rowHeight;
    public int gridSize;
    public int scale;
    public int wparity;
    public int hparity;
    public int colorHighlightTickMarker;
    public boolean forceFullOpacity;
    public boolean ignoreHiddenMeters;

    public HudSettings(MultimeterHud hud) {
        this.colorBackground = -14671840;
        this.colorGridMain = -12566464;
        this.colorGridInterval = -10461088;
        this.colorGridMarker = -4144960;
        this.colorHighlightHovered = -8355712;
        this.colorHighlightSelected = -1;
        this.colorTextOn = -16777216;
        this.colorTextOff = -9408400;
    }

    public int opacity() {
        return 100;
    }

    public void optionsChanged() {
        this.scale = (Integer)Options.HUD.CELL_SCALE.get();
        this.columnWidth = (Integer)Options.HUD.COLUMN_WIDTH.get();
        this.rowHeight = (Integer)Options.HUD.ROW_HEIGHT.get();
        this.gridSize = (Integer)Options.HUD.GRID_SIZE.get();
        this.wparity = 1 - this.columnWidth % 2;
        this.hparity = 1 - this.rowHeight % 2;
        this.columnWidth *= this.scale;
        this.rowHeight *= this.scale;
        if (!this.setTickMarkerColor((String)Options.HUD.TICK_MARKER_COLOR.get())) {
            this.setTickMarkerColor((String)Options.HUD.TICK_MARKER_COLOR.getDefault());
        }
    }

    public boolean setTickMarkerColor(String hexColor) {
        try {
            int color = ColorUtils.fromRGBString(hexColor);
            this.colorHighlightTickMarker = ColorUtils.setAlpha(color, 255);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

