/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.hud.element;

import redstone.multimeter.client.InputHandler;
import redstone.multimeter.client.Keybinds;
import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.element.AbstractElement;
import redstone.multimeter.client.gui.element.input.CharacterEvent;
import redstone.multimeter.client.gui.element.input.KeyEvent;
import redstone.multimeter.client.gui.element.input.MouseEvent;
import redstone.multimeter.client.gui.hud.MultimeterHud;
import redstone.multimeter.client.gui.text.Formatting;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltip;
import redstone.multimeter.client.gui.tooltip.Tooltips;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.network.packets.MeterIndexPacket;
import redstone.multimeter.util.ColorUtils;

public class MeterListRenderer
extends AbstractElement {
    private static final int MARGIN = 1;
    private final MultimeterHud hud;
    private int cursorOriginRow;
    private int cursorRow;
    private Meter cursorMeter;
    private int cursorOffsetX;
    private int cursorOffsetY;

    public MeterListRenderer(MultimeterHud hud) {
        super(0, 0, 0, 0);
        this.hud = hud;
        this.cursorOriginRow = -1;
        this.cursorRow = -1;
    }

    @Override
    public void render(GuiRenderer renderer, int mouseX, int mouseY) {
        renderer.fill(0, 0, this.getWidth(), this.getHeight(), this.hud.settings.colorBackground);
        this.drawNames(renderer, mouseX, mouseY);
        this.drawHighlights(renderer, mouseX, mouseY);
    }

    @Override
    public void renderSecondPass(GuiRenderer renderer, int mouseX, int mouseY) {
        this.drawCursorMeter(renderer, mouseX, mouseY);
    }

    @Override
    public void mouseMove(double mouseX, double mouseY) {
    }

    @Override
    public boolean mouseClick(MouseEvent.Click event) {
        boolean consumed = super.mouseClick(event);
        if (event.isLeftButton()) {
            this.cursorOriginRow = this.hud.getHoveredRow(event.mouseY());
        }
        return consumed || this.cursorOriginRow >= 0;
    }

    @Override
    public boolean mouseRelease(MouseEvent.Release event) {
        boolean consumed = super.mouseRelease(event);
        if (event.isLeftButton()) {
            if (this.cursorMeter == null) {
                if (this.cursorRow < 0) {
                    consumed = this.hud.selectMeter(this.cursorOriginRow);
                }
            } else if (this.isMouseOver(event.mouseX(), event.mouseY())) {
                consumed = this.changeMeterIndex(this.cursorMeter, this.cursorOriginRow, this.hud.getHoveredRow(event.mouseY()));
            }
            this.cursorOriginRow = -1;
            this.cursorRow = -1;
            this.cursorMeter = null;
        }
        return consumed;
    }

    @Override
    public boolean mouseDrag(MouseEvent.Drag event) {
        int n = this.cursorRow = this.isMouseOver(event.mouseX(), event.mouseY()) ? this.hud.getHoveredRow(event.mouseY()) : -1;
        if (this.cursorMeter == null && this.cursorOriginRow >= 0) {
            this.cursorMeter = this.hud.meters.get(this.cursorOriginRow);
            this.cursorOffsetX = this.getX() - (int)event.mouseX();
            this.cursorOffsetY = this.getY() - (int)event.mouseY() + this.cursorOriginRow * (this.hud.settings.rowHeight + this.hud.settings.gridSize);
        }
        return false;
    }

    @Override
    public boolean mouseScroll(MouseEvent.Scroll event) {
        return false;
    }

    @Override
    public boolean keyPress(KeyEvent.Press event) {
        if (!this.hud.hasSelectedMeter()) {
            return false;
        }
        switch (event.keyCode()) {
            case 265: {
                this.moveSelection(InputHandler.isControlDown() ? -this.hud.getSelectedRow() : -1);
                break;
            }
            case 264: {
                this.moveSelection(InputHandler.isControlDown() ? this.hud.meters.size() - 1 - this.hud.getSelectedRow() : 1);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean keyRelease(KeyEvent.Release event) {
        return false;
    }

    @Override
    public boolean typeChar(CharacterEvent.Type event) {
        return false;
    }

    @Override
    public void tick() {
    }

    @Override
    public Tooltip getTooltip(int mouseX, int mouseY) {
        if (Keybinds.OPEN_METER_CONTROLS.method_1415() || this.cursorMeter != null) {
            return super.getTooltip(mouseX, mouseY);
        }
        int hoveredRow = this.hud.getHoveredRow(mouseY);
        if (hoveredRow < 0 || hoveredRow == this.hud.getSelectedRow()) {
            return super.getTooltip(mouseX, mouseY);
        }
        return Tooltips.keybind(Keybinds.OPEN_METER_CONTROLS);
    }

    @Override
    public void update() {
    }

    private void drawCursorMeter(GuiRenderer renderer, int mouseX, int mouseY) {
        if (this.cursorMeter != null) {
            int startX = mouseX + this.cursorOffsetX;
            int startY = mouseY + this.cursorOffsetY;
            int alpha = 221;
            int x0 = startX;
            int y0 = startY;
            int x1 = x0 + this.getWidth();
            int y1 = y0 + this.hud.settings.rowHeight + 2 * this.hud.settings.gridSize;
            int color = ColorUtils.setAlpha(this.hud.settings.colorBackground, alpha);
            renderer.fill(x0, y0, x1, y1, color);
            int x = startX + this.hud.settings.gridSize + 1;
            int y = startY + this.hud.settings.gridSize + 1 + this.hud.settings.rowHeight - (this.hud.settings.rowHeight + this.hud.font.height()) / 2;
            this.drawName(renderer, this.cursorMeter, x, y, ColorUtils.setAlpha(0xFFFFFF, alpha));
            x = startX;
            y = startY;
            if (this.cursorOriginRow == this.hud.getSelectedRow()) {
                this.drawHighlight(renderer, x, y, true);
            }
        }
    }

    private void drawHighlights(GuiRenderer renderer, int mouseX, int mouseY) {
        int focussedRow;
        if (this.hud.isOnScreen()) {
            if (this.cursorMeter == null && this.isMouseOver(mouseX, mouseY)) {
                this.drawHighlight(renderer, this.hud.getHoveredRow(mouseY), false);
            }
            int selectedRow = this.hud.getSelectedRow();
            if ((this.cursorMeter == null || selectedRow != this.cursorOriginRow) && selectedRow >= 0) {
                int highlightRow = selectedRow;
                if (this.cursorMeter != null) {
                    if (selectedRow > this.cursorOriginRow && selectedRow <= this.cursorRow) {
                        --highlightRow;
                    }
                    if (selectedRow < this.cursorOriginRow && selectedRow >= this.cursorRow) {
                        ++highlightRow;
                    }
                }
                this.drawHighlight(renderer, highlightRow, true);
            }
        } else if (this.hud.isFocusMode() && (focussedRow = this.hud.getFocussedRow()) != -1) {
            this.drawHighlight(renderer, focussedRow, true);
        }
    }

    private void drawHighlight(GuiRenderer renderer, int row, boolean selection) {
        int x = 0;
        int y = row * (this.hud.settings.rowHeight + this.hud.settings.gridSize);
        this.drawHighlight(renderer, x, y, selection);
    }

    private void drawHighlight(GuiRenderer renderer, int x, int y, boolean selection) {
        int x0 = x;
        int y0 = y;
        int x1 = x0 + this.getWidth();
        int y1 = y0 + this.hud.settings.rowHeight + 2 * this.hud.settings.gridSize;
        int color = selection ? this.hud.settings.colorHighlightSelected : this.hud.settings.colorHighlightHovered;
        renderer.borders(x0, y0, x1, y1, color);
    }

    private void drawNames(GuiRenderer renderer, int mouseX, int mouseY) {
        if (this.hud.settings.rowHeight < this.hud.font.height()) {
            return;
        }
        int startX = this.hud.settings.gridSize + 1;
        int startY = this.hud.settings.gridSize + 1 + this.hud.settings.rowHeight - (this.hud.settings.rowHeight + this.hud.font.height()) / 2;
        for (int index = 0; index < this.hud.meters.size(); ++index) {
            Meter meter = this.hud.meters.get(index);
            if (meter == this.cursorMeter) continue;
            int offset = index;
            if (this.cursorMeter != null && this.cursorRow >= 0) {
                if (index > this.cursorOriginRow && index <= this.cursorRow) {
                    --offset;
                }
                if (index < this.cursorOriginRow && index >= this.cursorRow) {
                    ++offset;
                }
            }
            int x = startX;
            int y = startY + offset * (this.hud.settings.rowHeight + this.hud.settings.gridSize);
            this.drawName(renderer, meter, x, y, -1);
        }
    }

    private void drawName(GuiRenderer renderer, Meter meter, int x, int y, int color) {
        Text name = Texts.literal(meter.getName());
        if (meter.isHidden()) {
            name.format(Formatting.GRAY, Formatting.ITALIC);
        }
        renderer.drawString(name, x, y, color);
    }

    public void updateWidth() {
        int width = 0;
        for (Meter meter : this.hud.meters) {
            int nameWidth = this.hud.font.width(meter.getName());
            if (nameWidth <= width) continue;
            width = nameWidth;
        }
        this.setWidth(width + 2 * this.hud.settings.gridSize + 1);
    }

    public void updateHeight() {
        this.setHeight(this.hud.meters.size() * (this.hud.settings.rowHeight + this.hud.settings.gridSize) + this.hud.settings.gridSize);
    }

    private void moveSelection(int amount) {
        int row = (this.hud.getSelectedRow() + amount) % this.hud.meters.size();
        this.hud.selectMeter(row < 0 ? row + this.hud.meters.size() : row);
    }

    private boolean changeMeterIndex(Meter meter, int oldIndex, int index) {
        if (meter == null || oldIndex < 0 || index < 0) {
            return false;
        }
        this.hud.meters.remove(oldIndex);
        this.hud.meters.add(index, meter);
        MeterIndexPacket packet = new MeterIndexPacket(meter.getId(), index);
        this.hud.client.sendPacket(packet);
        return true;
    }
}

