/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.hud.element;

import redstone.multimeter.client.gui.CursorType;
import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.element.Element;
import redstone.multimeter.client.gui.element.button.Button;
import redstone.multimeter.client.gui.element.input.MouseEvent;
import redstone.multimeter.client.gui.hud.MultimeterHud;
import redstone.multimeter.client.gui.hud.Orientation;
import redstone.multimeter.client.gui.hud.element.MeterEventViewer;
import redstone.multimeter.client.option.Options;

public class PrimaryEventViewer
extends MeterEventViewer {
    private double dx;
    private boolean resizing;
    private boolean updateCursor;

    public PrimaryEventViewer(MultimeterHud hud) {
        super(hud);
    }

    @Override
    public void mouseMove(double mouseX, double mouseY) {
        if (this.updateCursor) {
            this.updateCursor = false;
            if (this.isHovered()) {
                if (this.isMouseOverBorder(mouseX)) {
                    Element.setCursor(CursorType.HRESIZE);
                } else if (this.hud.isPaused()) {
                    Element.setCursor(CursorType.HAND);
                } else {
                    Element.setCursor(CursorType.ARROW);
                }
            } else {
                Element.setCursor(CursorType.ARROW);
            }
        }
    }

    @Override
    public boolean mouseClick(MouseEvent.Click event) {
        boolean wasDragging = this.isDraggingMouse();
        boolean consumed = super.mouseClick(event);
        if (!consumed && !wasDragging) {
            if (this.isDraggingMouse()) {
                this.dx = 0.0;
                if (this.isMouseOverBorder(event.mouseX())) {
                    this.setResizing(true);
                }
                consumed = true;
            }
            if (this.hud.isPaused() && !this.hud.isFocusMode() && event.isRightButton()) {
                int max;
                int column = this.getHoveredColumn(event.mouseX());
                if (column > (max = this.getColumnCount() - 1)) {
                    column = max;
                }
                Options.HUD.SELECTED_COLUMN.set(column);
                Button.playClickSound();
                consumed = true;
            }
        }
        return consumed;
    }

    @Override
    public boolean mouseRelease(MouseEvent.Release event) {
        if (event.isLeftButton()) {
            this.setResizing(false);
        }
        return super.mouseRelease(event);
    }

    @Override
    public boolean mouseDrag(MouseEvent.Drag event) {
        if (this.hud.isFocusMode() || !this.isDraggingMouse()) {
            return false;
        }
        return this.stepAndResize(event.deltaX());
    }

    @Override
    public boolean mouseScroll(MouseEvent.Scroll event) {
        if (this.hud.isFocusMode() || this.isDraggingMouse() || Math.abs(event.scrollX()) < 1.0) {
            return false;
        }
        return this.stepAndResize(event.scrollX());
    }

    @Override
    public void setHovered(boolean hovered) {
        boolean wasHovered = this.isHovered();
        super.setHovered(hovered);
        this.updateCursor = hovered || wasHovered;
    }

    @Override
    protected void drawHighlights(GuiRenderer renderer, int mouseX, int mouseY) {
        long tick;
        int column;
        if (this.hud.hasTickMarker() && (column = this.hud.getColumn(tick = this.hud.getTickMarker())) >= 0) {
            this.drawHighlight(renderer, column, 1, 0, this.hud.meters.size(), this.hud.settings.colorHighlightTickMarker);
        }
        if (this.hud.isPaused() || !((Boolean)Options.HUD.HIDE_HIGHLIGHT.get()).booleanValue()) {
            this.drawHighlight(renderer, (int)((Integer)Options.HUD.SELECTED_COLUMN.get()), 1, 0, this.hud.meters.size(), true);
            if (!this.isDraggingMouse() && this.isMouseOver(mouseX, mouseY) && !this.isMouseOverBorder(mouseX)) {
                this.drawHighlight(renderer, this.getHoveredColumn(mouseX), 1, 0, this.hud.meters.size(), false);
            }
        }
    }

    @Override
    protected void drawDecorators(GuiRenderer renderer) {
        if (this.hud.settings.rowHeight < this.hud.font.height()) {
            return;
        }
        long firstTick = this.hud.getSelectedTick() - (long)((Integer)Options.HUD.SELECTED_COLUMN.get()).intValue();
        long currentTick = this.hud.client.getPrevGameTime() + 1L;
        this.drawMeterLogs((x, y, meter) -> this.hud.eventRenderers.renderPulseLengths(renderer, x, y, firstTick, currentTick, meter));
    }

    @Override
    protected void drawMeterEvents(GuiRenderer renderer) {
        long firstTick = this.hud.getSelectedTick() - (long)((Integer)Options.HUD.SELECTED_COLUMN.get()).intValue();
        long lastTick = this.hud.client.getPrevGameTime() + 1L;
        this.drawMeterLogs((x, y, meter) -> this.hud.eventRenderers.renderTickLogs(renderer, x, y, firstTick, lastTick, meter));
    }

    @Override
    protected int getColumnCount() {
        return (Integer)Options.HUD.COLUMN_COUNT.get();
    }

    @Override
    protected int getCurrentTickMarkerColumn() {
        return this.hud.getColumn(this.hud.getCurrentTick(), true);
    }

    private boolean isMouseOverBorder(double mouseX) {
        long x = Math.round(mouseX);
        switch (this.hud.getOrientationX()) {
            default: {
                return x >= (long)(this.getX() + this.getWidth() - 1);
            }
            case RIGHT_TO_LEFT: 
        }
        return x <= (long)(this.getX() + 1);
    }

    private void setResizing(boolean resizing) {
        if (this.resizing != resizing) {
            this.resizing = resizing;
            this.dx = 0.0;
            if (this.resizing) {
                Element.setCursor(CursorType.HRESIZE);
            } else {
                Element.setCursor(CursorType.ARROW);
            }
        }
    }

    private boolean stepAndResize(double deltaX) {
        this.dx += deltaX;
        int width = this.hud.settings.columnWidth + this.hud.settings.gridSize;
        double d = (double)width / 2.0;
        int c = 0;
        while (this.dx > d) {
            this.dx -= (double)width;
            ++c;
        }
        while (this.dx < -d) {
            this.dx += (double)width;
            --c;
        }
        if (c != 0) {
            if (this.hud.getOrientationX() == Orientation.X.RIGHT_TO_LEFT) {
                c *= -1;
            }
            if (this.resizing) {
                int columns = (Integer)Options.HUD.COLUMN_COUNT.get();
                Options.HUD.COLUMN_COUNT.set(columns + c);
                Options.validate();
                this.hud.updateWidth();
            } else {
                this.hud.scroll(c, false);
            }
        }
        return true;
    }
}

