/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.hud.event;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.hud.MultimeterHud;
import redstone.multimeter.client.gui.hud.event.ActiveEventRenderer;
import redstone.multimeter.client.gui.hud.event.BasicEventRenderer;
import redstone.multimeter.client.gui.hud.event.BlockEventEventRenderer;
import redstone.multimeter.client.gui.hud.event.MeterEventRenderer;
import redstone.multimeter.client.gui.hud.event.PowerChangeEventRenderer;
import redstone.multimeter.client.gui.hud.event.PoweredEventRenderer;
import redstone.multimeter.client.gui.hud.event.ScheduledTickEventRenderer;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.event.EventType;

public class MeterEventRenderDispatcher {
    private final Map<EventType, MeterEventRenderer> eventRenderers = new HashMap<EventType, MeterEventRenderer>();
    private final BasicEventRenderer basicEventRenderer;

    public MeterEventRenderDispatcher(MultimeterHud hud) {
        this.basicEventRenderer = new BasicEventRenderer(hud);
        this.registerEventRenderer(new PoweredEventRenderer(hud));
        this.registerEventRenderer(new ActiveEventRenderer(hud));
        this.registerEventRenderer(new PowerChangeEventRenderer(hud));
        this.registerEventRenderer(new ScheduledTickEventRenderer(hud));
        this.registerEventRenderer(new BlockEventEventRenderer(hud));
    }

    private void registerEventRenderer(MeterEventRenderer eventRenderer) {
        this.eventRenderers.put(eventRenderer.getType(), eventRenderer);
    }

    private MeterEventRenderer getEventRenderer(EventType type) {
        MeterEventRenderer eventRenderer = this.eventRenderers.get((Object)type);
        if (eventRenderer == null) {
            this.basicEventRenderer.setType(type);
            return this.basicEventRenderer;
        }
        return eventRenderer;
    }

    public void renderTickLogs(GuiRenderer renderer, int x, int y, long firstTick, long lastTick, Meter meter) {
        this.renderMeterEvents(renderer, meter, eventRenderer -> eventRenderer.renderTickLogs(renderer, x, y, firstTick, lastTick, meter));
    }

    public void renderPulseLengths(GuiRenderer renderer, int x, int y, long firstTick, long lastTick, Meter meter) {
        this.renderMeterEvents(renderer, meter, eventRenderer -> eventRenderer.renderPulseLengths(renderer, x, y, firstTick, lastTick, meter));
    }

    public void renderSubtickLogs(GuiRenderer renderer, int x, int y, long tick, int subTickCount, Meter meter) {
        this.renderMeterEvents(renderer, meter, eventRenderer -> eventRenderer.renderSubtickLogs(renderer, x, y, tick, subTickCount, meter));
    }

    private void renderMeterEvents(GuiRenderer renderer, Meter meter, Consumer<MeterEventRenderer> consumer) {
        for (EventType type : EventType.ALL) {
            if (!meter.isMetering(type)) continue;
            consumer.accept(this.getEventRenderer(type));
        }
    }
}

