/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.hud.event;

import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.hud.MultimeterHud;
import redstone.multimeter.client.gui.hud.event.MeterEventRenderer;
import redstone.multimeter.client.option.Options;
import redstone.multimeter.common.meter.Meter;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.common.meter.log.EventLog;
import redstone.multimeter.common.meter.log.MeterLogs;

public abstract class ToggleEventRenderer
extends MeterEventRenderer {
    protected Mode mode;

    protected ToggleEventRenderer(MultimeterHud client, EventType type) {
        super(client, type);
    }

    @Override
    public void renderTickLogs(GuiRenderer renderer, int x, int y, long firstTick, long lastTick, Meter meter) {
        this.updateMode(meter);
        y += this.hud.settings.gridSize;
        int color = meter.getColor();
        MeterLogs logs = meter.getLogs();
        int index = logs.getLastLogBefore(this.type, firstTick);
        EventLog log = logs.getLog(this.type, index);
        EventLog nextLog = logs.getLog(this.type, ++index);
        long lastHudTick = firstTick + (long)((Integer)Options.HUD.COLUMN_COUNT.get()).intValue();
        if (lastHudTick > lastTick) {
            lastHudTick = lastTick;
        }
        if (nextLog == null) {
            if (this.isToggled(meter)) {
                this.draw(renderer, x + this.hud.settings.gridSize, y, color, (int)(lastHudTick - firstTick));
            }
            return;
        }
        long currentTick = -1L;
        while (log == null || log.isBefore(lastHudTick)) {
            long end;
            boolean isNextLogInTable;
            boolean isLogInTable = log != null && !log.isBefore(firstTick);
            boolean bl = isNextLogInTable = nextLog != null && nextLog.isBefore(lastHudTick);
            if (isLogInTable && log.getTick() != currentTick) {
                currentTick = log.getTick();
                int column = (int)(log.getTick() - firstTick);
                int columnX = x + column * (this.hud.settings.columnWidth + this.hud.settings.gridSize) + this.hud.settings.gridSize;
                if (this.wasToggled(log)) {
                    this.drawOn(renderer, columnX, y, color);
                } else {
                    this.drawOff(renderer, columnX, y, color);
                }
            }
            long start = isLogInTable ? log.getTick() + 1L : firstTick;
            long l = end = isNextLogInTable ? nextLog.getTick() : lastHudTick;
            if (log == null ? !this.wasToggled(nextLog) : this.wasToggled(log)) {
                int column = (int)(start - firstTick);
                int columnX = x + column * (this.hud.settings.columnWidth + this.hud.settings.gridSize) + this.hud.settings.gridSize;
                this.draw(renderer, columnX, y, color, (int)(end - start));
            }
            do {
                log = nextLog;
            } while ((nextLog = logs.getLog(this.type, ++index)) != null && nextLog.getTick() == currentTick);
            if (log != null) continue;
            break;
        }
    }

    @Override
    public void renderPulseLengths(GuiRenderer renderer, int x, int y, long firstTick, long lastTick, Meter meter) {
        EventLog nextLog;
        this.updateMode(meter);
        if (this.mode != Mode.ALL) {
            return;
        }
        int textY = (y += this.hud.settings.gridSize) + this.hud.settings.rowHeight - (this.hud.settings.rowHeight + this.hud.font.height()) / 2;
        int color = meter.getColor();
        MeterLogs logs = meter.getLogs();
        int index = logs.getLastLogBefore(this.type, firstTick);
        EventLog log = logs.getLog(this.type, index);
        if ((nextLog = logs.getLog(this.type, ++index)) == null) {
            return;
        }
        long lastHudTick = firstTick + (long)((Integer)Options.HUD.COLUMN_COUNT.get()).intValue();
        if (lastHudTick > lastTick) {
            lastHudTick = lastTick;
        }
        long currentTick = -1L;
        while (log == null || log.isBefore(lastHudTick)) {
            long pulseLength;
            long end;
            boolean isLogInTable = log != null && !log.isBefore(firstTick);
            boolean isNextLogInTable = nextLog != null && nextLog.isBefore(lastHudTick);
            long start = isLogInTable ? log.getTick() + 1L : firstTick;
            long l = end = isNextLogInTable ? nextLog.getTick() : lastHudTick;
            if (log != null && nextLog != null && (pulseLength = nextLog.getTick() - log.getTick()) > 5L) {
                int startX = x + (int)(start - firstTick) * (this.hud.settings.columnWidth + this.hud.settings.gridSize) + this.hud.settings.gridSize;
                int endX = x + (int)(end - firstTick) * (this.hud.settings.columnWidth + this.hud.settings.gridSize) + this.hud.settings.gridSize;
                String text = String.valueOf(pulseLength);
                int availableWidth = endX - startX;
                int requiredWidth = this.hud.font.width(text) + 1;
                if (requiredWidth < availableWidth) {
                    boolean toggled = this.wasToggled(log);
                    int bgColor = toggled ? color : this.hud.settings.colorBackground;
                    int textColor = toggled ? this.hud.settings.colorTextOn : this.hud.settings.colorTextOff;
                    renderer.fill(startX, y, startX + requiredWidth, y + this.hud.settings.rowHeight, bgColor);
                    renderer.drawString(text, startX + 1, textY + 1, textColor);
                }
            }
            do {
                log = nextLog;
            } while ((nextLog = logs.getLog(this.type, ++index)) != null && nextLog.getTick() == currentTick);
            if (log != null) continue;
            break;
        }
    }

    @Override
    public void renderSubtickLogs(GuiRenderer renderer, int x, int y, long tick, int subtickCount, Meter meter) {
        this.updateMode(meter);
        y += this.hud.settings.gridSize;
        int color = meter.getColor();
        MeterLogs logs = meter.getLogs();
        int index = logs.getLastLogBefore(this.type, tick);
        EventLog log = logs.getLog(this.type, index);
        EventLog nextLog = logs.getLog(this.type, ++index);
        if (nextLog == null) {
            if (this.isToggled(meter)) {
                this.draw(renderer, x + this.hud.settings.gridSize, y, color, subtickCount);
            }
            return;
        }
        while (log == null || log.isBefore(tick, subtickCount)) {
            int end;
            boolean isNextLogInTable;
            boolean isLogInTable = log != null && log.isAt(tick);
            boolean bl = isNextLogInTable = nextLog != null && nextLog.isAt(tick);
            if (isLogInTable) {
                int column = log.getSubtick();
                int columnX = x + column * (this.hud.settings.columnWidth + this.hud.settings.gridSize) + this.hud.settings.gridSize;
                if (this.wasToggled(log)) {
                    this.drawOn(renderer, columnX, y, color);
                } else {
                    this.drawOff(renderer, columnX, y, color);
                }
            }
            int start = isLogInTable ? log.getSubtick() + 1 : 0;
            int n = end = isNextLogInTable ? nextLog.getSubtick() : subtickCount;
            if (log == null ? !this.wasToggled(nextLog) : this.wasToggled(log)) {
                int columnX = x + start * (this.hud.settings.columnWidth + this.hud.settings.gridSize) + this.hud.settings.gridSize;
                this.draw(renderer, columnX, y, color, end - start);
            }
            log = nextLog;
            nextLog = logs.getLog(this.type, ++index);
            if (log != null) continue;
            break;
        }
    }

    protected abstract void updateMode(Meter var1);

    private boolean wasToggled(EventLog log) {
        return (log.getEvent().getMetadata() & 1) != 0;
    }

    protected abstract boolean isToggled(Meter var1);

    private void draw(GuiRenderer renderer, int x, int y, int color) {
        int height = this.hud.settings.rowHeight;
        if (this.mode != Mode.ALL) {
            height -= height / 2;
            if (this.mode == Mode.BOTTOM) {
                y += this.hud.settings.rowHeight - height;
            }
        }
        int x0 = x;
        int y0 = y;
        int x1 = x0 + this.hud.settings.columnWidth;
        int y1 = y0 + height;
        renderer.fill(x0, y0, x1, y1, color);
    }

    private void draw(GuiRenderer renderer, int x, int y, int color, int count) {
        for (int i = 0; i < count; ++i) {
            this.draw(renderer, x + i * (this.hud.settings.columnWidth + this.hud.settings.gridSize), y, color);
        }
    }

    private void drawOn(GuiRenderer renderer, int x, int y, int color) {
        int border = this.hud.settings.scale;
        int width = this.hud.settings.columnWidth - 2 * border;
        int height = this.hud.settings.rowHeight - 2 * border;
        int heightOffset = 0;
        if (this.mode != Mode.ALL) {
            height /= 2;
            if (this.mode == Mode.BOTTOM) {
                heightOffset = this.hud.settings.rowHeight - (height + 2 * this.hud.settings.scale);
            }
        }
        int x0 = x + border;
        int y0 = y + border + heightOffset;
        int x1 = x0 + width;
        int y1 = y0 + height;
        renderer.fill(x0, y0, x1, y1, color);
    }

    private void drawOff(GuiRenderer renderer, int x, int y, int color) {
        this.draw(renderer, x, y, color);
        this.drawOn(renderer, x, y, this.hud.settings.colorBackground);
    }

    protected static enum Mode {
        ALL,
        TOP,
        BOTTOM;

    }
}

