/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.screen;

import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.class_151;
import net.minecraft.class_2960;
import net.minecraft.class_7924;
import redstone.multimeter.client.gui.element.BlockSelectorList;
import redstone.multimeter.client.gui.element.ScrollableList;
import redstone.multimeter.client.gui.element.button.BasicButton;
import redstone.multimeter.client.gui.element.button.Button;
import redstone.multimeter.client.gui.element.button.Slider;
import redstone.multimeter.client.gui.element.button.SuggestionsMenu;
import redstone.multimeter.client.gui.element.button.SuggestionsProvider;
import redstone.multimeter.client.gui.element.button.TextField;
import redstone.multimeter.client.gui.element.button.ToggleButton;
import redstone.multimeter.client.gui.element.input.KeyEvent;
import redstone.multimeter.client.gui.element.meter.MeterPropertyElement;
import redstone.multimeter.client.gui.screen.RSMMScreen;
import redstone.multimeter.client.gui.text.Formatting;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;
import redstone.multimeter.client.gui.tooltip.Tooltips;
import redstone.multimeter.client.meter.ClientMeterPropertiesManager;
import redstone.multimeter.common.meter.MeterProperties;
import redstone.multimeter.common.meter.event.EventType;
import redstone.multimeter.util.ColorUtils;

public class DefaultMeterPropertiesScreen
extends RSMMScreen {
    private static final int SIDE_SPACING = 10;
    private static final int TOP_SPACING = 30;
    private static final int BOTTOM_SPACING = 38;
    private static final int BLOCK_LIST_TOP_BORDER = 52;
    private static final int BLOCK_LIST_BOTTOM_BORDER = 27;
    private static final int PROPERTIES_LIST_TOP_BORDER = 6;
    private static final int PROPERTIES_LIST_BOTTOM_BORDER = 3;
    private final ClientMeterPropertiesManager meterPropertiesManager;
    private final Map<class_2960, EditableMeterProperties> defaults;
    private final Map<class_2960, EditableMeterProperties> overrides;
    private Tab currentTab;
    private class_2960 currentBlock;
    private BlockSelectorList blockList;
    private ScrollableList propertiesList;
    private TextField searchbar;
    private Button add;
    private Button remove;
    private TextField create;

    protected DefaultMeterPropertiesScreen() {
        super(Texts.translatable("rsmm.gui.defaultMeterProperties.title"), true);
        MeterProperties properties;
        class_2960 key;
        this.meterPropertiesManager = this.client.getMeterPropertiesManager();
        this.defaults = new HashMap<class_2960, EditableMeterProperties>();
        this.overrides = new HashMap<class_2960, EditableMeterProperties>();
        for (Map.Entry<class_2960, MeterProperties> entry : this.meterPropertiesManager.getDefaults().entrySet()) {
            key = entry.getKey();
            properties = entry.getValue();
            this.defaults.put(key, new EditableMeterProperties(this, properties));
        }
        for (Map.Entry<class_2960, MeterProperties> entry : this.meterPropertiesManager.getOverrides().entrySet()) {
            key = entry.getKey();
            properties = entry.getValue();
            this.overrides.put(key, new EditableMeterProperties(this, properties));
        }
    }

    @Override
    public boolean keyPress(KeyEvent.Press event) {
        boolean consumed;
        boolean bl = consumed = super.keyPress(event) || this.blockList.keyPress(event);
        if (!consumed) {
            if (this.remove.isActive() && event.keyCode() == 333) {
                this.remove();
                consumed = true;
            } else if (this.add.isActive() && event.keyCode() == 334) {
                this.add();
                consumed = true;
            }
        }
        return consumed;
    }

    @Override
    protected void initScreen() {
        int listWidth = (this.getWidth() - 30) / 2;
        int listHeight = this.getHeight() - 30 - 38;
        int x = this.getX() + 10;
        int y = this.getY() + 30;
        this.blockList = new BlockSelectorList(listWidth, listHeight, 52, 27, key -> this.selectBlock((class_2960)key));
        this.blockList.setSpacing(0);
        this.blockList.setDrawBackground(true);
        this.blockList.setBlockFilter(id -> id.toString().contains(this.searchbar.getValue()));
        this.blockList.setX(x);
        this.blockList.setY(y);
        int tabWidth = (listWidth - 6) / 2;
        Button defaultsTab = this.createTabButton(Tab.BUILT_IN, x += 2, y += 2, tabWidth, 20);
        Button overridesTab = this.createTabButton(Tab.OVERRIDES, x + (listWidth - 2) - (tabWidth + 2), y, tabWidth, 20);
        int searchbarWidth = listWidth - 4 - 22;
        this.searchbar = new TextField(x, y += 22, searchbarWidth, 20, Tooltips::empty, text -> this.blockList.update(), null);
        this.searchbar.setHint(Texts.translatable("rsmm.gui.searchbar.hint"));
        BasicButton clear = new BasicButton(x + searchbarWidth + 2, y, 20, 20, () -> Texts.literal("X"), Tooltips::empty, (button, event) -> {
            this.searchbar.clear();
            return true;
        });
        y = this.blockList.getY() + this.blockList.getTotalHeight() - 24 + 2;
        this.add = new BasicButton(x, y, 20, 20, () -> Texts.literal("+").format(Formatting.GREEN), Tooltips::empty, (button, event) -> {
            this.add();
            return true;
        });
        this.remove = new BasicButton(x + 22, y, 20, 20, () -> Texts.literal("-").format(Formatting.RED), Tooltips::empty, (button, event) -> {
            this.remove();
            return true;
        });
        this.create = new TextField(x + 44, y, listWidth - 2 - 44 - 2, 20, () -> this.nextBlockKey() == null ? Tooltips.translatable("rsmm.gui.defaultMeterProperties.createbar.invalid") : Tooltips.empty(), text -> {
            class_2960 key = this.nextBlockKey();
            this.add.setActive(key != null && !key.method_12832().isBlank());
        }, null);
        this.create.setHint(Texts.translatable("rsmm.gui.defaultMeterProperties.createbar.hint"));
        SuggestionsMenu blockSuggestions = this.create.setSuggestions(SuggestionsProvider.resources(class_7924.field_41254, true));
        x = this.getX() + this.getWidth() - listWidth - 10;
        y = this.getY() + 30;
        this.propertiesList = new ScrollableList(listWidth, listHeight, 6, 3);
        this.propertiesList.setDrawBackground(true);
        this.propertiesList.setX(x);
        this.propertiesList.setY(y);
        x = this.getX() + this.getWidth() / 2;
        y = this.getY() + this.getHeight() - 28;
        BasicButton cancel = new BasicButton(x - 154, y, 150, 20, Texts::guiCancel, Tooltips::empty, (button, event) -> {
            this.close();
            return true;
        });
        BasicButton done = new BasicButton(x + 4, y, 150, 20, Texts::guiDone, Tooltips::empty, (button, event) -> {
            this.save();
            this.close();
            return true;
        });
        this.addChild(blockSuggestions);
        this.addChild(this.blockList);
        this.addChild(this.propertiesList);
        this.addChild(defaultsTab);
        this.addChild(overridesTab);
        this.addChild(this.searchbar);
        this.addChild(clear);
        this.addChild(this.add);
        this.addChild(this.remove);
        this.addChild(this.create);
        this.addChild(cancel);
        this.addChild(done);
        this.selectTab(this.currentTab == null ? Tab.BUILT_IN : this.currentTab);
        this.selectBlock(null);
    }

    @Override
    protected boolean hasTransparentBackground() {
        return false;
    }

    private Button createTabButton(final Tab tab, int x, int y, int width, int height) {
        return new BasicButton(x, y, width, height, tab::getName, Tooltips::empty, (button, event) -> {
            this.selectTab(tab);
            this.selectBlock(null);
            return true;
        }){

            @Override
            public boolean isActive() {
                return super.isActive() && DefaultMeterPropertiesScreen.this.currentTab != tab;
            }
        };
    }

    private void selectTab(Tab tab) {
        this.currentTab = tab;
        this.blockList.clear();
        this.searchbar.clear();
        switch (this.currentTab.ordinal()) {
            case 0: {
                this.blockList.setBottomBorder(3);
                this.blockList.add(this.defaults.keySet());
                break;
            }
            case 1: {
                this.blockList.setBottomBorder(27);
                this.blockList.add(this.overrides.keySet());
            }
        }
        this.blockList.update();
        this.add.setVisible(this.currentTab == Tab.OVERRIDES);
        this.remove.setVisible(this.currentTab == Tab.OVERRIDES);
        this.create.setVisible(this.currentTab == Tab.OVERRIDES);
        this.create.clear();
    }

    private void selectBlock(class_2960 key) {
        this.currentBlock = key;
        if (this.currentTab == Tab.OVERRIDES) {
            this.remove.setActive(this.currentBlock != null);
        }
        this.initPropertiesList();
    }

    private void initPropertiesList() {
        int buttonWidth;
        this.propertiesList.clear();
        EditableMeterProperties properties = this.getCurrentProperties();
        if (properties == null) {
            return;
        }
        boolean force = this.currentTab != Tab.BUILT_IN;
        int totalWidth = this.propertiesList.getEffectiveWidth();
        int n = totalWidth > 300 ? 150 : (buttonWidth = totalWidth > 200 ? 100 : 50);
        if (force || properties.getName() != null) {
            MeterPropertyElement name = new MeterPropertyElement(totalWidth, buttonWidth, "name");
            name.addControl("", (Button)new TextField(0, 0, 0, 0, Tooltips::empty, text -> {
                properties.setName((String)text);
                name.update();
            }, properties::name));
            switch (this.currentTab.ordinal()) {
                case 0: {
                    name.setActive(false);
                    break;
                }
                case 1: {
                    name.setActive(properties.getName() != null);
                    name.withToggle(on -> properties.setName(on != false ? "" : null));
                }
            }
            this.propertiesList.add(name);
        }
        if (force || properties.getColor() != null) {
            MeterPropertyElement color = new MeterPropertyElement(totalWidth, buttonWidth, "color");
            color.addControl("hex", style -> style.withColor(properties.color()), (Button)new TextField(0, 0, 0, 0, Tooltips::empty, text -> {
                try {
                    properties.setColor(ColorUtils.fromRGBString(text));
                    color.update();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }, () -> ColorUtils.toRGBString(properties.color())));
            color.addControl("red", style -> style.withColor(Formatting.RED), (Button)new Slider(0, 0, 0, 0, () -> {
                int c = properties.color();
                int red = ColorUtils.getRed(c);
                return Texts.literal(String.valueOf(red));
            }, Tooltips::empty, value -> {
                int red = (int)Math.round(value * 255.0);
                int c = ColorUtils.setRed(properties.color(), red);
                properties.setColor(c);
                color.update();
            }, () -> {
                int c = properties.color();
                int red = ColorUtils.getRed(c);
                return (double)red / 255.0;
            }, 255L));
            color.addControl("green", style -> style.withColor(Formatting.GREEN), (Button)new Slider(0, 0, 0, 0, () -> {
                int c = properties.color();
                int green = ColorUtils.getGreen(c);
                return Texts.literal(String.valueOf(green));
            }, Tooltips::empty, value -> {
                int green = (int)Math.round(value * 255.0);
                int c = ColorUtils.setGreen(properties.color(), green);
                properties.setColor(c);
                color.update();
            }, () -> {
                int c = properties.color();
                int green = ColorUtils.getGreen(c);
                return (double)green / 255.0;
            }, 255L));
            color.addControl("blue", style -> style.withColor(Formatting.BLUE), (Button)new Slider(0, 0, 0, 0, () -> {
                int c = properties.color();
                int blue = ColorUtils.getBlue(c);
                return Texts.literal(String.valueOf(blue));
            }, Tooltips::empty, value -> {
                int blue = (int)Math.round(value * 255.0);
                int c = ColorUtils.setBlue(properties.color(), blue);
                properties.setColor(c);
                color.update();
            }, () -> {
                int c = properties.color();
                int blue = ColorUtils.getBlue(c);
                return (double)blue / 255.0;
            }, 255L));
            switch (this.currentTab.ordinal()) {
                case 0: {
                    color.setActive(false);
                    break;
                }
                case 1: {
                    color.setActive(properties.getColor() != null);
                    color.withToggle(on -> properties.setColor(on != false ? Integer.valueOf(0xFFFFFF) : null));
                }
            }
            this.propertiesList.add(color);
        }
        if (force || properties.getMovable() != null) {
            MeterPropertyElement movable = new MeterPropertyElement(totalWidth, buttonWidth, "movable");
            movable.addControl("", (Button)new ToggleButton(0, 0, 0, 0, properties::movable, button -> {
                properties.toggleMovable();
                movable.update();
            }));
            switch (this.currentTab.ordinal()) {
                case 0: {
                    movable.setActive(false);
                    break;
                }
                case 1: {
                    movable.setActive(properties.getMovable() != null);
                    movable.withToggle(on -> properties.setMovable(on != false ? Boolean.valueOf(true) : null));
                }
            }
            this.propertiesList.add(movable);
        }
        if (force || properties.getEventTypes() != null) {
            MeterPropertyElement eventTypes = new MeterPropertyElement(totalWidth, buttonWidth, "eventTypes");
            for (EventType type : EventType.ALL) {
                eventTypes.addControl(type.getName(), UnaryOperator.identity(), (Button)new ToggleButton(0, 0, 0, 0, () -> properties.hasEventType(type), button -> {
                    properties.toggleEventType(type);
                    eventTypes.update();
                }));
            }
            switch (this.currentTab.ordinal()) {
                case 0: {
                    eventTypes.setActive(false);
                    break;
                }
                case 1: {
                    eventTypes.setActive(properties.getEventTypes() != null);
                    eventTypes.withToggle(on -> properties.setEventTypes(on != false ? Integer.valueOf(0) : null));
                }
            }
            this.propertiesList.add(eventTypes);
        }
        this.propertiesList.update();
    }

    private EditableMeterProperties getCurrentProperties() {
        if (this.currentBlock == null) {
            return null;
        }
        switch (this.currentTab.ordinal()) {
            case 0: {
                return this.defaults.get(this.currentBlock);
            }
            case 1: {
                return this.overrides.get(this.currentBlock);
            }
        }
        return null;
    }

    private void add() {
        class_2960 key = this.nextBlockKey();
        if (key != null && this.overrides.putIfAbsent(key, new EditableMeterProperties(this)) == null) {
            this.selectTab(Tab.OVERRIDES);
            this.selectBlock(null);
        }
    }

    private void remove() {
        if (this.currentBlock != null && this.overrides.remove(this.currentBlock) != null) {
            this.selectTab(Tab.OVERRIDES);
            this.selectBlock(null);
        }
    }

    public class_2960 nextBlockKey() {
        try {
            String name = this.create.getValue();
            class_2960 key = class_2960.method_60654((String)name);
            if (!this.overrides.containsKey(key)) {
                return key;
            }
        }
        catch (class_151 class_1512) {
            // empty catch block
        }
        return null;
    }

    private void save() {
        this.meterPropertiesManager.update(this.overrides);
    }

    private class EditableMeterProperties
    extends MeterProperties.MutableMeterProperties {
        public EditableMeterProperties(DefaultMeterPropertiesScreen defaultMeterPropertiesScreen) {
        }

        public EditableMeterProperties(DefaultMeterPropertiesScreen defaultMeterPropertiesScreen, MeterProperties properties) {
            this.fill(properties);
        }

        public String name() {
            String name = this.getName();
            return name == null ? "" : name;
        }

        public int color() {
            Integer color = this.getColor();
            return color == null ? 0xFFFFFF : color;
        }

        public boolean movable() {
            Boolean movable = this.getMovable();
            return movable == null ? true : movable;
        }

        public void toggleMovable() {
            this.setMovable(!this.movable());
        }

        public int eventTypes() {
            Integer eventTypes = this.getEventTypes();
            return eventTypes == null ? 0 : eventTypes;
        }

        @Override
        public boolean hasEventType(EventType type) {
            return (this.eventTypes() & type.flag()) != 0;
        }
    }

    private static enum Tab {
        BUILT_IN("builtIn"),
        OVERRIDES("overrides");

        private final String key;

        private Tab(String key) {
            this.key = key;
        }

        public Text getName() {
            return Texts.translatable("rsmm.gui.defaultMeterProperties.tab." + this.key);
        }
    }
}

