/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.screen;

import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_312;
import redstone.multimeter.client.MultimeterClient;
import redstone.multimeter.client.gui.FontRenderer;
import redstone.multimeter.client.gui.GuiRenderer;
import redstone.multimeter.client.gui.element.AbstractParentElement;
import redstone.multimeter.client.gui.element.input.KeyEvent;
import redstone.multimeter.client.gui.element.input.MouseEvent;
import redstone.multimeter.client.gui.screen.ScreenWrapper;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.texture.Textures;
import redstone.multimeter.client.gui.tooltip.Tooltip;

public abstract class RSMMScreen
extends AbstractParentElement {
    protected final MultimeterClient client = MultimeterClient.INSTANCE;
    protected final class_310 minecraft = MultimeterClient.MINECRAFT;
    protected final FontRenderer font = this.client.getFontRenderer();
    private final Text title;
    private final boolean drawTitle;
    protected ScreenWrapper wrapper;

    protected RSMMScreen(Text title, boolean drawTitle) {
        this.title = title;
        this.drawTitle = drawTitle;
    }

    @Override
    public void render(GuiRenderer renderer, int mouseX, int mouseY) {
        this.renderBackground(renderer);
        this.renderContent(renderer, mouseX, mouseY);
        if (this.drawTitle) {
            int width = this.font.width(this.title);
            int x = this.getX() + (this.getWidth() - width) / 2;
            int y = this.getY() + 6;
            this.font.drawWithShadow(this.title, x, y);
        }
    }

    public void renderTooltip(GuiRenderer renderer, int mouseX, int mouseY) {
        Tooltip tooltip = this.getTooltip(mouseX, mouseY);
        if (!tooltip.isEmpty()) {
            renderer.tooltip(tooltip, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClick(MouseEvent.Click event) {
        return super.mouseClick(event) || this.client.getInputHandler().mouseClick(this, event);
    }

    @Override
    public boolean keyPress(KeyEvent.Press event) {
        return super.keyPress(event) || this.client.getInputHandler().keyPress(this, event);
    }

    @Override
    public boolean mouseScroll(MouseEvent.Scroll event) {
        return this.client.getInputHandler().mouseScroll(this, event) || super.mouseScroll(event);
    }

    @Override
    public final boolean isHovered() {
        return true;
    }

    @Override
    public final void setX(int x) {
    }

    @Override
    public final void setY(int y) {
    }

    public void init(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        this.removeChildren();
        this.initScreen();
        this.update();
        class_1041 window = this.minecraft.method_22683();
        class_312 mouse = this.minecraft.field_1729;
        double mouseX = mouse.method_1603() * (double)window.method_4486() / (double)window.method_4489();
        double mouseY = mouse.method_1604() * (double)window.method_4502() / (double)window.method_4506();
        this.mouseMove(mouseX, mouseY);
    }

    protected abstract void initScreen();

    protected boolean shouldCloseOnEsc() {
        return true;
    }

    public void close() {
        this.minecraft.method_1507(this.wrapper.getParent());
    }

    protected boolean hasTransparentBackground() {
        return this.minecraft.field_1687 != null;
    }

    protected void renderBackground(GuiRenderer renderer) {
        if (this.hasTransparentBackground()) {
            renderer.gradient(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), -1072689136, -804253680);
        } else {
            int x0 = this.getX();
            int y0 = this.getY();
            int x1 = x0 + this.getWidth();
            int y1 = y0 + this.getHeight();
            int u0 = x0 / 2;
            int v0 = y0 / 2;
            int u1 = x1 / 2;
            int v1 = y1 / 2;
            renderer.blit(Textures.OPTIONS_BACKGROUND, x0, y0, x1, y1, u0, v0, u1, v1, -1);
        }
    }

    protected void renderContent(GuiRenderer renderer, int mouseX, int mouseY) {
        super.render(renderer, mouseX, mouseY);
    }

    public Text getTitle() {
        return this.title;
    }

    public boolean isPauseScreen() {
        return true;
    }
}

