/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.text;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import redstone.multimeter.client.gui.text.Formatting;
import redstone.multimeter.client.gui.text.Style;
import redstone.multimeter.client.gui.text.Text;
import redstone.multimeter.client.gui.text.Texts;

abstract class BaseText
implements Text {
    private final List<Text> siblings = new ArrayList<Text>();
    Style style = Style.EMPTY;

    BaseText() {
    }

    @Override
    public Style getStyle() {
        return this.style;
    }

    @Override
    public Text format(Formatting ... formattings) {
        this.style = this.style.applyFormattings(formattings);
        return this;
    }

    @Override
    public Text format(Style style) {
        this.style = style;
        return this;
    }

    @Override
    public Text format(UnaryOperator<Style> styler) {
        this.style = (Style)styler.apply(this.style);
        return this;
    }

    @Override
    public Text append(String text) {
        this.siblings.add(Texts.literal(text));
        return this;
    }

    @Override
    public Text append(Text text) {
        this.siblings.add(text);
        return this;
    }

    @Override
    public String buildString() {
        return this.buildString(false);
    }

    @Override
    public String buildFormattedString() {
        return this.buildString(true);
    }

    private String buildString(boolean formatted) {
        StringBuilder sb = new StringBuilder();
        this.buildString(sb, formatted);
        this.buildString(sb, formatted, this.siblings);
        if (formatted) {
            sb.append((Object)Formatting.RESET);
        }
        return sb.toString();
    }

    abstract void buildString(StringBuilder var1, boolean var2);

    final void buildString(StringBuilder sb, boolean formatted, List<Text> texts) {
        for (Text text : texts) {
            if (formatted) {
                this.style.apply(sb);
            }
            sb.append(formatted ? text.buildFormattedString() : text.buildString());
        }
    }

    @Override
    public class_2561 resolve() {
        class_5250 component = this.buildComponent().method_10862(this.style.resolve());
        for (Text sibling : this.siblings) {
            component.method_10852(sibling.resolve());
        }
        return component;
    }

    abstract class_5250 buildComponent();
}

