/*
 * Decompiled with CFR 0.152.
 */
package redstone.multimeter.client.gui.text;

import java.net.URI;
import java.util.Objects;
import net.minecraft.class_2558;

public class ClickEvent {
    private final Action action;
    private final String value;

    private ClickEvent(Action action, String value) {
        this.action = action;
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClickEvent)) {
            return false;
        }
        ClickEvent event = (ClickEvent)o;
        return this.action == event.action && Objects.equals(this.value, event.value);
    }

    public Action getAction() {
        return this.action;
    }

    public String getValue() {
        return this.value;
    }

    public class_2558 resolve() {
        switch (this.action.ordinal()) {
            case 0: {
                return new class_2558.class_10608(URI.create(this.value));
            }
            case 1: {
                return new class_2558.class_10609(this.value);
            }
            case 2: {
                return new class_2558.class_10610(this.value);
            }
            case 3: {
                return new class_2558.class_10606(this.value);
            }
        }
        throw new IllegalStateException("unable to resolve click event " + this.action.name());
    }

    public static ClickEvent resolve(class_2558 clickEvent) {
        switch (clickEvent.method_10845()) {
            case field_11749: {
                return ClickEvent.openUrl(((class_2558.class_10608)clickEvent).comp_3505().toString());
            }
            case field_11750: {
                return ClickEvent.runCommand(((class_2558.class_10609)clickEvent).comp_3506());
            }
            case field_11745: {
                return ClickEvent.suggestCommand(((class_2558.class_10610)clickEvent).comp_3507());
            }
            case field_21462: {
                return ClickEvent.copyToClipboard(((class_2558.class_10606)clickEvent).comp_3503());
            }
        }
        return null;
    }

    public static ClickEvent openUrl(String url) {
        return new ClickEvent(Action.OPEN_URL, url);
    }

    public static ClickEvent runCommand(String command) {
        return new ClickEvent(Action.RUN_COMMAND, command);
    }

    public static ClickEvent suggestCommand(String command) {
        return new ClickEvent(Action.SUGGEST_COMMAND, command);
    }

    public static ClickEvent copyToClipboard(String text) {
        return new ClickEvent(Action.COPY_TO_CLIPBOARD, text);
    }

    public static enum Action {
        OPEN_URL,
        RUN_COMMAND,
        SUGGEST_COMMAND,
        COPY_TO_CLIPBOARD;

    }
}

